/*
 * tmpfile.c
 *
 * Utility function to create a temporary file, which will be automatically
 * deleted when it is closed.
 *
 * $Id$
 *
 * Written by Keith Marshall <keithmarshall@users.sourceforge.net>
 * Copyright (C) 2014, 2016, MinGW.org Project
 *
 *
 * Permission is hereby granted, free of charge, to any person obtaining a
 * copy of this software and associated documentation files (the "Software"),
 * to deal in the Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, sublicense,
 * and/or sell copies of the Software, and to permit persons to whom the
 * Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice, this permission notice, and the following
 * disclaimer shall be included in all copies or substantial portions of
 * the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
 * OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL
 * THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OF OR OTHER
 * DEALINGS IN THE SOFTWARE.
 *
 */
#include <fcntl.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>

int tmpfile_create( char *template )
{
  int fd;

  /* Create and open a temporary file, scheduling it for
   * automatic deletion on final closure.
   */
  _MKSTEMP_SETMODE( _O_TEMPORARY );
  if( (fd = mkstemp( template )) >= 0 )
  {
    /* Close a duplicate handle on the opened temporary file,
     * to ensure that its directory entry is committed, while
     * keeping the original handle open to prevent immediate
     * deletion of the file itself.
     */
    close( dup( fd ));
  }
  /* Return the handle for the open temporary file, leaving
   * the caller to use it as required, and finally close it.
   */
  return fd;
}

/* $RCSfile$: end of file */
