﻿//----------------------------------------------------------------------
//
//			File:			"EgdTrans.cs"
//			Created:		2017/08/28
//			Author:			M.Nimura(AW-SW)
//			Description:
//
//----------------------------------------------------------------------

using System;
using System.Collections.Generic;
using System.IO;
using System.Linq;
using System.Runtime.InteropServices;
using System.Text;
using System.Text.RegularExpressions;
using System.Threading.Tasks;

using Excel = Microsoft.Office.Interop.Excel;


namespace EgdLoad
{
    class Program
    {
        static void Main(string[] args)
        {
            string stCurrentDir = System.IO.Directory.GetCurrentDirectory();
            Console.WriteLine(stCurrentDir);

            LoadExcel egdExcel = new LoadExcel(stCurrentDir + "/../../" + "改 Eagle データフォーマット検討_フォーマット仕様案_r1.6.xlsx");
            Object[,] data = egdExcel.loadSheet("Lv-2データ");

            new OutEgdStruct("Root", data);
        }
    }
}

//
//  Eagleデータの構造体出力（フォーマットシートからソース出力）
//
class OutEgdStruct
{

    Object[,] cellData;
    public OutEgdStruct(string dataSheetName, Object[,] data)
    {
        this.cellData = data;
        make(dataSheetName);
    }

    //  行の解析結果
    class S_SRCLINE
    {
        public int cp;
        public bool isEnd;
        public bool isStruct;
        public bool isString;
        public bool isSigned;
        public bool isArg;

        public int size;

        public int startColumn;
        public string symbol;
        public string commment;
        public string special;

        public bool isDefArrayStruct;
        public int indexDefArrayStruct;


        override public string ToString()
        {
            string str = "";

            str = cp + "," + startColumn + " ,isStruct=" + isStruct + ",isStr=" + isString + ",isSigned=" + isSigned + ",size=" + size + "(" + symbol + "," + commment + ")";
            return str;
        }

    }

    List<S_SRCLINE> srcLineList = new List<S_SRCLINE>();

    int def_cLabel = 18;
    int def_cType = 19;
    int def_cSize = 20;
    int def_cSpecial = 22;

    int make(string dataSheetName)
    {

        int iHeader = findHeader();
        if (iHeader < 0) return -1;

        {
            S_SRCLINE srcLine = new S_SRCLINE();
            srcLine.cp = -1;
            srcLine.startColumn = 0;
            srcLine.symbol = dataSheetName;
            srcLine.isStruct = true;
            srcLineList.Add(srcLine);
        }


        for (int i = iHeader; i < cellData.GetLength(0); i++)
        {
            //  行の解析
            S_SRCLINE srcLine = setSrcLine(i);

            if (srcLine != null)
            {
                if (srcLine.isEnd) break;
                srcLineList.Add(srcLine);

            }
        }

        //  構造体の構築と出力
        buildStruct("../../../EgdLoad/", dataSheetName);
        return 0;
    }


    //  行の解析
    S_SRCLINE setSrcLine(int cp)
    {
        S_SRCLINE srcLine = new S_SRCLINE();

        srcLine.cp = cp;
        srcLine.startColumn = findStartColumn(cp);

        if (srcLine.startColumn < 0) return null;

        if (cellData[cp, srcLine.startColumn].ToString().Equals("_END"))
        {
            srcLine.isEnd = true;
            return srcLine;
        }

        //  シンボル文字列
        srcLine.symbol = "";
        if (cellData[cp, def_cLabel] != null)
        {
            srcLine.symbol = cellData[cp, def_cLabel].ToString();
        }
        if (srcLine.symbol.Length == 0)
            return null;

        //  コメント文字列
        srcLine.commment = "";
        if (cellData[cp, srcLine.startColumn] != null)
        {
            srcLine.commment = cellData[cp, srcLine.startColumn].ToString();
        }

        if (cellData[cp, def_cType] == null)
        {
            //  型の指定がなければ、構造体宣言とみなす
            srcLine.isStruct = true;
        }
        else
        {
            srcLine.isStruct = false;

            string strType = cellData[cp, def_cType].ToString();

            //  型判定
            bool isSet = setSrcLineType(srcLine, strType, cellData[cp, def_cSize]);

            if (isSet)
            {
            }
            else
            {
                //  1行内、複数項目の判定
                string[] tt = strType.Split(',');

                if (tt.Length == 0)
                {
                    srcLine.isString = true;
                }
                else
                {

                    string[] ss = cellData[cp, def_cSize].ToString().Split(',');
                    setSrcLineType(srcLine, tt[0], ss[0]);
                    srcLine.isArg = true;
                }
            }
        }

        //  特殊コード
        if (cellData[cp, def_cSpecial] != null)
        {
            srcLine.special = cellData[cp, def_cSpecial].ToString();
        }

        return srcLine;
    }

    //  型判定
    bool setSrcLineType(S_SRCLINE srcLine, string strType, object sizeObj)
    {
        if (strType.Equals("N"))
        {
            srcLine.isSigned = false;
            srcLine.size = Int32.Parse(sizeObj.ToString());
        }
        else if (strType.Equals("I"))
        {
            srcLine.isSigned = true;
            srcLine.size = Int32.Parse(sizeObj.ToString());
        }
        else if (strType.Equals("CC"))
        {
            srcLine.isString = true;
        }
        else if (strType.Equals("DBL"))
        {
            srcLine.isString = true;
        }
        else
            return false;
        return true;
    }

    int findHeader()
    {
        int cp = -1;
        for (int i = 1; i <= cellData.GetLength(0); i++)
        {
            if (cellData[i, def_cLabel] == null) continue;
            string label = (string)cellData[i, def_cLabel];

            Console.WriteLine(i + "," + cellData[i, def_cLabel]);
            if (label.Equals("***Header"))
            {
                cp = i;
                break;
            }
        }
        return cp;
    }

    int findStartColumn(int cp)
    {
        int rc = -1;
        for (int i = 1; i <= cellData.GetLength(1); i++)
        {
            if (i >= def_cLabel) break;
            if (cellData[cp, i] == null) continue;
            rc = i;
            break;
        }
        return rc;
    }


    //--------------------------------------------------
    //  構造体の構築用構造
    class S_EGDEFSTRUCT  {
        public int cp;
        public string defStructName;
        //public int indexArrayVar;

        public List<int> memberList;
    }

    List<S_EGDEFSTRUCT> defStructList = new List<S_EGDEFSTRUCT>();

    //  構造体の構築と出力
    void buildStruct(string path, string dataSheetName) 
    {
        //  構造体の構造構築
        buildStructData(defStructList, 0, srcLineList);

        //  構造体の出力
        outStructData(path, dataSheetName,defStructList, srcLineList);
    }

    //  構造体の構造構築(再帰)
    int buildStructData(List<S_EGDEFSTRUCT> defStructList, int pp, List<S_SRCLINE> srcLineList)
    {

        S_SRCLINE parentSrcLine = srcLineList[pp];

        S_EGDEFSTRUCT egs = new S_EGDEFSTRUCT();

        egs.cp = pp;
        egs.defStructName = convStructTypeName(parentSrcLine.symbol);

        int     indexArrayVar = getStructArrayIndex(pp, srcLineList, parentSrcLine.symbol);
        if(indexArrayVar >= 0)
        {
            //  配列であれば、配列数の変数を記憶
            srcLineList[indexArrayVar].isDefArrayStruct = true;
            srcLineList[indexArrayVar].indexDefArrayStruct = pp;
        }
        egs.memberList = new List<int>();

        //  構造体定義の重複確認
        for(int i=0; i<defStructList.Count; i++)
        {
            if(defStructList[i].defStructName.Equals(egs.defStructName))
            {
                return pp + 1;
            }
        }

        //  構造体リストへ登録
        defStructList.Add(egs);

        int cp = pp + 1;

        while (cp < srcLineList.Count)
        {
            S_SRCLINE srcLine = srcLineList[cp];

            if (srcLine.startColumn <= parentSrcLine.startColumn)
                return cp;

            //  メンバーの配列番号を登録
            egs.memberList.Add(cp);

            if (srcLine.isStruct)
            {
                //  下位構造体の構造構築
                cp = buildStructData(defStructList, cp, srcLineList);
            }
            else
            {
                cp++;
            }
        }
        return cp;
    }

    //  構造体の出力
    void outStructData(string path, string dataSheetName, List<S_EGDEFSTRUCT> defStructList, List<S_SRCLINE> srcLineList)
    {
        string fileName = "eds" + dataSheetName + ".h";
        StreamWriter writer = new StreamWriter(path + "/" + fileName, false, Encoding.GetEncoding("Shift_JIS"));

        {
            string header = "//----------------------------------------------------------------------" + "\n" +
                "//" + "\n" +
                "//\t\t\tFile:\t\t\t" + fileName + "\n" +
                "//\t\t\tCreated:\t\t" + DateTime.Today.ToString() + "\n" +
                "//\t\t\tAuthor:\t\t\tedsTrans" + "\n" +
                "//\t\t\tDescription:" + "\n" +
                "//" + "\n" +
                "//----------------------------------------------------------------------" + "\n";

            writer.WriteLine(header);
        }

        //  リストの最後から出力
        for (int i = defStructList.Count-1; i >= 0; i--)
        {
            S_EGDEFSTRUCT egs = defStructList[i];
            string line = "//\t" + srcLineList[egs.cp].commment + "\n";
            line = line + "struct\t" + egs.defStructName + "\t{";

            writer.WriteLine(line);

            for (int j = 0; j < egs.memberList.Count; j++)
            {
                S_SRCLINE srcLine = srcLineList[egs.memberList[j]];

                //  メンバー宣言の文字列作成
                line = makeMemberStr(srcLine);
                writer.WriteLine("\t" + line);
            }

            //  クラスへのロード関数の文字列作成
            outLoadFunc(writer, egs, srcLineList);

            if(i == 0)
            {
                //  Topクラスにファイル読み込みメソッド
                writeTopClass(writer);
            }

            writer.WriteLine( "};\n" );
        }
        writer.Close();
    }

    //  ロード関数の作成
    void outLoadFunc(StreamWriter writer, S_EGDEFSTRUCT egs, List<S_SRCLINE> srcLineList)
    {
        string line;
        string tab2 = "\t\t";
        string tab3 = tab2 + "\t";
        string tab4 = tab3 + "\t";

        line = "\n\tint load(EgdLoad& egd)" + "\n" +
            "\t{" + "\n" +
            tab2 + "int rc = 0;" + "\n" +
            tab2 + "bool isFirst = true;" + "\n" +
            "\n" +
            tab2 + "while (true)" + "\n" +
            tab2 + "{" + "\n" +
            tab3 + "rc = 0;" + "\n" +
            tab3 + "std::string label = egd.getLabel();" + "\n" +
            tab3 + "if (label.empty())	return -1;" + "\n" ;

        writer.WriteLine(line);

        S_SRCLINE srcLine;
        string firstLabel = null;

        for (int i=0;i<egs.memberList.Count; i++)
        {
            int cp = egs.memberList[i];
            srcLine = srcLineList[cp];

            if (i == 0) line = tab3;
            else line = tab3 + "else ";

            string ifLine = "(label == \"" + convLabelName(srcLine.symbol) + "\")";
            if (srcLine.special != null) ifLine = srcLine.special;

            if (i == 0)
            {
                line = line + "if (" + ifLine + " && isFirst) {" + "\n" +
                    tab4 + "isFirst = false;";

                firstLabel = convLabelName(srcLine.symbol);
            }
            else
            {
                line = line + "if " + ifLine + " {";
            }
            writer.WriteLine(line);

            string memberName = convStructMemberName(srcLine.symbol);
            string typeName = makeMemberTypeName(srcLine);

            if (srcLine.isStruct)
            {
                int     indexVar = getStructArrayIndex(cp, srcLineList, srcLine.symbol);
                if(indexVar < 0)
                {
                    line = "rc = " + memberName + ".load(egd);";
                    writer.WriteLine(tab4 + line);
                }
                else
                {
                    //  構造体配列の場合
                    string varMember = convStructMemberName(srcLineList[indexVar].symbol);
                    memberName = memberName.Substring(1);

                    line = "rc = " + memberName + "[" + varMember + "++].load(egd);";
                    writer.WriteLine(tab4 + line);
                }
            }
            else if (srcLine.isString)
            {
                line = memberName + " = " + "(" + typeName + ")" + "egd.getString();";
                writer.WriteLine(tab4 + line);
            }
            else if(srcLine.isDefArrayStruct)
            {
                line = memberName + " = 0;";
                writer.WriteLine(tab4 + line);

                //  構造体配列数の場合、配列の確保
                int idx = srcLine.indexDefArrayStruct;
                string  stMember = convStructMemberName(srcLineList[idx].symbol).Substring(1);
                string  stType = makeMemberTypeName(srcLineList[idx]);

                line = stMember + " = " + "(" + stType + "*)egd.mallocArray(sizeof(" + stType + "), egd.getUInt());";
                writer.WriteLine(tab4 + line);
            }
            else if (srcLine.isArg)
            {
                //  行内複数メンバー宣言を展開
                string[] str = convArgList(srcLine.symbol);
                for(int j=0; j<str.Length;j++)
                {
                    if (srcLine.isSigned)
                    {
                        line = str[j] + " = " + "(" + typeName + ")" + "egd.getInt(" + j+ ");";
                    }
                    else
                    {
                        line = str[j] + " = " + "(" + typeName + ")" + "egd.getUInt(" + j + ");";
                    }
                    writer.WriteLine(tab4 + line);
                }
                writer.WriteLine(tab4 + "return 0;");

            }
            else if (srcLine.isSigned)
            {
                line = memberName + " = " + "(" + typeName + ")" + "egd.getInt();";
                writer.WriteLine(tab4 + line);
            }
            else
            {
                line = memberName + " = " + "(" + typeName + ")" + "egd.getUInt();";
                writer.WriteLine(tab4 + line);
            }
            writer.WriteLine(tab3 + "}");

        }

        srcLine = srcLineList[egs.cp];
        if (srcLine.symbol.IndexOf("[") < 0)
        {
            if (!firstLabel.Equals(srcLine.symbol))
            {
                line = tab3 + "else if (label == \"" + srcLine.symbol + "\") {\n" + tab3 + "}";
                writer.WriteLine(line);

            }
        }

        writer.WriteLine(tab3 + "else return -1;");

        writer.WriteLine("");
        writer.WriteLine(tab3 + "if(rc == 0) egd.next();");
        writer.WriteLine(tab2 + "}");
        writer.WriteLine("\t}");

    }

    void writeTopClass(StreamWriter writer)
    {
        string line = "\n" +
                "\t" + "EgdLoad egdLoad;" + "\n" +
                "\n" +
                "\t" + "int readDataFile(char * fileName)" + "\n" +
                "\t" + "{" + "\n" +
                "\t\t" + "int rc = egdLoad.readDataFile(fileName);" + "\n" +
                "\t\t" + "if (rc < 0) return -1;" + "\n" +
                "\n" +
                "\t\t" + "load(egdLoad); " + "\n" +
                "\n" +
                "\t\t" + "egdLoad.endDataFile(); " + "\n" +
                "\t\t" + "return 0; " + "\n" +
                "\t" + "} " + "\n";
        writer.WriteLine(line);
    }


    //  メンバーの宣言文字列
    string makeMemberStr(S_SRCLINE srcLine)
    {
        string typeName = makeMemberTypeName(srcLine);
        string str;

        if (srcLine.symbol.IndexOf("(") > 0)
        {
            //  行内複数メンバー宣言
            string[] ss = convArgList(srcLine.symbol);
            
            str = "";
            for (int i = 0; i < ss.Length; i++)
            {
                string s = makeDefMemberStr(typeName, ss[i], srcLine.commment);
                if (i == 0) str = s;
                else str = str + "\n\t" + s;
            }
        }
        else
        {
            str = makeDefMemberStr(typeName, convStructMemberName(srcLine.symbol), srcLine.commment);
        }

        return str;
    }

    string makeMemberTypeName(S_SRCLINE srcLine)
    {
        string typeName = "";

        if (srcLine.isStruct)
        {
            typeName = convStructTypeName(srcLine.symbol);
        }
        else if (srcLine.isString)
        {
            typeName = "char*";
        }
        else if (srcLine.isSigned)
        {
            if (srcLine.size == 1) typeName = "char";
            else if (srcLine.size <= 2) typeName = "short";
            else if (srcLine.size <= 4) typeName = "int";
        }
        else
        {
            if (srcLine.size == 1) typeName = "unsigned char";
            else if (srcLine.size <= 2) typeName = "unsigned short";
            else if (srcLine.size <= 4) typeName = "unsigned int";
        }
        return typeName;
    }

    //  配列構造体の配列数変数のindexを取得
    int getStructArrayIndex(int pp, List<S_SRCLINE> srcLineList, string structName)
    {
        //[]を消す
        int idx = structName.IndexOf("[");
        if (idx < 0) return -1;

        int eidx = structName.IndexOf("]");
        if (eidx < 0) return -1;

        string varStr = structName.Substring(idx+1, eidx - idx -1);

        int index = -1;
        for(int i=pp-1; i>=0; i--)
        {
            if(srcLineList[i].symbol.Equals(varStr))
            {
                index = i;
                break;
            }
        }

        return index;
    }

    string convLabelName(string str)
    {
        //  [以降を外す
        int idx = str.IndexOf("[");
        if (idx > 0)
        {
            str = str.Substring(0, idx);
        }

        //  (以降を外す
        idx = str.IndexOf("(");
        if (idx > 0)
        {
            str = str.Substring(0, idx);
        }
        return str;
    }

    string[] convArgList(string str)
    {
        //  (以降を外す
        int si = str.IndexOf("(");
        int ei = str.IndexOf(")");
        si = (si < 0) ? 0 : si + 1;
        ei = (ei < 0) ? str.Length : ei;

        string strA = str.Substring(si, ei - si);

        string[] ss = strA.Split(',');
        return ss;
    }

    string convStructTypeName(string structName)
    {
        if (structName.IndexOf(",") >= 0)
        {
            //  行内複数メンバー宣言
            return convStructTypeName(structName.Split(',')[0]);
        }

        //*を消す
        string str = structName.Replace("*", "");

        //[]を消す
        int idx = str.IndexOf("[");
        if(idx > 0)
        {
            str = str.Substring(0, idx);
        }

        //  EDS_を追加
        str = "EDS_" + str;
        return str;
    }

    string convStructMemberName(string structName)
    {
        if (structName.IndexOf(",") >= 0)
        {
            return convStructMemberName(structName.Split(',')[1]);
        }

        return convMemberName(structName);

    }

    string convMemberName(string memberName)
    {
        //  *を_に変換
        string str = memberName.Replace('*', '_');

        //[]を消す
        if (str.IndexOf("[") > 0)
        {
            int si = str.IndexOf("[");
            str = "*" + str.Substring(0, si);
        }

        //  小文字に変換
        string lstr = str.ToLower();
        if (str.Equals(lstr)) return str;

        //  先頭を小文字に
        int idx = -1;
        for (int i = 0; i < str.Length; i++)
        {
            if (str[i] != lstr[i])
            {
                idx = i;
                break;
            }
            if('a' <= str[i] && str[i] <= 'z')
            {
                idx = i;
                break;
            }
        }
        return lstr.Substring(0, idx + 1) + str.Substring(idx + 1);
    }

    //  メンバー宣言行の整形
    string makeDefMemberStr(string typeStr, string label, string comment)
    {
        string str;

        str = typeStr;

        int numColumn = 24;

        int nTab = ((numColumn - typeStr.Length + 3) / 4);
        if (nTab <= 0) nTab = 1;
        str = addTab(str, nTab);

        str += (label + ";");

        nTab = ((numColumn - (label.Length + 1) + 3) / 4);
        if (nTab <= 0) nTab = 1;
        str = addTab(str, nTab);

        str += ("//\t" + comment);

        return str;

    }

    string addTab(string str, int numTab)
    {
        for (int i = 0; i < numTab; i++)
        {
            str += "\t";
        }
        return str;
    }
}


class LoadExcel
{

    Excel.Application xlApplication = null;
    Excel.Workbooks xlWorkbooks = null;
    Excel.Workbook xlWorkbook = null;

    Excel.Sheets xlSheets = null;
    Excel.Worksheet xlWorksheet = null;


    public LoadExcel(string filePath)
    {
        //string filePath = Application.StartupPath + @"\Data.xlsx";

        try
        {
            xlApplication = new Excel.Application();
            xlApplication.Visible = false;

            xlWorkbooks = xlApplication.Workbooks;
            xlWorkbook = xlWorkbooks.Open(filePath);
        }
        catch (Exception ex)
        {
            Console.WriteLine(ex.Message);

            finalProc();
        }

    }

    void finalProc()
    {
        if (xlSheets != null) Marshal.FinalReleaseComObject(xlSheets);
        if (xlWorkbook != null) Marshal.FinalReleaseComObject(xlWorkbook);
        if (xlWorkbooks != null) Marshal.FinalReleaseComObject(xlWorkbooks);
        if (xlApplication != null) Marshal.FinalReleaseComObject(xlApplication);

    }

    public object[,] loadSheet(object sheetName)
    {
        Excel.Sheets xlSheets = null;
        Excel.Worksheet xlWorksheet = null;

        object[,] cellData = null;
        try
        {
            xlSheets = xlWorkbook.Sheets;
            xlWorksheet = xlSheets[sheetName];

            //cellData = new object[10, 5]; //受け取るデータの個数分（行、列セル数を指定）
            //Excel.Range range = xlWorksheet.get_Range("A1", "E10");

            //  有効範囲全て
            Excel.Range sRange = xlWorksheet.Cells[1, 1];
            Excel.Range range = xlWorksheet.get_Range(sRange, xlWorksheet.UsedRange);

            //  取得データの領域確保と取得
            cellData = new object[range.Rows.Count, range.Columns.Count];
            cellData = range.Value;

            xlWorkbooks.Close();
            xlApplication.Quit();

#if FIRSTTRY
            //データを出力 要素数は1から格納されています
            for (int r = 1; r <= cellData.GetLength(0); r++)
            {
                for (int c = 1; c <= cellData.GetLength(1); c++)
                {
                    Console.Write(string.Format(" {0} ", cellData[r, c]));
                }

                Console.WriteLine(string.Empty);
            }
#endif
        }
        catch (Exception ex)
        {
            Console.WriteLine(ex.Message);
        }
        finally
        {
            finalProc();
        }

        return cellData;
    }

    public object[,] loadCells(object sheetName, int startRow, int startColumn, int numRow, int numColumn)
    {

        object[,] cellData = null;
        try
        {
            xlSheets = xlWorkbook.Sheets;
            xlWorksheet = xlSheets[sheetName];

            //  指定範囲
            Excel.Range sRange = xlWorksheet.Cells[startRow, startColumn];
            Excel.Range eRange = xlWorksheet.Cells[startRow + numRow - 1, startColumn + numColumn - 1];

            Excel.Range range = xlWorksheet.get_Range(sRange, eRange);


            //  取得データの領域確保と取得
            cellData = new object[range.Rows.Count, range.Columns.Count];
            cellData = range.Value;

            xlWorkbooks.Close();
            xlApplication.Quit();

            //データを出力 要素数は1から格納されています
            for (int r = 1; r <= cellData.GetLength(0); r++)
            {
                for (int c = 1; c <= cellData.GetLength(1); c++)
                {
                    Console.Write(string.Format(" {0} ", cellData[r, c]));
                }

                Console.WriteLine(string.Empty);
            }

        }
        catch (Exception ex)
        {
            Console.WriteLine(ex.Message);
        }
        finally
        {
            finalProc();
        }

        return cellData;
    }

}

