//----------------------------------------------------------------------
//
//			File:			edsRoot.h
//			Created:		17/08/29 () 0:00:00
//			Author:			edsTrans
//			Description:
//
//----------------------------------------------------------------------

//	[W_
struct	EDS_li_LineXY	{
	unsigned int			x;						//	KWiX,Yj
	unsigned int			y;						//	KWiX,Yj

	int load(EgdLoad& egd)
	{
		int rc = 0;
		bool isFirst = true;

		while (true)
		{
			rc = 0;
			std::string label = egd.getLabel();
			if (label.empty())	return -1;

			if ((label == "li_LineXY") && isFirst) {
				isFirst = false;
				x = (unsigned int)egd.getUInt(0);
				y = (unsigned int)egd.getUInt(1);
				return 0;
			}
			else return -1;

			if(rc == 0) egd.next();
		}
	}
};

//	[f[^̕
struct	EDS_LineInfoRec	{
	unsigned short			_lineInfoRec;			//	[f[^
	unsigned char			li_AcrossType;			//	ׂ
	unsigned int			li_LineType;			//	
	unsigned short			li_LineXYNum;			//	[W_
	EDS_li_LineXY			*li_LineXY;				//	[W_

	int load(EgdLoad& egd)
	{
		int rc = 0;
		bool isFirst = true;

		while (true)
		{
			rc = 0;
			std::string label = egd.getLabel();
			if (label.empty())	return -1;

			if ((label == "*LineInfoRec") && isFirst) {
				isFirst = false;
				_lineInfoRec = (unsigned short)egd.getUInt();
			}
			else if (label == "li_AcrossType") {
				li_AcrossType = (unsigned char)egd.getUInt();
			}
			else if (label == "li_LineType") {
				li_LineType = (unsigned int)egd.getUInt();
			}
			else if (label == "li_LineXYNum") {
				li_LineXYNum = 0;
				li_LineXY = (EDS_li_LineXY*)egd.mallocArray(sizeof(EDS_li_LineXY), egd.getUInt());
			}
			else if (label == "li_LineXY") {
				rc = li_LineXY[li_LineXYNum++].load(egd);
			}
			else return -1;

			if(rc == 0) egd.next();
		}
	}
};

//	[
struct	EDS_LineInfo	{
	unsigned char			_lineInfo;				//	[
	unsigned short			li_Num;					//	[f[^
	EDS_LineInfoRec			*_lineInfoRec;			//	[f[^̕

	int load(EgdLoad& egd)
	{
		int rc = 0;
		bool isFirst = true;

		while (true)
		{
			rc = 0;
			std::string label = egd.getLabel();
			if (label.empty())	return -1;

			if ((label == "*LineInfo") && isFirst) {
				isFirst = false;
				_lineInfo = (unsigned char)egd.getUInt();
			}
			else if (label == "li_Num") {
				li_Num = 0;
				_lineInfoRec = (EDS_LineInfoRec*)egd.mallocArray(sizeof(EDS_LineInfoRec), egd.getUInt());
			}
			else if (label == "*LineInfoRec") {
				rc = _lineInfoRec[li_Num++].load(egd);
			}
			else return -1;

			if(rc == 0) egd.next();
		}
	}
};

//	[L
struct	EDS_ld_IsLineInfo	{
	unsigned char			left;					//	[L
	unsigned char			right;					//	[L

	int load(EgdLoad& egd)
	{
		int rc = 0;
		bool isFirst = true;

		while (true)
		{
			rc = 0;
			std::string label = egd.getLabel();
			if (label.empty())	return -1;

			if ((label == "ld_IsLineInfo") && isFirst) {
				isFirst = false;
				left = (unsigned char)egd.getUInt(0);
				right = (unsigned char)egd.getUInt(1);
				return 0;
			}
			else return -1;

			if(rc == 0) egd.next();
		}
	}
};

//	[f[^
struct	EDS_LaneNo	{
	unsigned char			_laneNo;				//	[No
	unsigned char			ld_LaneType;			//	[
	unsigned char			ld_GrpConnTypeSta;		//	O[vԐڑin[j
	unsigned char			ld_GrpConnTypeEnd;		//	O[vԐڑiI[j
	EDS_ld_IsLineInfo		ld_IsLineInfo;			//	[L
	EDS_LineInfo			_lineInfo;				//	[
	EDS_LineInfo			_lineInfoR;				//	[
	short					lcExitConnLinkId;		//	[ʍsKID

	int load(EgdLoad& egd)
	{
		int rc = 0;
		bool isFirst = true;

		while (true)
		{
			rc = 0;
			std::string label = egd.getLabel();
			if (label.empty())	return -1;

			if ((label == "*LaneNo") && isFirst) {
				isFirst = false;
				_laneNo = (unsigned char)egd.getUInt();
			}
			else if (label == "ld_LaneType") {
				ld_LaneType = (unsigned char)egd.getUInt();
			}
			else if (label == "ld_GrpConnTypeSta") {
				ld_GrpConnTypeSta = (unsigned char)egd.getUInt();
			}
			else if (label == "ld_GrpConnTypeEnd") {
				ld_GrpConnTypeEnd = (unsigned char)egd.getUInt();
			}
			else if (label == "ld_IsLineInfo") {
				rc = ld_IsLineInfo.load(egd);
			}
			else if (egd.getLine() == "*LineInfo:0") {
				rc = _lineInfo.load(egd);
			}
			else if (egd.getLine() == "*LineInfo:1") {
				rc = _lineInfoR.load(egd);
			}
			else if (label == "lcExitConnLinkId") {
				lcExitConnLinkId = (short)egd.getInt();
			}
			else return -1;

			if(rc == 0) egd.next();
		}
	}
};

//	[O\v
struct	EDS_LaneGrpNo	{
	unsigned short			_laneGrpNo;				//	[O[vNo
	unsigned char			lg_GrpType;				//	O[v
	unsigned char			lg_LaneDataNum;			//	[f[^
	EDS_LaneNo				*_laneNo;				//	[f[^

	int load(EgdLoad& egd)
	{
		int rc = 0;
		bool isFirst = true;

		while (true)
		{
			rc = 0;
			std::string label = egd.getLabel();
			if (label.empty())	return -1;

			if ((label == "*LaneGrpNo") && isFirst) {
				isFirst = false;
				_laneGrpNo = (unsigned short)egd.getUInt();
			}
			else if (label == "lg_GrpType") {
				lg_GrpType = (unsigned char)egd.getUInt();
			}
			else if (label == "lg_LaneDataNum") {
				lg_LaneDataNum = 0;
				_laneNo = (EDS_LaneNo*)egd.mallocArray(sizeof(EDS_LaneNo), egd.getUInt());
			}
			else if (label == "*LaneNo") {
				rc = _laneNo[lg_LaneDataNum++].load(egd);
			}
			else return -1;

			if(rc == 0) egd.next();
		}
	}
};

//	H[f[^̕
struct	EDS_RoadLaneRec	{
	unsigned short			__roadLaneRec;			//	H[f[^
	int						rl_LinkId;				//	NIDitj
	unsigned short			rl_LaneGrpNum;			//	[O[v
	EDS_LaneGrpNo			*_laneGrpNo;			//	[O\v

	int load(EgdLoad& egd)
	{
		int rc = 0;
		bool isFirst = true;

		while (true)
		{
			rc = 0;
			std::string label = egd.getLabel();
			if (label.empty())	return -1;

			if ((label == "**RoadLaneRec") && isFirst) {
				isFirst = false;
				__roadLaneRec = (unsigned short)egd.getUInt();
			}
			else if (label == "rl_LinkId") {
				rl_LinkId = (int)egd.getInt();
			}
			else if (label == "rl_LaneGrpNum") {
				rl_LaneGrpNum = 0;
				_laneGrpNo = (EDS_LaneGrpNo*)egd.mallocArray(sizeof(EDS_LaneGrpNo), egd.getUInt());
			}
			else if (label == "*LaneGrpNo") {
				rc = _laneGrpNo[rl_LaneGrpNum++].load(egd);
			}
			else return -1;

			if(rc == 0) egd.next();
		}
	}
};

//	H[f[^Xg
struct	EDS_RoadLane	{
	unsigned short			rl_Num;					//	H[f[^
	EDS_RoadLaneRec			*__roadLaneRec;			//	H[f[^̕

	int load(EgdLoad& egd)
	{
		int rc = 0;
		bool isFirst = true;

		while (true)
		{
			rc = 0;
			std::string label = egd.getLabel();
			if (label.empty())	return -1;

			if ((label == "rl_Num") && isFirst) {
				isFirst = false;
				rl_Num = 0;
				__roadLaneRec = (EDS_RoadLaneRec*)egd.mallocArray(sizeof(EDS_RoadLaneRec), egd.getUInt());
			}
			else if (label == "**RoadLaneRec") {
				rc = __roadLaneRec[rl_Num++].load(egd);
			}
			else if (label == "***RoadLane") {
			}
			else return -1;

			if(rc == 0) egd.next();
		}
	}
};

//	e͈͂̍W
struct	EDS_area	{
	int						xmin;					//	e͈͂̍W
	int						ymin;					//	e͈͂̍W
	int						xmax;					//	e͈͂̍W
	int						ymax;					//	e͈͂̍W

	int load(EgdLoad& egd)
	{
		int rc = 0;
		bool isFirst = true;

		while (true)
		{
			rc = 0;
			std::string label = egd.getLabel();
			if (label.empty())	return -1;

			if ((label == "area") && isFirst) {
				isFirst = false;
				xmin = (int)egd.getInt(0);
				ymin = (int)egd.getInt(1);
				xmax = (int)egd.getInt(2);
				ymax = (int)egd.getInt(3);
				return 0;
			}
			else return -1;

			if(rc == 0) egd.next();
		}
	}
};

//	[gf[^wb_
struct	EDS_Header	{
	char*					version;				//	o[W
	unsigned short			sourceFormat;			//	ϊtH[}bg
	short					level;					//	x
	EDS_area				area;					//	e͈͂̍W

	int load(EgdLoad& egd)
	{
		int rc = 0;
		bool isFirst = true;

		while (true)
		{
			rc = 0;
			std::string label = egd.getLabel();
			if (label.empty())	return -1;

			if ((label == "version") && isFirst) {
				isFirst = false;
				version = (char*)egd.getString();
			}
			else if (label == "sourceFormat") {
				sourceFormat = (unsigned short)egd.getUInt();
			}
			else if (label == "level") {
				level = (short)egd.getInt();
			}
			else if (label == "area") {
				rc = area.load(egd);
			}
			else if (label == "***Header") {
			}
			else return -1;

			if(rc == 0) egd.next();
		}
	}
};

//	
struct	EDS_Root	{
	EDS_Header				___header;				//	[gf[^wb_
	EDS_RoadLane			___roadLane;			//	H[f[^Xg

	int load(EgdLoad& egd)
	{
		int rc = 0;
		bool isFirst = true;

		while (true)
		{
			rc = 0;
			std::string label = egd.getLabel();
			if (label.empty())	return -1;

			if ((label == "***Header") && isFirst) {
				isFirst = false;
				rc = ___header.load(egd);
			}
			else if (label == "***RoadLane") {
				rc = ___roadLane.load(egd);
			}
			else if (label == "Root") {
			}
			else return -1;

			if(rc == 0) egd.next();
		}
	}

	EgdLoad egdLoad;

	int readDataFile(char * fileName)
	{
		int rc = egdLoad.readDataFile(fileName);
		if (rc < 0) return -1;

		load(egdLoad); 

		egdLoad.endDataFile(); 
		return 0; 
	} 

};

