//----------------------------------------------------------------------
//
//			File:			"EgdLoad.h"
//			Created:		2017/08/28
//			Author:			M.Nimura(AW-SW)
//			Description:
//
//----------------------------------------------------------------------

#pragma once

//	tH[}bg֓WJ̃f[^ǍEێNX
class EgdLoad {
public:
	//	͓If[^(eLXgj̕ێXg
	int cp;
	std::vector<std::string>* pLines;

	//	tH[}bgWJ̃mۗp̃obt@
	//imۃubNh~Aꊇj
	struct MemBuffer {
		int		max;
		int		size;
		char*	p;
	};
	//	tH[}bgWJobt@Xg
	std::vector<MemBuffer> memBufList;

public:
	EgdLoad()
	{
		pLines = NULL;
	}

	~EgdLoad()
	{
		delete pLines;
		pLines = NULL;

		for (int i = 0; i < (int)memBufList.size(); i++)
		{
			delete [] memBufList[i].p;
		}
		memBufList.clear();
	}

	int		readDataFile(char* fileName)
	{
		FILE* fp;
		fopen_s(&fp, fileName, "r");
		if (fp == NULL)	return -1;

		pLines = new std::vector<std::string>();
		cp = 0;

		char	buffer[1024];
		while (fgets(buffer, 1024, fp) != NULL)
		{
			int		len = strlen(buffer);
			buffer[len - 1] = 0;

			std::string	str(buffer);
			pLines->push_back(str);
		}

		fclose(fp);
		return 0;
	}

	void		endDataFile()
	{
		delete pLines;
		pLines = NULL;
	}

	void* mallocArray(int usize, int num)
	{
		int		size = usize * num;
		if (size == 0)	return NULL;

		bool isMalloc = false;
		if (memBufList.size() == 0)	isMalloc = true;
		else
		{
			MemBuffer* mb = &memBufList[memBufList.size() - 1];
			if (mb->max < mb->size + size)	isMalloc = true;
		}

		if (isMalloc)
		{
			int	max = 16 * 1024;
			max = (size > max) ? size : max;

			MemBuffer	newMb;
			newMb.p = new char[max];
			newMb.max = max;
			newMb.size = 0;

			memBufList.push_back(newMb);
		}

		MemBuffer* mb = &memBufList[memBufList.size() - 1];
		char* p = mb->p + mb->size;
		mb->size += size;

		return p;
	}

	std::string		getLine()
	{
		if (cp == pLines->size())	return NULL;
		return (*pLines)[cp];
	}

	std::string		getLabel()
	{
		if (cp == pLines->size())
			return "";
		int	idx = (*pLines)[cp].find(":");

		if (cp == pLines->size() - 1) {
			int	trap = 1;
		}

		std::string		label = (*pLines)[cp].substr(0, idx);
		return label;
	}

	void next()
	{
		cp++;
	}

	//	f[^R[h當擾
	char*	getString()
	{
		int	idx = (*pLines)[cp].find(":");
		std::string		value = (*pLines)[cp].substr(idx + 1);

		char* p = (char *)mallocArray(1, value.size() + 1);

		std::char_traits<char>::copy(p, value.c_str(), value.size() + 1);
		return (char*)p;
	}

	//	f[^R[hl擾
	int	getInt()
	{
		int	idx = (*pLines)[cp].find(":");
		std::string		value = (*pLines)[cp].substr(idx + 1);
		int	val;
		sscanf_s(value.c_str(), "%d", &val);
		return val;
	}

	int	getUInt()
	{
		int	idx = (*pLines)[cp].find(":");
		std::string		value = (*pLines)[cp].substr(idx + 1);
		unsigned int	val;
		sscanf_s(value.c_str(), "%d", &val);
		return val;
	}

	//	f[^R[h̒l擾

	int	getInt(int idx)
	{
		std::string	value = getValueStr(idx);
		int	val;
		sscanf_s(value.c_str(), "%d", &val);
		return val;
	}

	int	getUInt(int idx)
	{
		std::string	value = getValueStr(idx);
		unsigned int	val;
		sscanf_s(value.c_str(), "%d", &val);
		return val;
	}

private:

	std::string	getValueStr(int index)
	{
		int	idx = (*pLines)[cp].find(":");
		std::string		valueArray = (*pLines)[cp].substr(idx + 1);
		char* p = (char *)valueArray.c_str();

		int	i = 0;
		int	count = 0;
		int	si = 0;
		while (p[i] != 0)
		{
			if (p[i] == ',')
			{
				if (count == index)	break;
				count++;
				si = i + 1;
			}
			i++;
		}

		std::string		value = valueArray.substr(si, i - si);
		return value;
	}


};
