package blackjack.card;

import blackjack.Card;

public class PipCard implements Card {
    private final int value;

    private PipCard(int value) {
        assert 0 < value && value < 11;
        this.value = value;
    }

    public static PipCard valueOf(int value) {
        return new PipCard(value);
    }

    @Override
    public int score() {
        return value;
    }
}
