package blackjack.card;

import blackjack.Card;

public class FaceCard implements Card {
    private final int value;

    private FaceCard(int value) {
        assert 10 < value && value < 14;
        this.value = value;
    }

    public static FaceCard valueOf(int value) {
        return new FaceCard(value);
    }

    @Override
    public int score() {
        return 10;
    }
}
