package blackjack;

import blackjack.Card.Suit;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class Deck {
    List<Card> cards;

    public Deck() {
        cards = new ArrayList<>();
        init();
    }

    public Deck init() {
        // カードを作成
        for(Suit suit: Suit.values()) {
            for (int i = 0; i < 13; i++) {
                cards.add(CardFactory.create(i + 1));
            }
        }
        return this;
    }

    public void shuffle() {
        Collections.shuffle(cards);
    }

    public Card pull() {
        return cards.remove(0);
    }
}
