/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.collect.testing.testers;

import com.google.common.annotations.GwtCompatible;
import com.google.common.annotations.GwtIncompatible;
import com.google.common.collect.testing.AbstractMapTester;
import com.google.common.collect.testing.Helpers;
import com.google.common.collect.testing.features.CollectionFeature;
import com.google.common.collect.testing.features.CollectionSize;
import com.google.common.collect.testing.features.MapFeature;
import java.lang.reflect.Method;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

@GwtCompatible
public class MapEntrySetTester<K, V>
extends AbstractMapTester<K, V> {
    @CollectionSize.Require(value={CollectionSize.ONE})
    @CollectionFeature.Require(value={CollectionFeature.SUPPORTS_ITERATOR_REMOVE})
    public void testEntrySetIteratorRemove() {
        Set entrySet = this.getMap().entrySet();
        Iterator entryItr = entrySet.iterator();
        MapEntrySetTester.assertEquals(this.samples.e0, entryItr.next());
        entryItr.remove();
        MapEntrySetTester.assertTrue((boolean)this.getMap().isEmpty());
        MapEntrySetTester.assertFalse((boolean)entrySet.contains(this.samples.e0));
    }

    public void testContainsEntryWithIncomparableKey() {
        MapEntrySetTester.assertFalse((boolean)this.getMap().entrySet().contains(Helpers.mapEntry(IncomparableType.INSTANCE, ((Map.Entry)this.samples.e0).getValue())));
    }

    public void testContainsEntryWithIncomparableValue() {
        MapEntrySetTester.assertFalse((boolean)this.getMap().entrySet().contains(Helpers.mapEntry(((Map.Entry)this.samples.e0).getKey(), IncomparableType.INSTANCE)));
    }

    @MapFeature.Require(value={MapFeature.ALLOWS_NULL_KEY_QUERIES})
    public void testContainsEntryWithNullKeyAbsent() {
        MapEntrySetTester.assertFalse((boolean)this.getMap().entrySet().contains(Helpers.mapEntry(null, ((Map.Entry)this.samples.e0).getValue())));
    }

    @CollectionSize.Require(absent={CollectionSize.ZERO})
    @MapFeature.Require(value={MapFeature.ALLOWS_NULL_KEYS})
    public void testContainsEntryWithNullKeyPresent() {
        this.initMapWithNullKey();
        MapEntrySetTester.assertTrue((boolean)this.getMap().entrySet().contains(Helpers.mapEntry(null, this.getValueForNullKey())));
    }

    @MapFeature.Require(value={MapFeature.ALLOWS_NULL_VALUE_QUERIES})
    public void testContainsEntryWithNullValueAbsent() {
        MapEntrySetTester.assertFalse((boolean)this.getMap().entrySet().contains(Helpers.mapEntry(((Map.Entry)this.samples.e0).getKey(), null)));
    }

    @CollectionSize.Require(absent={CollectionSize.ZERO})
    @MapFeature.Require(value={MapFeature.ALLOWS_NULL_VALUES})
    public void testContainsEntryWithNullValuePresent() {
        this.initMapWithNullValue();
        MapEntrySetTester.assertTrue((boolean)this.getMap().entrySet().contains(Helpers.mapEntry(this.getKeyForNullValue(), null)));
    }

    @GwtIncompatible(value="reflection")
    public static Method getContainsEntryWithIncomparableKeyMethod() {
        return Helpers.getMethod(MapEntrySetTester.class, "testContainsEntryWithIncomparableKey");
    }

    @GwtIncompatible(value="reflection")
    public static Method getContainsEntryWithIncomparableValueMethod() {
        return Helpers.getMethod(MapEntrySetTester.class, "testContainsEntryWithIncomparableValue");
    }

    private static enum IncomparableType {
        INSTANCE;

    }
}

