/*
 * NPlot - A charting library for .NET
 * 
 * LinePointPlot.cs
 * Copyright (C) 2003-2006 Matt Howlett and others.
 * All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without modification,
 * are permitted provided that the following conditions are met:
 * 
 * 1. Redistributions of source code must retain the above copyright notice, this
 *    list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 * 3. Neither the name of NPlot nor the names of its contributors may
 *    be used to endorse or promote products derived from this software without
 *    specific prior written permission.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 * WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
 * IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT,
 * INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING,
 * BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 * DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
 * LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE
 * OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED
 * OF THE POSSIBILITY OF SUCH DAMAGE.
 */
/*
 * patch for writing to PDF using iTextSharp.
 * Copyright (C) 2006 mocchi
 */

using System;
using System.Drawing;
using System.Text;

namespace NPlot
{
	/// <summary>
	/// LinePlot with marker
	/// </summary>
	class LinePointPlot : NPlot.IPlot, NPlot.ISequencePlot {
		NPlot.LinePlot linePlot;
		NPlot.PointPlot pointPlot;
		public LinePointPlot() {
			linePlot = new NPlot.LinePlot();
			pointPlot = new NPlot.PointPlot();
		}
		public LinePointPlot(object o) {
			linePlot = new NPlot.LinePlot(o);
			pointPlot = new NPlot.PointPlot();
		}
		public LinePointPlot(object o1, object o2) {
			linePlot = new NPlot.LinePlot(o1, o2);
			pointPlot = new NPlot.PointPlot();
		}
		public LinePointPlot(NPlot.Marker m) {
			linePlot = new NPlot.LinePlot();
			pointPlot = new NPlot.PointPlot(m);
		}
		public LinePointPlot(object o, NPlot.Marker m) {
			linePlot = new NPlot.LinePlot(o);
			pointPlot = new NPlot.PointPlot(m);
		}
		public LinePointPlot(object o1, object o2, NPlot.Marker m) {
			linePlot = new NPlot.LinePlot(o1, o2);
			pointPlot = new NPlot.PointPlot(m);
		}
		#region ISequencePlot member

		public object AbscissaData {
			get {
				return linePlot.AbscissaData;
			}
			set {
				linePlot.AbscissaData = value;
				pointPlot.AbscissaData = value;
			}
		}

		public string DataMember {
			get {
				return linePlot.DataMember;
			}
			set {
				linePlot.DataMember = value;
				pointPlot.DataMember = value;
			}
		}

		public object DataSource {
			get {
				return linePlot.DataSource;
			}
			set {
				linePlot.DataSource = value;
				pointPlot.DataSource = value;
			}
		}

		public object OrdinateData {
			get {
				return linePlot.OrdinateData;
			}
			set {
				linePlot.OrdinateData = value;
				pointPlot.OrdinateData = value;
			}
		}

		#endregion

		#region IPlot member

		public void DrawInLegend(IGraphics g, Rectangle startEnd) {
			linePlot.DrawInLegend(g, startEnd);
			pointPlot.DrawInLegend(g, startEnd);
		}

		public string Label {
			get {
				return linePlot.Label;
			}
			set {
				linePlot.Label = value;
				pointPlot.Label = value;
			}
		}

		public bool ShowInLegend {
			get {
				return linePlot.ShowInLegend;
			}
			set {
				linePlot.ShowInLegend = value;
				pointPlot.ShowInLegend = value;
			}
		}

		public NPlot.Axis SuggestXAxis() {
			return linePlot.SuggestXAxis();
		}

		public NPlot.Axis SuggestYAxis() {
			return linePlot.SuggestYAxis();
		}

		public void WriteData(StringBuilder sb, NPlot.RectangleD region, bool onlyInRegion) {
			linePlot.WriteData(sb, region, onlyInRegion);
			pointPlot.WriteData(sb, region, onlyInRegion);
		}

		#endregion

		#region IDrawable member

		public void Draw(IGraphics g, NPlot.PhysicalAxis xAxis, NPlot.PhysicalAxis yAxis) {
			linePlot.Draw(g, xAxis, yAxis);
			pointPlot.Draw(g, xAxis, yAxis);
		}

		#endregion

		#region LinePlot member
		public void DrawLineOrShadow(IGraphics g, NPlot.PhysicalAxis xAxis, NPlot.PhysicalAxis yAxis, bool drawShadow) {
			linePlot.DrawLineOrShadow(g, xAxis, yAxis, drawShadow);
		}

		public System.Drawing.Color Color {
			get {
				return linePlot.Color;
			}
			set {
				linePlot.Color = value;
			}
		}

		public System.Drawing.Pen Pen {
			get {
				return linePlot.Pen;
			}
			set {
				linePlot.Pen = value;
			}
		}

		public bool Shadow {
			get {
				return linePlot.Shadow;
			}
			set {
				linePlot.Shadow = value;
			}
		}

		public System.Drawing.Color ShadowColor {
			get {
				return linePlot.ShadowColor;
			}
			set {
				linePlot.ShadowColor = value;
			}
		}

		public System.Drawing.Point ShadowOffset {
			get {
				return linePlot.ShadowOffset;
			}
			set {
				linePlot.ShadowOffset = value;
			}
		}
		#endregion

		#region PointPlot member
		public NPlot.Marker Marker {
			get {
				return pointPlot.Marker;
			}
			set {
				pointPlot.Marker = value;
			}
		}
		#endregion
	}
}
