/*
NPlot - A charting library for .NET

GraphicsGDIPlus.cs
Copyright (C) 2003
Matt Howlett

Redistribution and use of NPlot or parts there-of in source and
binary forms, with or without modification, are permitted provided
that the following conditions are met:

1. Re-distributions in source form must retain at the head of each
   source file the above copyright notice, this list of conditions
   and the following disclaimer.

2. Any product ("the product") that makes use NPlot or parts 
   there-of must either:
  
    (a) allow any user of the product to obtain a complete machine-
        readable copy of the corresponding source code for the 
        product and the version of NPlot used for a charge no more
        than your cost of physically performing source distribution,
	    on a medium customarily used for software interchange, or:

    (b) reproduce the following text in the documentation, about 
        box or other materials intended to be read by human users
        of the product that is provided to every human user of the
        product: 
   
              "This product includes software developed as 
              part of the NPlot library project available 
              from: http://www.nplot.com/" 

        The words "This product" may optionally be replace with 
        the actual name of the product.

------------------------------------------------------------------------

THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR
IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT,
INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
(INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

*/
/*
 * patch for writing to PDF using iTextSharp.
 * Copyright (C) 2006-2007 mocchi
 */

using System;
using System.Drawing;
using System.Drawing.Drawing2D;

namespace NPlot
{
	/// <summary>
	/// GraphicsGDIPlus ̊Tv̐łB
	/// </summary>
	public class GraphicsGDIPlus : IGraphics
	{
		Graphics g;
		/// <summary>
		/// create graphics GDI Plus instance using System.Drawing.Graphics.
		/// </summary>
		/// <param name="g"></param>
		public GraphicsGDIPlus(Graphics g)
		{
			this.g = g;
			// 
			// TODO: RXgN^ WbNɒǉĂB
			//
		}
		#region IGraphics member

		/// <summary>
		/// Dispose.
		/// </summary>
		public void Dispose(){
			g.Dispose();
		}
		
		/// <summary>
		/// Draw rectangle.
		/// </summary>
		/// <param name="pen"></param>
		/// <param name="x"></param>
		/// <param name="y"></param>
		/// <param name="width"></param>
		/// <param name="height"></param>
		public void DrawRectangle(System.Drawing.Pen pen, int x, int y, int width, int height) {
			g.DrawRectangle(pen, x, y, width, height);
		}

		/// <summary>
		/// Draw rectangle.
		/// </summary>
		/// <param name="pen"></param>
		/// <param name="x"></param>
		/// <param name="y"></param>
		/// <param name="width"></param>
		/// <param name="height"></param>
		public void DrawRectangle(System.Drawing.Pen pen, float x, float y, float width, float height) {
			g.DrawRectangle(pen, x, y, width, height);
		}

		/// <summary>
		/// Draw rectangle.
		/// </summary>
		/// <param name="pen"></param>
		/// <param name="rect"></param>
		public void DrawRectangle(System.Drawing.Pen pen, Rectangle rect) {
			g.DrawRectangle(pen, rect);
		}

		/// <summary>
		/// Fill rectangle.
		/// </summary>
		/// <param name="brush"></param>
		/// <param name="x"></param>
		/// <param name="y"></param>
		/// <param name="width"></param>
		/// <param name="height"></param>
		public void FillRectangle(System.Drawing.Brush brush, int x, int y, int width, int height) {
			g.FillRectangle(brush, x, y, width, height);
		}

		/// <summary>
		/// Fill rectangle.
		/// </summary>
		/// <param name="brush"></param>
		/// <param name="x"></param>
		/// <param name="y"></param>
		/// <param name="width"></param>
		/// <param name="height"></param>
		public void FillRectangle(System.Drawing.Brush brush, float x, float y, float width, float height) {
			g.FillRectangle(brush, x, y, width, height);
		}

		/// <summary>
		/// Fill rectangle.
		/// </summary>
		/// <param name="brush"></param>
		/// <param name="rect"></param>
		public void FillRectangle(System.Drawing.Brush brush, Rectangle rect) {
			g.FillRectangle(brush, rect);
		}

		/// <summary>
		/// Draw a line.
		/// </summary>
		/// <param name="pen"></param>
		/// <param name="p1"></param>
		/// <param name="p2"></param>
		public void DrawLine(Pen pen, Point p1, Point p2) {
			g.DrawLine(pen, p1, p2);
		}

		/// <summary>
		/// Draw a line.
		/// </summary>
		/// <param name="pen"></param>
		/// <param name="x1"></param>
		/// <param name="y1"></param>
		/// <param name="x2"></param>
		/// <param name="y2"></param>
		public void DrawLine(Pen pen, int x1, int y1, int x2, int y2){
			g.DrawLine(pen, x1, y1, x2, y2);
		}

		/// <summary>
		/// Draw a line.
		/// </summary>
		/// <param name="pen"></param>
		/// <param name="x1"></param>
		/// <param name="y1"></param>
		/// <param name="x2"></param>
		/// <param name="y2"></param>
		public void DrawLine(Pen pen, float x1, float y1, float x2, float y2){
			g.DrawLine(pen, x1, y1, x2, y2);
		}

		/// <summary>
		/// Fill a polygon.
		/// </summary>
		/// <param name="brush"></param>
		/// <param name="pts"></param>
		public void FillPolygon(Brush brush, Point[] pts) {
			g.FillPolygon(brush, pts);
		}

		/// <summary>
		/// Fill a polygon.
		/// </summary>
		/// <param name="brush"></param>
		/// <param name="pts"></param>
		public void FillPolygon(Brush brush, PointF[] pts) {
			g.FillPolygon(brush, pts);
		}
/*
		/// <summary>
		/// Draw path
		/// </summary>
		/// <param name="pen"></param>
		/// <param name="gp"></param>
		public void DrawPath(Pen pen, GraphicsPath gp){
			g.DrawPath(pen, gp);
		}

		/// <summary>
		/// Fill path
		/// </summary>
		/// <param name="brush"></param>
		/// <param name="gp"></param>
		public void FillPath(Brush brush, GraphicsPath gp){
			g.FillPath(brush, gp);
		}
*/
		/// <summary>
		/// Draw path
		/// </summary>
		/// <param name="pen"></param>
		/// <param name="pts"></param>
		public void DrawPolygon(Pen pen, Point[] pts){
			g.DrawPolygon(pen, pts);
		}

		/// <summary>
		/// ClipRectangle property
		/// </summary>
		public RectangleF ClipRectangle{
			get{
				return g.Clip.GetBounds(g);
			}
			set{
				g.Clip = new Region(value);
			}
		}

		/// <summary>
		/// Reset clip.
		/// </summary>
		public void ResetClipRectangle(){
			g.ResetClip();
		}
		
		/// <summary>
		/// SmootingMode property
		/// </summary>
		public SmoothingMode SmoothingMode{
			get{
				return g.SmoothingMode;
			}
			set{
				g.SmoothingMode = value;
			}
		}
		/// <summary>
		/// Measure size of string.
		/// </summary>
		/// <param name="text"></param>
		/// <param name="font"></param>
		/// <returns></returns>
		public SizeF MeasureString(string text, Font font){
			return g.MeasureString(text, font);
		}

		/// <summary>
		/// 
		/// </summary>
		/// <param name="img"></param>
		/// <param name="rect"></param>
		public void DrawImage(Image img, Rectangle rect){
			g.DrawImage(img, rect);
		}

		/// <summary>
		/// Draw string.
		/// </summary>
		/// <param name="text"></param>
		/// <param name="font"></param>
		/// <param name="brush"></param>
		/// <param name="x"></param>
		/// <param name="y"></param>
		public void DrawString(string text, Font font, Brush brush, int x, int y) {
			g.DrawString(text, font, brush, x, y);
		}

		/// <summary>
		/// Draw string
		/// </summary>
		/// <param name="text"></param>
		/// <param name="font"></param>
		/// <param name="brush"></param>
		/// <param name="ptf"></param>
		public void DrawString(string text, Font font, Brush brush, PointF ptf){
			g.DrawString(text, font, brush, ptf);
		}

		/// <summary>
		/// Draw string
		/// </summary>
		/// <param name="text"></param>
		/// <param name="font"></param>
		/// <param name="brush"></param>
		/// <param name="ptf"></param>
		/// <param name="sf"></param>
		public void DrawString(string text, Font font, Brush brush, PointF ptf, StringFormat sf){
			g.DrawString(text, font, brush, ptf, sf);
		}

		/// <summary>
		/// Draw string
		/// </summary>
		/// <param name="text"></param>
		/// <param name="font"></param>
		/// <param name="brush"></param>
		/// <param name="rcf"></param>
		/// <param name="sf"></param>
		public void DrawString(string text, Font font, Brush brush, RectangleF rcf, StringFormat sf){
			g.DrawString(text, font, brush, rcf, sf);
		}

		/// <summary>
		/// Draw ellipse
		/// </summary>
		/// <param name="pen"></param>
		/// <param name="x"></param>
		/// <param name="y"></param>
		/// <param name="width"></param>
		/// <param name="height"></param>
		public void DrawEllipse(Pen pen, int x, int y, int width, int height){
			g.DrawEllipse(pen, x, y, width, height);
		}

		/// <summary>
		/// Fill ellipse
		/// </summary>
		/// <param name="brush"></param>
		/// <param name="x"></param>
		/// <param name="y"></param>
		/// <param name="width"></param>
		/// <param name="height"></param>
		public void FillEllipse(Brush brush, int x, int y, int width, int height){
			g.FillEllipse(brush, x, y, width, height);
		}

		/// <summary>
		/// Transformation Matrix
		/// </summary>
		public Matrix Transform{
			get{
				return g.Transform;
			}
			set{
				g.Transform = value;
			}
		}

		/// <summary>
		/// Reset transform matrix
		/// </summary>
		public void ResetTransform(){
			g.ResetTransform();
		}

		/// <summary>
		/// 
		/// </summary>
		/// <param name="x"></param>
		/// <param name="y"></param>
		public void TranslateTransform(float x, float y){
			g.TranslateTransform(x,y);
		}

		/// <summary>
		/// 
		/// </summary>
		/// <param name="theta"></param>
		public void RotateTransform(float theta){
			g.RotateTransform(theta);
		}

		/// <summary>
		/// 
		/// </summary>
		/// <param name="sx"></param>
		/// <param name="sy"></param>
		public void ScaleTransform(float sx, float sy) {
			g.ScaleTransform(sx, sy);
		}

		#endregion
	}
}
