/*
 * Decompiled with CFR 0.152.
 */
package com.google.dexmaker.dx.rop.code;

import com.google.dexmaker.dx.rop.code.Insn;
import com.google.dexmaker.dx.rop.code.RegisterSpec;
import com.google.dexmaker.dx.rop.code.RegisterSpecList;
import com.google.dexmaker.dx.rop.code.Rop;
import com.google.dexmaker.dx.rop.code.SourcePosition;
import com.google.dexmaker.dx.rop.type.Type;
import com.google.dexmaker.dx.rop.type.TypeList;

public final class ThrowingInsn
extends Insn {
    private final TypeList catches;

    public static String toCatchString(TypeList catches) {
        StringBuffer sb = new StringBuffer(100);
        sb.append("catch");
        int sz = catches.size();
        for (int i = 0; i < sz; ++i) {
            sb.append(" ");
            sb.append(catches.getType(i).toHuman());
        }
        return sb.toString();
    }

    public ThrowingInsn(Rop opcode, SourcePosition position, RegisterSpecList sources, TypeList catches) {
        super(opcode, position, null, sources);
        if (opcode.getBranchingness() != 6) {
            throw new IllegalArgumentException("bogus branchingness");
        }
        if (catches == null) {
            throw new NullPointerException("catches == null");
        }
        this.catches = catches;
    }

    public String getInlineString() {
        return ThrowingInsn.toCatchString(this.catches);
    }

    public TypeList getCatches() {
        return this.catches;
    }

    public void accept(Insn.Visitor visitor) {
        visitor.visitThrowingInsn(this);
    }

    public Insn withAddedCatch(Type type) {
        return new ThrowingInsn(this.getOpcode(), this.getPosition(), this.getSources(), this.catches.withAddedType(type));
    }

    public Insn withRegisterOffset(int delta) {
        return new ThrowingInsn(this.getOpcode(), this.getPosition(), this.getSources().withOffset(delta), this.catches);
    }

    public Insn withNewRegisters(RegisterSpec result, RegisterSpecList sources) {
        return new ThrowingInsn(this.getOpcode(), this.getPosition(), sources, this.catches);
    }
}

