/*
 * Decompiled with CFR 0.152.
 */
package com.google.dexmaker.dx.rop.code;

import com.google.dexmaker.dx.rop.code.Insn;
import com.google.dexmaker.dx.rop.code.RegisterSpec;
import com.google.dexmaker.dx.rop.code.RegisterSpecList;
import com.google.dexmaker.dx.rop.code.Rop;
import com.google.dexmaker.dx.rop.code.SourcePosition;
import com.google.dexmaker.dx.rop.type.StdTypeList;
import com.google.dexmaker.dx.rop.type.Type;
import com.google.dexmaker.dx.rop.type.TypeList;
import com.google.dexmaker.dx.util.IntList;

public final class SwitchInsn
extends Insn {
    private final IntList cases;

    public SwitchInsn(Rop opcode, SourcePosition position, RegisterSpec result, RegisterSpecList sources, IntList cases) {
        super(opcode, position, result, sources);
        if (opcode.getBranchingness() != 5) {
            throw new IllegalArgumentException("bogus branchingness");
        }
        if (cases == null) {
            throw new NullPointerException("cases == null");
        }
        this.cases = cases;
    }

    public String getInlineString() {
        return this.cases.toString();
    }

    public TypeList getCatches() {
        return StdTypeList.EMPTY;
    }

    public void accept(Insn.Visitor visitor) {
        visitor.visitSwitchInsn(this);
    }

    public Insn withAddedCatch(Type type) {
        throw new UnsupportedOperationException("unsupported");
    }

    public Insn withRegisterOffset(int delta) {
        return new SwitchInsn(this.getOpcode(), this.getPosition(), this.getResult().withOffset(delta), this.getSources().withOffset(delta), this.cases);
    }

    public boolean contentEquals(Insn b) {
        return false;
    }

    public Insn withNewRegisters(RegisterSpec result, RegisterSpecList sources) {
        return new SwitchInsn(this.getOpcode(), this.getPosition(), result, sources, this.cases);
    }

    public IntList getCases() {
        return this.cases;
    }
}

