/*
 * Decompiled with CFR 0.152.
 */
package com.google.dexmaker.dx.dex.file;

import com.google.dexmaker.dx.dex.file.DexFile;
import com.google.dexmaker.dx.dex.file.ItemType;
import com.google.dexmaker.dx.dex.file.OffsettedItem;
import com.google.dexmaker.dx.rop.cst.CstString;
import com.google.dexmaker.dx.util.AnnotatedOutput;
import com.google.dexmaker.dx.util.ByteArray;
import com.google.dexmaker.dx.util.Hex;
import com.google.dexmaker.dx.util.Leb128Utils;

public final class StringDataItem
extends OffsettedItem {
    private final CstString value;

    public StringDataItem(CstString value) {
        super(1, StringDataItem.writeSize(value));
        this.value = value;
    }

    private static int writeSize(CstString value) {
        int utf16Size = value.getUtf16Size();
        return Leb128Utils.unsignedLeb128Size(utf16Size) + value.getUtf8Size() + 1;
    }

    public ItemType itemType() {
        return ItemType.TYPE_STRING_DATA_ITEM;
    }

    public void addContents(DexFile file) {
    }

    public void writeTo0(DexFile file, AnnotatedOutput out) {
        ByteArray bytes = this.value.getBytes();
        int utf16Size = this.value.getUtf16Size();
        if (out.annotates()) {
            out.annotate(Leb128Utils.unsignedLeb128Size(utf16Size), "utf16_size: " + Hex.u4(utf16Size));
            out.annotate(bytes.size() + 1, this.value.toQuoted());
        }
        out.writeUleb128(utf16Size);
        out.write(bytes);
        out.writeByte(0);
    }

    public String toHuman() {
        return this.value.toQuoted();
    }

    protected int compareTo0(OffsettedItem other) {
        StringDataItem otherData = (StringDataItem)other;
        return this.value.compareTo(otherData.value);
    }
}

