/*
 * Decompiled with CFR 0.152.
 */
package com.google.dexmaker;

import com.google.dexmaker.AppDataDirGuesser;
import com.google.dexmaker.Code;
import com.google.dexmaker.Constants;
import com.google.dexmaker.FieldId;
import com.google.dexmaker.MethodId;
import com.google.dexmaker.TypeId;
import com.google.dexmaker.TypeList;
import com.google.dexmaker.dx.dex.DexOptions;
import com.google.dexmaker.dx.dex.code.DalvCode;
import com.google.dexmaker.dx.dex.code.RopTranslator;
import com.google.dexmaker.dx.dex.file.ClassDefItem;
import com.google.dexmaker.dx.dex.file.DexFile;
import com.google.dexmaker.dx.dex.file.EncodedField;
import com.google.dexmaker.dx.dex.file.EncodedMember;
import com.google.dexmaker.dx.dex.file.EncodedMethod;
import com.google.dexmaker.dx.rop.code.LocalVariableInfo;
import com.google.dexmaker.dx.rop.code.RopMethod;
import com.google.dexmaker.dx.rop.cst.CstString;
import com.google.dexmaker.dx.rop.cst.CstType;
import com.google.dexmaker.dx.rop.type.StdTypeList;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.jar.JarEntry;
import java.util.jar.JarOutputStream;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class DexMaker {
    private final Map<TypeId<?>, TypeDeclaration> types = new LinkedHashMap();

    private TypeDeclaration getTypeDeclaration(TypeId<?> type) {
        TypeDeclaration result = this.types.get(type);
        if (result == null) {
            result = new TypeDeclaration(type);
            this.types.put(type, result);
        }
        return result;
    }

    public void declare(TypeId<?> type, String sourceFile, int flags, TypeId<?> supertype, TypeId<?> ... interfaces) {
        TypeDeclaration declaration = this.getTypeDeclaration(type);
        int supportedFlags = 1041;
        if ((flags & ~supportedFlags) != 0) {
            throw new IllegalArgumentException("Unexpected flag: " + Integer.toHexString(flags));
        }
        if (declaration.declared) {
            throw new IllegalStateException("already declared: " + type);
        }
        declaration.declared = true;
        declaration.flags = flags;
        declaration.supertype = supertype;
        declaration.sourceFile = sourceFile;
        declaration.interfaces = new TypeList(interfaces);
    }

    public Code declare(MethodId<?, ?> method, int flags) {
        TypeDeclaration typeDeclaration = this.getTypeDeclaration(method.declaringType);
        if (typeDeclaration.methods.containsKey(method)) {
            throw new IllegalStateException("already declared: " + method);
        }
        int supportedFlags = 63;
        if ((flags & ~supportedFlags) != 0) {
            throw new IllegalArgumentException("Unexpected flag: " + Integer.toHexString(flags));
        }
        if ((flags & 0x20) != 0) {
            flags = flags & 0xFFFFFFDF | 0x20000;
        }
        if (method.isConstructor()) {
            flags |= 0x10000;
        }
        MethodDeclaration methodDeclaration = new MethodDeclaration(method, flags);
        typeDeclaration.methods.put(method, methodDeclaration);
        return methodDeclaration.code;
    }

    public void declare(FieldId<?, ?> fieldId, int flags, Object staticValue) {
        TypeDeclaration typeDeclaration = this.getTypeDeclaration(fieldId.declaringType);
        if (typeDeclaration.fields.containsKey(fieldId)) {
            throw new IllegalStateException("already declared: " + fieldId);
        }
        int supportedFlags = 223;
        if ((flags & ~supportedFlags) != 0) {
            throw new IllegalArgumentException("Unexpected flag: " + Integer.toHexString(flags));
        }
        if ((flags & 8) == 0 && staticValue != null) {
            throw new IllegalArgumentException("staticValue is non-null, but field is not static");
        }
        FieldDeclaration fieldDeclaration = new FieldDeclaration(fieldId, flags, staticValue);
        typeDeclaration.fields.put(fieldId, fieldDeclaration);
    }

    public byte[] generate() {
        DexOptions options = new DexOptions();
        options.targetApiLevel = 13;
        DexFile outputDex = new DexFile(options);
        for (TypeDeclaration typeDeclaration : this.types.values()) {
            outputDex.add(typeDeclaration.toClassDefItem());
        }
        try {
            return outputDex.toDex(null, false);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public ClassLoader generateAndLoad(ClassLoader parent, File dexCache) throws IOException {
        if (dexCache == null) {
            String property = System.getProperty("dexmaker.dexcache");
            if (property != null) {
                dexCache = new File(property);
            } else {
                dexCache = new AppDataDirGuesser().guess();
                if (dexCache == null) {
                    throw new IllegalArgumentException("dexcache == null (and no default could be found; consider setting the 'dexmaker.dexcache' system property)");
                }
            }
        }
        byte[] dex = this.generate();
        File result = File.createTempFile("Generated", ".jar", dexCache);
        result.deleteOnExit();
        JarOutputStream jarOut = new JarOutputStream(new FileOutputStream(result));
        jarOut.putNextEntry(new JarEntry("classes.dex"));
        jarOut.write(dex);
        jarOut.closeEntry();
        jarOut.close();
        try {
            return (ClassLoader)Class.forName("dalvik.system.DexClassLoader").getConstructor(String.class, String.class, String.class, ClassLoader.class).newInstance(result.getPath(), dexCache.getAbsolutePath(), null, parent);
        }
        catch (ClassNotFoundException e) {
            throw new UnsupportedOperationException("load() requires a Dalvik VM", e);
        }
        catch (InvocationTargetException e) {
            throw new RuntimeException(e.getCause());
        }
        catch (InstantiationException e) {
            throw new AssertionError();
        }
        catch (NoSuchMethodException e) {
            throw new AssertionError();
        }
        catch (IllegalAccessException e) {
            throw new AssertionError();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class MethodDeclaration {
        final MethodId<?, ?> method;
        private final int flags;
        private final Code code;

        public MethodDeclaration(MethodId<?, ?> method, int flags) {
            this.method = method;
            this.flags = flags;
            this.code = new Code(this);
        }

        boolean isStatic() {
            return (this.flags & 8) != 0;
        }

        boolean isDirect() {
            return (this.flags & 0x1000A) != 0;
        }

        EncodedMethod toEncodedMethod(DexOptions dexOptions) {
            RopMethod ropMethod = new RopMethod(this.code.toBasicBlocks(), 0);
            LocalVariableInfo locals = null;
            DalvCode dalvCode = RopTranslator.translate(ropMethod, 1, locals, this.code.paramSize(), dexOptions);
            return new EncodedMethod(this.method.constant, this.flags, dalvCode, StdTypeList.EMPTY);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class FieldDeclaration {
        final FieldId<?, ?> fieldId;
        private final int accessFlags;
        private final Object staticValue;

        FieldDeclaration(FieldId<?, ?> fieldId, int accessFlags, Object staticValue) {
            if ((accessFlags & 8) == 0 && staticValue != null) {
                throw new IllegalArgumentException("instance fields may not have a value");
            }
            this.fieldId = fieldId;
            this.accessFlags = accessFlags;
            this.staticValue = staticValue;
        }

        EncodedField toEncodedField() {
            return new EncodedField(this.fieldId.constant, this.accessFlags);
        }

        public boolean isStatic() {
            return (this.accessFlags & 8) != 0;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class TypeDeclaration {
        private final TypeId<?> type;
        private boolean declared;
        private int flags;
        private TypeId<?> supertype;
        private String sourceFile;
        private TypeList interfaces;
        private final Map<FieldId, FieldDeclaration> fields = new LinkedHashMap<FieldId, FieldDeclaration>();
        private final Map<MethodId, MethodDeclaration> methods = new LinkedHashMap<MethodId, MethodDeclaration>();

        TypeDeclaration(TypeId<?> type) {
            this.type = type;
        }

        ClassDefItem toClassDefItem() {
            EncodedMember encoded;
            if (!this.declared) {
                throw new IllegalStateException("Undeclared type " + this.type + " declares members: " + this.fields.keySet() + " " + this.methods.keySet());
            }
            DexOptions dexOptions = new DexOptions();
            dexOptions.targetApiLevel = 13;
            CstType thisType = this.type.constant;
            ClassDefItem out = new ClassDefItem(thisType, this.flags, this.supertype.constant, this.interfaces.ropTypes, new CstString(this.sourceFile));
            for (MethodDeclaration method : this.methods.values()) {
                encoded = method.toEncodedMethod(dexOptions);
                if (method.isDirect()) {
                    out.addDirectMethod((EncodedMethod)encoded);
                    continue;
                }
                out.addVirtualMethod((EncodedMethod)encoded);
            }
            for (FieldDeclaration field : this.fields.values()) {
                encoded = field.toEncodedField();
                if (field.isStatic()) {
                    out.addStaticField((EncodedField)encoded, Constants.getConstant(field.staticValue));
                    continue;
                }
                out.addInstanceField((EncodedField)encoded);
            }
            return out;
        }
    }
}

