/*
 * Decompiled with CFR 0.152.
 */
package com.google.dexmaker;

import com.google.dexmaker.TypeId;
import com.google.dexmaker.dx.rop.cst.CstBoolean;
import com.google.dexmaker.dx.rop.cst.CstByte;
import com.google.dexmaker.dx.rop.cst.CstChar;
import com.google.dexmaker.dx.rop.cst.CstDouble;
import com.google.dexmaker.dx.rop.cst.CstFloat;
import com.google.dexmaker.dx.rop.cst.CstInteger;
import com.google.dexmaker.dx.rop.cst.CstKnownNull;
import com.google.dexmaker.dx.rop.cst.CstLong;
import com.google.dexmaker.dx.rop.cst.CstShort;
import com.google.dexmaker.dx.rop.cst.CstString;
import com.google.dexmaker.dx.rop.cst.CstType;
import com.google.dexmaker.dx.rop.cst.TypedConstant;

final class Constants {
    private Constants() {
    }

    static TypedConstant getConstant(Object value) {
        if (value == null) {
            return CstKnownNull.THE_ONE;
        }
        if (value instanceof Boolean) {
            return CstBoolean.make((Boolean)value);
        }
        if (value instanceof Byte) {
            return CstByte.make((Byte)value);
        }
        if (value instanceof Character) {
            return CstChar.make(((Character)value).charValue());
        }
        if (value instanceof Double) {
            return CstDouble.make(Double.doubleToLongBits((Double)value));
        }
        if (value instanceof Float) {
            return CstFloat.make(Float.floatToIntBits(((Float)value).floatValue()));
        }
        if (value instanceof Integer) {
            return CstInteger.make((Integer)value);
        }
        if (value instanceof Long) {
            return CstLong.make((Long)value);
        }
        if (value instanceof Short) {
            return CstShort.make((Short)value);
        }
        if (value instanceof String) {
            return new CstString((String)value);
        }
        if (value instanceof Class) {
            return new CstType(TypeId.get((Class)value).ropType);
        }
        if (value instanceof TypeId) {
            return new CstType(((TypeId)value).ropType);
        }
        throw new UnsupportedOperationException("Not a constant: " + value);
    }
}

