/*
 * Decompiled with CFR 0.152.
 */
package com.google.dexmaker;

import java.io.File;
import java.lang.reflect.Field;
import java.util.ArrayList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class AppDataDirGuesser {
    AppDataDirGuesser() {
    }

    public File guess() {
        try {
            ClassLoader classLoader = this.guessSuitableClassLoader();
            Class<?> clazz = Class.forName("dalvik.system.PathClassLoader");
            clazz.cast(classLoader);
            String pathFromThisClassLoader = this.getPathFromThisClassLoader(classLoader, clazz);
            File[] results = this.guessPath(pathFromThisClassLoader);
            if (results.length > 0) {
                return results[0];
            }
        }
        catch (ClassCastException ignored) {
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        return null;
    }

    private ClassLoader guessSuitableClassLoader() {
        return AppDataDirGuesser.class.getClassLoader();
    }

    private String getPathFromThisClassLoader(ClassLoader classLoader, Class<?> pathClassLoaderClass) {
        try {
            Field pathField = pathClassLoaderClass.getDeclaredField("path");
            pathField.setAccessible(true);
            return (String)pathField.get(classLoader);
        }
        catch (NoSuchFieldException ignored) {
        }
        catch (IllegalAccessException ignored) {
        }
        catch (ClassCastException ignored) {
            // empty catch block
        }
        String result = classLoader.toString();
        int index = result.lastIndexOf(91);
        result = index == -1 ? result : result.substring(index + 1);
        index = result.indexOf(93);
        return index == -1 ? result : result.substring(0, index);
    }

    File[] guessPath(String input) {
        ArrayList<File> results = new ArrayList<File>();
        for (String potential : AppDataDirGuesser.splitPathList(input)) {
            File cacheDir;
            if (!potential.startsWith("/data/app/")) continue;
            int start = "/data/app/".length();
            int end = potential.lastIndexOf(".apk");
            if (end != potential.length() - 4) continue;
            int dash = potential.indexOf("-");
            if (dash != -1) {
                end = dash;
            }
            String packageName = potential.substring(start, end);
            File dataDir = new File("/data/data/" + packageName);
            if (!this.isWriteableDirectory(dataDir) || !this.fileOrDirExists(cacheDir = new File(dataDir, "cache")) && !cacheDir.mkdir() || !this.isWriteableDirectory(cacheDir)) continue;
            results.add(cacheDir);
        }
        return results.toArray(new File[results.size()]);
    }

    static String[] splitPathList(String input) {
        String trimmed = input;
        if (input.startsWith("dexPath=")) {
            int start = "dexPath=".length();
            int end = input.indexOf(44);
            trimmed = end == -1 ? input.substring(start) : input.substring(start, end);
        }
        return trimmed.split(":");
    }

    boolean fileOrDirExists(File file) {
        return file.exists();
    }

    boolean isWriteableDirectory(File file) {
        return file.isDirectory() && file.canWrite();
    }
}

