/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
package com.sample.managedbean;

import com.sample.BackingDTO;
import com.sample.FacesContextUtil;
import com.sample.Person;
import com.sample.SessionDTO;
import com.sample.ifacade.BackingBeanFacade11;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.PostConstruct;
import javax.faces.bean.ManagedBean;
import javax.faces.bean.ViewScoped;
import javax.inject.Inject;

/**
 *
 * @author konishiyuji
 */
@ManagedBean
@ViewScoped
public class AddPersonBean implements Serializable {
    @Inject
    private FacesContextUtil facesContextUtil;
    @Inject
    private SessionDTO sessionDTO;
    @Inject
    private BackingBeanFacade11 backingBeanFacade;
    
    private Person person;
    
    @PostConstruct
    public void execute(){
        System.err.println("BEGIN: AddPersonBean.execute()");
        
        List<String> messages = (List<String>) sessionDTO.get("MESSAGES");
        facesContextUtil.addMessages(messages);
        sessionDTO.put("MESSAGES", null);

        // DTO生成
        BackingDTO backingDto = new BackingDTO();
        
        // 業務ロジックの呼び出し
        String errorCode = backingBeanFacade.execute(backingDto);
        if (!errorCode.equals("000")){
            // エラー
            sessionDTO.put("MESSAGES", messages);
            facesContextUtil.redirect("personList");
            return;
        }
        person = (Person) backingDto.get("PERSON");
        
        System.err.println("END : AddPersonBean.execute()");
    }

    public String action(){
        // TODO actionメソッド内でのエラー処理
        String errorCode = "000";
        if (!errorCode.equals("000")){
            List<String> messages = new ArrayList<>();
            messages.add("エラーです");
            sessionDTO.put("MESSAGES", messages);
            return "addPerson";
        }

        sessionDTO.put("PERSON", person);
        return "addPersonConf";
    }

    public String cancel(){
        return "personList";
    }
    
    /**
     * @return the person
     */
    public Person getPerson() {
        return person;
    }

    /**
     * @param person the person to set
     */
    public void setPerson(Person person) {
        this.person = person;
    }
}
