/*
 * Decompiled with CFR 0.152.
 */
package CarnageHack;

import CarnageHack.CarnageHack;
import CarnageHack.Oke;
import CarnageHack.OkeSoftTracePanel;
import java.awt.Dialog;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Label;

final class OkeStatusWindow
extends Dialog {
    Oke oke;
    Label position;
    Label hp;
    Label fuel;
    Label heat;
    Label main_bullette;
    Label sub_bullette;
    Label software;
    Label status;
    Label option;
    Label backpack;
    Label counterA;
    Label counterB;
    Label counterC;
    Label counterD;
    Label counterE;
    Label counterF;
    OkeSoftTracePanel tracepanel;
    private static final long serialVersionUID = 32L;

    OkeStatusWindow(Oke p) {
        super(CarnageHack.getFrame(), "Status", false);
        GridBagLayout glayout = new GridBagLayout();
        GridBagConstraints gconst = new GridBagConstraints();
        this.oke = p;
        this.setLayout(glayout);
        this.position = new Label();
        this.hp = new Label();
        this.fuel = new Label();
        this.heat = new Label();
        this.main_bullette = new Label();
        this.sub_bullette = new Label();
        this.software = new Label();
        this.status = new Label();
        this.option = new Label();
        this.backpack = new Label();
        this.counterA = new Label();
        this.counterB = new Label();
        this.counterC = new Label();
        this.counterD = new Label();
        this.counterE = new Label();
        this.counterF = new Label();
        this.tracepanel = new OkeSoftTracePanel();
        gconst.fill = 1;
        gconst.gridwidth = 1;
        gconst.gridheight = 16;
        gconst.weightx = 1.0;
        gconst.weighty = 1.0;
        glayout.setConstraints(this.tracepanel, gconst);
        this.add(this.tracepanel);
        gconst.gridwidth = 0;
        gconst.gridheight = 1;
        gconst.weightx = 0.0;
        gconst.weighty = 0.0;
        glayout.setConstraints(this.position, gconst);
        this.add(this.position);
        glayout.setConstraints(this.hp, gconst);
        this.add(this.hp);
        glayout.setConstraints(this.fuel, gconst);
        this.add(this.fuel);
        glayout.setConstraints(this.heat, gconst);
        this.add(this.heat);
        glayout.setConstraints(this.main_bullette, gconst);
        this.add(this.main_bullette);
        glayout.setConstraints(this.sub_bullette, gconst);
        this.add(this.sub_bullette);
        glayout.setConstraints(this.software, gconst);
        this.add(this.software);
        glayout.setConstraints(this.status, gconst);
        this.add(this.status);
        glayout.setConstraints(this.option, gconst);
        this.add(this.option);
        glayout.setConstraints(this.backpack, gconst);
        this.add(this.backpack);
        glayout.setConstraints(this.counterA, gconst);
        this.add(this.counterA);
        glayout.setConstraints(this.counterB, gconst);
        this.add(this.counterB);
        glayout.setConstraints(this.counterC, gconst);
        this.add(this.counterC);
        glayout.setConstraints(this.counterD, gconst);
        this.add(this.counterD);
        glayout.setConstraints(this.counterE, gconst);
        this.add(this.counterE);
        glayout.setConstraints(this.counterF, gconst);
        this.add(this.counterF);
        this.update();
        this.pack();
        this.setLocation(410, 0);
        this.setSize(this.getPreferredSize());
        this.setVisible(true);
    }

    String make_weapon_param() {
        int param = this.oke.get_status_param();
        int nweapon = param & 1;
        int ncount = param >> 1;
        StringBuilder wkresult = new StringBuilder();
        wkresult.append(nweapon == 0 ? "MAIN" : "SUB");
        if (nweapon != 0) {
            wkresult.append('[');
            wkresult.append(ncount);
            wkresult.append(']');
        }
        return wkresult.toString();
    }

    String make_direction_param() {
        switch (this.oke.get_status_param()) {
            case 0: {
                return "FORWARD";
            }
            case 1: {
                return "BACKWARD";
            }
            case 3: {
                return "LEFT";
            }
            case 2: {
                return "RIGHT";
            }
        }
        return "?";
    }

    String make_oke_iff() {
        switch (this.oke.get_iff()) {
            case 1: {
                return "YOURS";
            }
            case 0: {
                return "ENEMY";
            }
        }
        return "?";
    }

    String align_string(String s) {
        for (int nlen = s.length(); nlen < 40; ++nlen) {
            s = s + ' ';
        }
        return s;
    }

    public void update() {
        String status_str = "X:" + this.oke.get_x() + " Y:" + this.oke.get_y() + " Direction:" + this.oke.get_degree() + " B" + (this.oke.get_floor() + 1) + "F";
        this.position.setText(this.align_string(status_str));
        status_str = "IFF:" + this.make_oke_iff() + " HP:" + this.oke.get_hp() + "/" + this.oke.get_max_hp();
        this.hp.setText(this.align_string(status_str));
        status_str = "FUEL:" + this.oke.get_fuel() + "/" + this.oke.get_hardware().get_fueltank().get_fuel();
        this.fuel.setText(this.align_string(status_str));
        status_str = "HEAT:" + this.oke.get_tempture();
        this.heat.setText(this.align_string(status_str));
        status_str = "MAIN:" + this.oke.get_bullette(0);
        this.main_bullette.setText(this.align_string(status_str));
        status_str = "SUB:" + this.oke.get_bullette(1);
        this.sub_bullette.setText(this.align_string(status_str));
        status_str = "SOFTWARE:" + this.oke.get_current_software() + " CHIP X:" + this.oke.get_chipx() + " Y:" + this.oke.get_chipy();
        this.software.setText(this.align_string(status_str));
        switch (this.oke.get_status()) {
            case 0: {
                status_str = "NORMAL";
                break;
            }
            case 1: {
                status_str = "MOVE ";
                status_str = status_str + this.make_direction_param();
                break;
            }
            case 2: {
                status_str = "TURN ";
                switch (this.oke.get_status_param()) {
                    case 0: {
                        status_str = status_str + "LEFT";
                        break;
                    }
                    case 1: {
                        status_str = status_str + "RIGHT";
                    }
                }
                break;
            }
            case 3: {
                status_str = "GET";
                break;
            }
            case 5: {
                status_str = "Prepare FIRE ";
                status_str = status_str + this.make_weapon_param();
                break;
            }
            case 6: {
                status_str = "FIRE";
                status_str = status_str + this.make_weapon_param();
                break;
            }
            case 7: {
                status_str = "End FIRE";
                status_str = status_str + this.make_weapon_param();
                break;
            }
            case 8: {
                status_str = "FIGHT";
                break;
            }
            case 9: {
                status_str = "PRONE";
                break;
            }
            case 10: {
                status_str = "Prepare JUMP ";
                status_str = status_str + this.make_direction_param();
                break;
            }
            case 11: {
                status_str = "JUMP ";
                status_str = status_str + this.make_direction_param();
                break;
            }
            case 12: {
                status_str = "End JUMP ";
                status_str = status_str + this.make_direction_param();
                break;
            }
            case 4: {
                status_str = "UP/DOWN STAIRS";
                break;
            }
            case 99: {
                status_str = "DAMAGED";
                break;
            }
            case 100: {
                status_str = "SELF DESTRUCT";
                break;
            }
            default: {
                status_str = "??";
            }
        }
        this.status.setText(this.align_string("STATUS:" + status_str));
        status_str = "OPTION:" + (this.oke.get_option_status() == 1 ? "USE" : "NO USE");
        this.option.setText(this.align_string(status_str));
        status_str = "MOBILITY:" + this.oke.get_speed() + " BACKPACK:" + this.oke.get_backpack_count();
        this.backpack.setText(this.align_string(status_str));
        status_str = "A = " + this.oke.get_counter("A");
        this.counterA.setText(this.align_string(status_str));
        status_str = "B = " + this.oke.get_counter("B");
        this.counterB.setText(this.align_string(status_str));
        status_str = "C = " + this.oke.get_counter("C");
        this.counterC.setText(this.align_string(status_str));
        status_str = "D = " + this.oke.get_counter("D");
        this.counterD.setText(this.align_string(status_str));
        status_str = "E = " + this.oke.get_counter("E");
        this.counterE.setText(this.align_string(status_str));
        status_str = "F = " + this.oke.get_counter("F");
        this.counterF.setText(this.align_string(status_str));
        this.tracepanel.set_trace(this.oke);
    }

    public void set_oke(Oke p) {
        this.oke = p;
        this.invalidate();
    }
}

