/*
 * Decompiled with CFR 0.152.
 */
package CarnageHack;

import CarnageHack.Oke;
import CarnageHack.OkeSoftChip;
import CarnageHack.OkeSoftData;
import java.awt.Canvas;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;

public class OkeSoftTracePanel
extends Canvas {
    static final Color baseColor = new Color(0, 0, 0);
    static final Color greenChipColor = new Color(0, 127, 0);
    static final Color redChipColor = new Color(127, 0, 0);
    static final Color greenFocusChipColor = new Color(0, 255, 0);
    static final Color redFocusChipColor = new Color(255, 0, 0);
    static final Color normalCodeColor = new Color(0, 0, 127);
    static final Color condCodeColor = new Color(127, 0, 127);
    static int viewChipWidth = 16;
    static int viewChipHeight = 16;
    Oke.ChipTrace[] traceData = null;
    OkeSoftData software = null;

    static void setViewChipSize(int w, int h) {
        if (w < 8) {
            w = 8;
        }
        if (h < 8) {
            h = 8;
        }
        viewChipWidth = w;
        viewChipHeight = h;
    }

    OkeSoftTracePanel() {
    }

    @Override
    public Dimension getPreferredSize() {
        return new Dimension(16 * viewChipWidth + 4, 16 * viewChipHeight + 4);
    }

    @Override
    public Dimension getMinimumSize() {
        return new Dimension(16 * viewChipWidth + 4, 16 * viewChipHeight + 4);
    }

    @Override
    public void update(Graphics g) {
        this.paint(g);
    }

    @Override
    public void paint(Graphics g) {
        int x;
        int y;
        int nwidth = 16 * viewChipWidth + 4;
        int nheight = 16 * viewChipHeight + 4;
        Image offscreen = this.createImage(nwidth, nheight);
        Graphics offg = offscreen.getGraphics();
        offg.setColor(baseColor);
        offg.fillRect(0, 0, nwidth, nheight);
        offg.setColor(Color.YELLOW);
        for (y = 0; y < 16; ++y) {
            for (x = 0; x < 16; ++x) {
                offg.drawRect(x * viewChipWidth + 2, y * viewChipHeight + 2, viewChipWidth, viewChipHeight);
            }
        }
        if (this.software != null) {
            for (y = 0; y < 16; ++y) {
                for (x = 0; x < 16; ++x) {
                    OkeSoftChip chip = this.software.get(x, y);
                    if (chip == null || chip.nullchip()) continue;
                    offg.setColor(chip.is_condchip() ? condCodeColor : normalCodeColor);
                    offg.fillRect(x * viewChipWidth + 2 + 1, y * viewChipHeight + 2 + 1, viewChipWidth - 2, viewChipHeight - 2);
                }
            }
        }
        if (this.traceData != null) {
            int i;
            int nmax = this.traceData.length - 1;
            for (i = 0; i < nmax; ++i) {
                offg.setColor(this.traceData[i].get_branch() ? redChipColor : greenChipColor);
                offg.fillRect(this.traceData[i].get_position_x() * viewChipWidth + 2 + 1, this.traceData[i].get_position_y() * viewChipHeight + 2 + 1, viewChipWidth - 2, viewChipHeight - 2);
            }
            if (this.traceData[i] != null) {
                offg.setColor(this.traceData[i].get_branch() ? redFocusChipColor : greenFocusChipColor);
                offg.fillRect(this.traceData[i].get_position_x() * viewChipWidth + 2 + 1, this.traceData[i].get_position_y() * viewChipHeight + 2 + 1, viewChipWidth - 2, viewChipHeight - 2);
            }
        }
        g.drawImage(offscreen, 0, 0, this);
    }

    public void set_trace(Oke p) {
        if (p != null) {
            this.traceData = p.get_trace();
            this.software = p.get_software();
        } else {
            this.traceData = null;
        }
        this.repaint();
    }
}

