/*
 * Decompiled with CFR 0.152.
 */
package CarnageHack;

import CarnageHack.CHArrayList;
import CarnageHack.CHutil;
import CarnageHack.CarnageHack;
import CarnageHack.DungeonFloor;
import CarnageHack.FloorPoint;
import CarnageHack.FloorTile;
import CarnageHack.Oke;
import CarnageHack.OkeBullette;
import CarnageHack.OkeDungeonEvent;
import CarnageHack.OkeDungeonMouseEvent;
import CarnageHack.OkeDungeonTimer;
import CarnageHack.OkeHardArmor;
import CarnageHack.OkeHardCpu;
import CarnageHack.OkeHardEngine;
import CarnageHack.OkeHardOption;
import CarnageHack.OkeHardWeapon;
import CarnageHack.OkeStatusWindow;
import java.awt.Canvas;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.Toolkit;
import java.awt.image.ImageObserver;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import javax.crypto.Cipher;
import javax.crypto.CipherInputStream;
import javax.crypto.CipherOutputStream;

public class OkeDungeon
extends Canvas {
    static final int BONERATE = 70;
    static final long TICKCOUNT = 100L;
    static final String[] dir_word = new String[]{"N", "NE", "E", "SE", "S", "SW", "W", "NW"};
    static Image hige;
    static Image[] tsukikage;
    static Image[] tsukikage2;
    static Image explosion;
    public static int Width;
    public static int Height;
    CHArrayList bullette;
    CHArrayList oke;
    CHArrayList floor;
    int current_floor;
    int turn_count;
    int update_timer;
    int update_count;
    int higex;
    int higey;
    int higefloor;
    Dialog dialog;
    boolean goalin;
    boolean havehige;
    Oke pcOke;
    OkeDungeonTimer timertask;
    OkeStatusWindow status;
    int basex;
    int basey;
    volatile boolean lockview;
    volatile boolean nowdraw;
    volatile Oke viewBaseOke;
    private static final long serialVersionUID = 31L;

    static void init(Object obj, MediaTracker mt) {
        Toolkit tk = Toolkit.getDefaultToolkit();
        hige = tk.getImage(obj.getClass().getResource("tile/hige.png"));
        mt.addImage(hige, 0);
        tsukikage = new Image[8];
        tsukikage2 = new Image[8];
        for (int i = 0; i < 8; ++i) {
            OkeDungeon.tsukikage[i] = tk.getImage(obj.getClass().getResource("tile/tsukikage" + dir_word[i] + ".png"));
            mt.addImage(tsukikage[i], 0);
            OkeDungeon.tsukikage2[i] = tk.getImage(obj.getClass().getResource("tile/tsukikage2" + dir_word[i] + ".png"));
            mt.addImage(tsukikage2[i], 0);
        }
        explosion = tk.getImage(obj.getClass().getResource("tile/explosion.png"));
        mt.addImage(explosion, 0);
    }

    public static int startup_image(Graphics g, int x, int y, int cx, ImageObserver obs) {
        int i;
        int n = 0;
        g.drawImage(hige, x, y, FloorTile.tileBaseX, FloorTile.tileBaseY, obs);
        if ((x += FloorTile.tileBaseX) >= cx) {
            x = 0;
            y += FloorTile.tileBaseY;
        }
        ++n;
        g.drawImage(explosion, x, y, FloorTile.tileBaseX, FloorTile.tileBaseY, obs);
        if ((x += FloorTile.tileBaseX) >= cx) {
            x = 0;
            y += FloorTile.tileBaseY;
        }
        ++n;
        for (i = 0; i < 8; ++i) {
            g.drawImage(tsukikage[i], x, y, FloorTile.tileBaseX, FloorTile.tileBaseY, obs);
            if ((x += FloorTile.tileBaseX) >= cx) {
                x = 0;
                y += FloorTile.tileBaseY;
            }
            ++n;
        }
        for (i = 0; i < 8; ++i) {
            g.drawImage(tsukikage2[i], x, y, FloorTile.tileBaseX, FloorTile.tileBaseY, obs);
            if ((x += FloorTile.tileBaseX) >= cx) {
                x = 0;
                y += FloorTile.tileBaseY;
            }
            ++n;
        }
        return n;
    }

    OkeDungeon(Dialog d, Oke pc) {
        boolean usebone;
        this.setSize(Width, Height);
        this.current_floor = 0;
        this.turn_count = 0;
        this.basex = 0;
        this.basey = 0;
        this.lockview = false;
        this.higefloor = (int)Math.floor(Math.random() * 10.0) + 20;
        this.dialog = d;
        this.goalin = false;
        this.havehige = false;
        this.bullette = new CHArrayList();
        this.oke = new CHArrayList();
        this.floor = new CHArrayList();
        DungeonFloor dungeon = this.load_bone_file();
        if (dungeon == null) {
            dungeon = new DungeonFloor(this.current_floor);
            usebone = false;
        } else {
            usebone = true;
        }
        this.floor.add(dungeon);
        if (!usebone) {
            this.plot_init_enemy(this.current_floor);
        }
        this.viewBaseOke = this.pcOke = pc;
        this.oke.add(this.pcOke);
        this.pcOke.set_x(dungeon.get_up_stairsx());
        this.pcOke.set_y(dungeon.get_up_stairsy());
        this.pcOke.set_floor(this.current_floor);
        this.dialog.setTitle("OKE Dungeon B" + (this.current_floor + 1) + "F");
        this.update_timer = CarnageHack.get_update_timer();
        this.update_count = 0;
        this.status = new OkeStatusWindow(this.pcOke);
        this.addMouseListener(new OkeDungeonMouseEvent(this));
        this.dialog.addComponentListener(new OkeDungeonEvent(this.status));
        this.nowdraw = false;
    }

    public void start_timer() {
        this.timertask = new OkeDungeonTimer(this, 100L);
        this.timertask.start();
    }

    public void set_update_timer(int n) {
        this.update_timer = n;
        if (this.update_timer < 1) {
            this.update_timer = 1;
        }
        CarnageHack.set_update_timer(this.update_timer);
        CarnageHack.save_setup();
    }

    public void set_base(int x, int y) {
        this.basex = x;
        this.basey = y;
        this.invalidate();
    }

    public int get_basex() {
        return this.basex;
    }

    public int get_basey() {
        return this.basey;
    }

    public void set_lockview(boolean b) {
        this.lockview = b;
    }

    public void set_viewoke(int x, int y) {
        this.viewBaseOke = this.search_oke(x, y);
        if (this.viewBaseOke == null) {
            this.viewBaseOke = this.pcOke;
        }
        this.status.set_oke(this.viewBaseOke);
    }

    public boolean isnowdraw() {
        return this.nowdraw;
    }

    @Override
    public void update(Graphics g) {
        this.paint(g);
    }

    @Override
    public void paint(Graphics orgg) {
        int y;
        int x;
        int i;
        Dimension winsize = this.getSize();
        int view_x = winsize.width / FloorTile.tileBaseX;
        int view_y = winsize.height / FloorTile.tileBaseY;
        Image offscreen = this.createImage(winsize.width, winsize.height);
        Graphics g = offscreen.getGraphics();
        this.nowdraw = true;
        if (!this.lockview) {
            if (this.viewBaseOke == null) {
                this.viewBaseOke = this.pcOke;
            }
            if (this.viewBaseOke != this.pcOke && (this.viewBaseOke.isdead() || this.viewBaseOke.get_floor() != this.current_floor)) {
                this.viewBaseOke = this.pcOke;
            }
            this.basex = view_x < 50 ? this.viewBaseOke.get_x() - view_x / 2 : 0;
            this.basey = view_y < 50 ? this.viewBaseOke.get_y() - view_y / 2 : 0;
        }
        DungeonFloor dungeon = (DungeonFloor)this.floor.get(this.current_floor);
        dungeon.draw_floor(g, this, this.basex, this.basey, view_x, view_y);
        int nmax = this.oke.size();
        for (i = 0; i < nmax; ++i) {
            Image icon;
            Oke target = (Oke)this.oke.get(i);
            if (target.get_floor() != this.current_floor) continue;
            if (target.get_hp() == 0 || target.get_status() == 99) {
                icon = explosion;
            } else {
                int dir = target.get_direction();
                icon = target.get_iff() == 1 ? tsukikage[dir] : tsukikage2[dir];
            }
            x = target.get_x();
            y = target.get_y();
            if (x < this.basex || x >= this.basex + view_x || y < this.basey || y >= this.basey + view_y) continue;
            g.drawImage(icon, (x - this.basex) * FloorTile.tileBaseX, (y - this.basey) * FloorTile.tileBaseY, FloorTile.tileBaseX, FloorTile.tileBaseY, this);
        }
        nmax = this.bullette.size();
        for (i = 0; i < nmax; ++i) {
            OkeBullette p = (OkeBullette)this.bullette.get(i);
            if (p.get_floor() != this.current_floor) continue;
            x = p.get_x();
            y = p.get_y();
            if (x < this.basex || x >= this.basex + view_x || y < this.basey || y >= this.basey + view_y) continue;
            p.draw(g, this, this.basex, this.basey);
        }
        if (!this.havehige && this.higefloor == this.current_floor) {
            g.drawImage(hige, (this.higex - this.basey) * FloorTile.tileBaseX, (this.higey - this.basey) * FloorTile.tileBaseY, FloorTile.tileBaseX, FloorTile.tileBaseY, this);
        }
        this.nowdraw = false;
        orgg.drawImage(offscreen, 0, 0, this);
    }

    public void action() {
        this.exec();
        this.move();
        this.turn_end();
        this.repaint();
    }

    public boolean is_hige(int x, int y, int f) {
        return f == this.higefloor && x == this.higex && y == this.higey;
    }

    public int prev_floor() {
        if (this.current_floor == 0) {
            this.goalin = true;
            this.timertask.end();
            this.dialog.dispose();
            CarnageHack.save_setup();
        } else {
            --this.current_floor;
            DungeonFloor dungeon = (DungeonFloor)this.floor.get(this.current_floor);
            this.pcOke.set_x(dungeon.get_down_stairsx());
            this.pcOke.set_y(dungeon.get_down_stairsy());
            this.pcOke.set_floor(this.current_floor);
            this.dialog.setTitle("OKE Dungeon B" + (this.current_floor + 1) + "F");
            this.repaint();
        }
        return this.current_floor;
    }

    public int generate_floor() {
        boolean usebone;
        int new_floor = this.floor.size();
        DungeonFloor dungeon = this.load_bone_file();
        if (dungeon == null) {
            dungeon = new DungeonFloor(new_floor);
            usebone = false;
        } else {
            usebone = true;
        }
        this.floor.add(dungeon);
        if (!usebone) {
            this.plot_init_enemy(new_floor);
        }
        if (this.higefloor == new_floor) {
            do {
                this.higex = (int)(Math.random() * 48.0) + 1;
                this.higey = (int)(Math.random() * 48.0) + 1;
            } while (dungeon.iswall(this.higex, this.higey));
            dungeon.clear_downstairs();
        }
        return new_floor;
    }

    public int next_floor() {
        ++this.current_floor;
        if (this.current_floor >= this.floor.size()) {
            this.current_floor = this.generate_floor();
        }
        DungeonFloor dungeon = (DungeonFloor)this.floor.get(this.current_floor);
        this.pcOke.set_x(dungeon.get_up_stairsx());
        this.pcOke.set_y(dungeon.get_up_stairsy());
        this.pcOke.set_floor(this.current_floor);
        this.dialog.setTitle("OKE Dungeon B" + (this.current_floor + 1) + "F");
        this.repaint();
        return this.current_floor;
    }

    public DungeonFloor get_floor(int n) {
        if (n >= 0 && n < this.floor.size()) {
            return (DungeonFloor)this.floor.get(n);
        }
        return null;
    }

    public int get_maximum_floor() {
        return this.floor.size();
    }

    public Oke collision_oke(int x, int y, int floor) {
        int nmax = this.oke.size();
        for (int i = 0; i < nmax; ++i) {
            Oke target = (Oke)this.oke.get(i);
            if (target.get_hp() <= 0 || !target.collision(x, y, floor)) continue;
            return target;
        }
        return null;
    }

    public Oke collision_oke(Oke p) {
        int nmax = this.oke.size();
        int x = p.get_x();
        int y = p.get_y();
        int nfloor = p.get_floor();
        for (int i = 0; i < nmax; ++i) {
            Oke target = (Oke)this.oke.get(i);
            if (target == p || target.get_hp() <= 0 || !target.collision(x, y, nfloor)) continue;
            return target;
        }
        return null;
    }

    public OkeBullette collision_bullette(OkeBullette orgb, int x, int y, int floor) {
        int nmax = this.bullette.size();
        for (int i = 0; i < nmax; ++i) {
            OkeBullette p = (OkeBullette)this.bullette.get(i);
            if (p == orgb || p.get_max_range() <= 0 || !p.collision(x, y, floor)) continue;
            return p;
        }
        return null;
    }

    public boolean collision_wall(int x, int y, int f) {
        DungeonFloor dungeon = (DungeonFloor)this.floor.get(f);
        int nmax = dungeon.wall_list.size();
        for (int i = 0; i < nmax; ++i) {
            FloorPoint fp = (FloorPoint)dungeon.wall_list.get(i);
            if (x != fp.x || y != fp.y) continue;
            return true;
        }
        return false;
    }

    public Oke search_oke(boolean biff, Oke p, int dir, int range, int distance) {
        int nmax = this.oke.size();
        int okex = p.get_x();
        int okey = p.get_y();
        int okefloor = p.get_floor();
        int srange = range / 2;
        int basedeg = p.get_degree() + dir;
        Oke mostnear = null;
        int neardistance = distance + 1;
        if (basedeg < -179) {
            basedeg += 360;
        } else if (basedeg > 180) {
            basedeg -= 360;
        }
        for (int i = 0; i < nmax; ++i) {
            int deg;
            int d1;
            int d;
            Oke target = (Oke)this.oke.get(i);
            if (target == p || target.get_floor() != okefloor || target.get_hp() == 0 || biff && target.get_iff() == p.get_iff() || (d = CHutil.calc_distance(target.get_x() - okex, target.get_y() - okey)) >= neardistance || (d1 = CHutil.calc_deg_delta(deg = CHutil.atan2(target.get_x() - okex, -(target.get_y() - okey)), basedeg)) > srange) continue;
            mostnear = target;
            neardistance = d;
        }
        return mostnear;
    }

    public OkeBullette search_bullette(Oke p, int dir, int range, int distance) {
        int nmax = this.bullette.size();
        int okex = p.get_x();
        int okey = p.get_y();
        int okefloor = p.get_floor();
        int srange = range / 2;
        int basedeg = p.get_degree() + dir;
        OkeBullette mostnear = null;
        int neardistance = distance + 1;
        if (basedeg < -179) {
            basedeg += 360;
        } else if (basedeg > 180) {
            basedeg -= 360;
        }
        for (int i = 0; i < nmax; ++i) {
            int d;
            OkeBullette target = (OkeBullette)this.bullette.get(i);
            if (target.get_floor() != okefloor || target.get_max_range() == 0 || target.get_x() == okex && target.get_y() == okey || (d = CHutil.calc_distance(target.get_x() - okex, target.get_y() - okey)) <= 0 || d >= neardistance) continue;
            int deg = CHutil.atan2(okex - target.get_x(), -(okey - target.get_y()));
            int tdeg = target.get_direction();
            if (tdeg < -179) {
                tdeg += 360;
            } else if (tdeg > 180) {
                tdeg -= 360;
            }
            int d1 = CHutil.calc_deg_delta(deg, tdeg);
            if (d1 > 45 || (d1 = CHutil.calc_deg_delta(deg = CHutil.atan2(target.get_x() - okex, -(target.get_y() - okey)), basedeg)) > srange) continue;
            mostnear = target;
            neardistance = d;
        }
        return mostnear;
    }

    public boolean search_wall(Oke p, int dir, int range, int distance) {
        DungeonFloor dungeon = (DungeonFloor)this.floor.get(p.get_floor());
        int nmax = dungeon.wall_list.size();
        int okex = p.get_x();
        int okey = p.get_y();
        int srange = range / 2;
        int basedeg = p.get_degree() + dir;
        if (basedeg < -179) {
            basedeg += 360;
        } else if (basedeg > 180) {
            basedeg -= 360;
        }
        for (int i = 0; i < nmax; ++i) {
            int deg;
            int d1;
            FloorPoint fp = (FloorPoint)dungeon.wall_list.get(i);
            int d = CHutil.calc_distance(fp.x - okex, fp.y - okey);
            if (d > distance || (d1 = CHutil.calc_deg_delta(deg = CHutil.atan2(fp.x - okex, -(fp.y - okey)), basedeg)) > srange) continue;
            return true;
        }
        return false;
    }

    public boolean search_parts(Oke p, int dir, int range, int distance) {
        DungeonFloor dungeon = (DungeonFloor)this.floor.get(p.get_floor());
        int nmax = dungeon.item_list.size();
        int okex = p.get_x();
        int okey = p.get_y();
        int srange = range / 2;
        int basedeg = p.get_degree() + dir;
        if (basedeg < -179) {
            basedeg += 360;
        } else if (basedeg > 180) {
            basedeg -= 360;
        }
        for (int i = 0; i < nmax; ++i) {
            int deg;
            int d1;
            FloorPoint fp = (FloorPoint)dungeon.item_list.get(i);
            if (okex == fp.x && okey == fp.y) {
                return true;
            }
            int d = CHutil.calc_distance(fp.x - okex, fp.y - okey);
            if (d > distance || (d1 = CHutil.calc_deg_delta(deg = CHutil.atan2(fp.x - okex, -(fp.y - okey)), basedeg)) > srange) continue;
            return true;
        }
        if (!this.havehige && this.higefloor == p.get_floor()) {
            int deg;
            int d1;
            if (okex == this.higex && okey == this.higey) {
                return true;
            }
            int d = CHutil.calc_distance(this.higex - okex, this.higey - okey);
            if (d <= distance && (d1 = CHutil.calc_deg_delta(deg = CHutil.atan2(this.higex - okex, -(this.higey - okey)), basedeg)) <= srange) {
                return true;
            }
        }
        return false;
    }

    public boolean search_stairs(Oke p, int dir, int range, int distance, boolean upstairs) {
        int deg;
        int d1;
        int ty;
        int tx;
        DungeonFloor dungeon = (DungeonFloor)this.floor.get(p.get_floor());
        int okex = p.get_x();
        int okey = p.get_y();
        int srange = range / 2;
        int basedeg = p.get_degree() + dir;
        if (basedeg < -179) {
            basedeg += 360;
        } else if (basedeg > 180) {
            basedeg -= 360;
        }
        if (upstairs) {
            tx = dungeon.get_up_stairsx();
            ty = dungeon.get_up_stairsy();
        } else {
            tx = dungeon.get_down_stairsx();
            ty = dungeon.get_down_stairsy();
        }
        if (okex == tx && okey == ty) {
            return true;
        }
        int d = CHutil.calc_distance(tx - okex, ty - okey);
        if (d == 0) {
            return true;
        }
        return d <= distance && (d1 = CHutil.calc_deg_delta(deg = CHutil.atan2(tx - okex, -(ty - okey)), basedeg)) <= srange;
    }

    public Oke search_oke(int x, int y) {
        int nmax = this.oke.size();
        for (int i = 0; i < nmax; ++i) {
            Oke p = (Oke)this.oke.get(i);
            if (p.get_hp() <= 0 || p.get_x() != x || p.get_y() != y) continue;
            return p;
        }
        return null;
    }

    public void exec() {
        Oke p;
        int i;
        int nmax = this.oke.size();
        for (i = 0; i < nmax; ++i) {
            p = (Oke)this.oke.get(i);
            p.exec(this);
        }
        for (i = 0; i < nmax; ++i) {
            p = (Oke)this.oke.get(i);
            p.doaction(this);
        }
    }

    public void move() {
        Object p;
        int i;
        int nmax = this.bullette.size();
        for (i = 0; i < nmax; ++i) {
            p = (OkeBullette)this.bullette.get(i);
            ((OkeBullette)p).move(this);
        }
        nmax = this.oke.size();
        for (i = 0; i < nmax; ++i) {
            p = (Oke)this.oke.get(i);
            ((Oke)p).movement(this);
        }
    }

    public void turn_end() {
        Object p;
        int i;
        int nmax = this.bullette.size();
        ++this.turn_count;
        boolean bsecond = this.turn_count % 10 == 0;
        ++this.update_count;
        if (this.update_count >= this.update_timer) {
            this.update_count = 0;
            this.status.update();
        }
        for (i = 0; i < nmax; ++i) {
            p = (OkeBullette)this.bullette.get(i);
            if (((OkeBullette)p).get_max_range() != 0) continue;
            this.bullette.remove(i);
            --i;
            nmax = this.bullette.size();
        }
        nmax = this.oke.size();
        for (i = 0; i < nmax; ++i) {
            p = (Oke)this.oke.get(i);
            if (((Oke)p).isdead()) {
                String wk;
                int b;
                DungeonFloor dungeon = (DungeonFloor)this.floor.get(((Oke)p).get_floor());
                int okex = ((Oke)p).get_x();
                int okey = ((Oke)p).get_y();
                Oke attacker = ((Oke)p).get_attacker();
                if (attacker != null) {
                    attacker.inc_destroycount();
                }
                System.out.print(p);
                System.out.print(" is killed by ");
                System.out.println(attacker);
                if (((Oke)p).get_backpack_count() > 0) {
                    int nbackpack = ((Oke)p).get_backpack_count();
                    for (int j = 0; j < nbackpack; ++j) {
                        String[] field = CHutil.split(((Oke)p).get_backpack(j), ':', 3);
                        System.out.println(((Oke)p).get_backpack(j));
                        dungeon.additem(okex, okey, field[0], field[2], Integer.parseInt(field[1]));
                    }
                }
                if (CarnageHack.dice100() > 70 && (b = ((Oke)p).get_bullette(0)) > 0) {
                    OkeHardWeapon w = ((Oke)p).get_hardware().get_mainweapon();
                    wk = w.save();
                    dungeon.additem(okex, okey, "M", wk, b);
                }
                if (CarnageHack.dice100() > 70 && (b = ((Oke)p).get_bullette(0)) > 0) {
                    OkeHardWeapon w = ((Oke)p).get_hardware().get_subweapon();
                    wk = w.save();
                    dungeon.additem(okex, okey, "S", wk, b);
                }
                if (CarnageHack.dice100() > 70) {
                    OkeHardCpu w = ((Oke)p).get_hardware().get_cpu();
                    String wk2 = w.save();
                    dungeon.additem(okex, okey, "C", wk2, 1);
                }
                if (CarnageHack.dice100() > 70) {
                    OkeHardEngine w = ((Oke)p).get_hardware().get_engine();
                    String wk3 = w.save();
                    dungeon.additem(okex, okey, "E", wk3, 1);
                }
                if (CarnageHack.dice100() > 70) {
                    OkeHardArmor w = ((Oke)p).get_hardware().get_armor();
                    String wk4 = w.save();
                    dungeon.additem(okex, okey, "A", wk4, 1);
                }
                if (CarnageHack.dice100() > 70) {
                    OkeHardOption w = ((Oke)p).get_hardware().get_option();
                    String wk5 = w.save();
                    dungeon.additem(okex, okey, "O", wk5, 1);
                }
                if (((Oke)p).get_hardware().get_option().get_type() == 4) {
                    int d = ((Oke)p).get_hardware().get_option().get_effect();
                    Oke target = this.search_oke(okex - 1, okey);
                    if (target != null) {
                        target.dec_hp(d, (Oke)p, 101);
                        target.add_tempture(d / 10);
                    }
                    if ((target = this.search_oke(okex + 1, okey)) != null) {
                        target.dec_hp(d, (Oke)p, 101);
                        target.add_tempture(d / 10);
                    }
                    if ((target = this.search_oke(okex, okey - 1)) != null) {
                        target.dec_hp(d, (Oke)p, 101);
                        target.add_tempture(d / 10);
                    }
                    if ((target = this.search_oke(okex, okey + 1)) != null) {
                        target.dec_hp(d, (Oke)p, 101);
                        target.add_tempture(d / 10);
                    }
                }
                this.oke.remove(i);
                --i;
                nmax = this.oke.size();
                continue;
            }
            if (((Oke)p).get_hp() <= 0 || !bsecond) continue;
            ((Oke)p).cool_tempture();
            if (((Oke)p).status == 0) continue;
            ((Oke)p).dec_fuel();
        }
        if (this.turn_count == 1800) {
            this.turn_count = 0;
            if (CarnageHack.dice100() > 70) {
                this.plot_init_enemy(this.current_floor);
            }
        }
        if (this.pcOke.isdead() || this.pcOke.get_fuel() == 0) {
            this.timertask.end();
            this.dialog.dispose();
            CarnageHack.save_setup();
            this.check_generate_bone();
        }
    }

    public void close_status() {
        this.status.dispose();
    }

    public void addBullette(OkeBullette b) {
        this.bullette.add(b);
    }

    public void addOke(Oke p, int n) {
        int y;
        int x;
        DungeonFloor dungeon = (DungeonFloor)this.floor.get(n);
        while (dungeon.iswall(x = (int)(Math.random() * 48.0) + 1, y = (int)(Math.random() * 48.0) + 1)) {
        }
        p.set_x(x);
        p.set_y(y);
        p.set_floor(n);
        this.oke.add(p);
    }

    public void makeNewOke(int n) {
        Oke p = new Oke(0, (int)(Math.random() * (double)(n + 1) * 100.0) + (n / 5 + 1) * 100, CarnageHack.makeNewHard(), CarnageHack.makeNewSoft(this), null);
        this.addOke(p, n);
    }

    public boolean get_goalin() {
        return this.goalin;
    }

    public void get_hige() {
        this.havehige = true;
    }

    public boolean is_havehige() {
        return this.havehige;
    }

    public void force_end() {
        this.timertask.end();
        CarnageHack.save_setup();
        this.check_generate_bone();
    }

    private void plot_init_enemy(int nfloor) {
        int nmax = (int)(Math.random() * (double)(nfloor / 5 + 1) * 3.0) + 1;
        for (int i = 0; i < nmax; ++i) {
            this.makeNewOke(nfloor);
        }
    }

    private DungeonFloor load_bone_file() {
        DungeonFloor dungeon = null;
        File ifile = new File("CH2boneB" + this.current_floor + ".dgn");
        if (ifile.exists()) {
            System.out.println("load B" + (this.current_floor + 1) + " bone");
            try {
                Cipher ci = CarnageHack.generateCipher(2);
                CipherInputStream is = new CipherInputStream(new FileInputStream(ifile), ci);
                BufferedReader r = new BufferedReader(new InputStreamReader(is));
                dungeon = new DungeonFloor(r, this.current_floor);
                String wk = r.readLine();
                int nmax = Integer.parseInt(wk);
                for (int i = 0; i < nmax; ++i) {
                    Oke p = new Oke(r);
                    this.oke.add(p);
                }
                r.close();
                is.close();
                System.out.println("success load bone");
                ifile.delete();
            }
            catch (IOException e) {
                dungeon = null;
                System.out.println("fail load bone");
                ifile.delete();
            }
            catch (NumberFormatException e) {
                dungeon = null;
                System.out.println("fail load bone");
                ifile.delete();
            }
        }
        return dungeon;
    }

    void check_generate_bone() {
        if (this.current_floor == this.higefloor) {
            return;
        }
        if (CarnageHack.dice100() > 70) {
            DungeonFloor dungeon = (DungeonFloor)this.floor.get(this.current_floor);
            File ofile = new File("CH2boneB" + this.current_floor + ".dgn");
            System.out.println("generate B" + (this.current_floor + 1) + " bone");
            try {
                Oke p;
                int i;
                Cipher ci = CarnageHack.generateCipher(1);
                CipherOutputStream os = new CipherOutputStream(new FileOutputStream(ofile), ci);
                PrintWriter w = new PrintWriter(new BufferedWriter(new OutputStreamWriter(os)));
                dungeon.save(w);
                int nmax = 1;
                for (i = 0; i < this.oke.size(); ++i) {
                    p = (Oke)this.oke.get(i);
                    if (p.get_iff() != 0 || p.get_hp() <= 0 || p.get_floor() != this.current_floor) continue;
                    ++nmax;
                }
                w.println(nmax);
                System.out.println("OKE count = " + nmax);
                for (i = 0; i < this.oke.size(); ++i) {
                    p = (Oke)this.oke.get(i);
                    if (p.get_iff() != 0 || p.get_hp() <= 0 || p.get_floor() != this.current_floor) continue;
                    System.out.println("NPC OKE" + i);
                    p.save(w);
                }
                System.out.println("PC OKE");
                this.pcOke.reborn(0);
                this.pcOke.save(w);
                w.close();
                System.out.println("done");
            }
            catch (Exception e) {
                ofile.delete();
                System.out.println("fail to generate bone");
            }
        }
    }

    static {
        Width = 400;
        Height = 400;
    }
}

