/*
 * Decompiled with CFR 0.152.
 */
package CarnageHack;

import CarnageHack.CHutil;
import CarnageHack.CarnageHack;
import CarnageHack.FloorTile;
import CarnageHack.Oke;
import CarnageHack.OkeDungeon;
import CarnageHack.OkeHardWeapon;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.Toolkit;

public class OkeBullette {
    static Image assault;
    static Image laser;
    static Image shotgun;
    static Image missile;
    static Image rocket;
    int floor;
    int x;
    int y;
    int damage;
    int rate;
    int speed;
    int speed_count;
    int type;
    int max_range;
    boolean homing;
    Oke target;
    Oke owner;
    int direction;
    long deltax;
    long deltay;
    long subx;
    long suby;

    static void init(Object obj, MediaTracker mt) {
        Toolkit tk = Toolkit.getDefaultToolkit();
        assault = tk.getImage(obj.getClass().getResource("tile/assault.png"));
        mt.addImage(assault, 0);
        laser = tk.getImage(obj.getClass().getResource("tile/laser.png"));
        mt.addImage(laser, 0);
        shotgun = tk.getImage(obj.getClass().getResource("tile/shotgun.png"));
        mt.addImage(shotgun, 0);
        missile = tk.getImage(obj.getClass().getResource("tile/missile.png"));
        mt.addImage(missile, 0);
        rocket = tk.getImage(obj.getClass().getResource("tile/rocket.png"));
        mt.addImage(rocket, 0);
    }

    OkeBullette(Oke oke, OkeHardWeapon weapon, Oke t) {
        this.x = oke.get_x();
        this.y = oke.get_y();
        this.floor = oke.get_floor();
        this.rate = weapon.get_base_rate();
        this.damage = weapon.get_damage();
        this.max_range = weapon.get_max_range();
        this.speed = weapon.get_speed();
        this.speed_count = 0;
        this.type = weapon.get_type();
        if (weapon.get_type() == 10) {
            this.homing = true;
            this.target = t;
        } else {
            this.homing = false;
        }
        this.direction = CHutil.atan2(t.get_x() - this.x, -(t.get_y() - this.y));
        this.deltax = CHutil.sin(this.direction);
        this.deltay = -CHutil.cos(this.direction);
        this.subx = 0L;
        this.suby = 0L;
        this.owner = oke;
    }

    public int get_max_range() {
        return this.max_range;
    }

    public void set_max_range(int n) {
        this.max_range = n;
    }

    public int get_x() {
        return this.x;
    }

    public int get_y() {
        return this.y;
    }

    public int get_floor() {
        return this.floor;
    }

    public void move(OkeDungeon dungeon) {
        int n;
        boolean ismove = false;
        if (this.max_range == 0) {
            return;
        }
        if (this.homing) {
            boolean jammer = false;
            if (this.type == 10 && this.target.get_hardware().get_option().get_type() == 2 && this.target.get_status() == 1 && CarnageHack.dice100() < this.target.get_hardware().get_option().get_effect()) {
                jammer = true;
            }
            if (this.target.get_hp() > 0 && this.target.get_floor() == this.floor) {
                int new_dir;
                if (!jammer && CHutil.calc_deg_delta(new_dir = CHutil.atan2(this.target.get_x() - this.x, -(this.target.get_y() - this.y)), this.direction) < 90) {
                    this.direction = new_dir;
                    this.deltax = CHutil.sin(this.direction);
                    this.deltay = -CHutil.cos(this.direction);
                }
            } else {
                this.homing = false;
            }
        }
        if (this.speed > 10) {
            n = this.speed - 10;
        } else if (this.speed_count >= this.speed) {
            this.speed_count = 0;
            n = 1;
        } else {
            ++this.speed_count;
            n = 0;
        }
        for (int i = 0; i < n; ++i) {
            OkeBullette b;
            this.subx += this.deltax;
            this.suby += this.deltay;
            if (this.subx >= 10000L) {
                this.subx -= 10000L;
                ++this.x;
                ismove = true;
            } else if (this.subx <= -10000L) {
                this.subx += 10000L;
                --this.x;
                ismove = true;
            }
            if (this.suby >= 10000L) {
                this.suby -= 10000L;
                ++this.y;
                ismove = true;
            } else if (this.suby <= -10000L) {
                this.suby += 10000L;
                --this.y;
                ismove = true;
            }
            if (!ismove) continue;
            if (dungeon.collision_wall(this.x, this.y, this.floor)) {
                this.max_range = 0;
                return;
            }
            Oke p = dungeon.collision_oke(this.x, this.y, this.floor);
            if (p != null) {
                if (CarnageHack.dice100() < this.rate) {
                    p.dec_hp(this.damage, this.owner, this.type);
                    p.add_tempture(this.damage / 10);
                    this.max_range = 0;
                    return;
                }
            } else if (this.type != 2 && (b = dungeon.collision_bullette(this, this.x, this.y, this.floor)) != null && (b.type != 2 || b.type != 1) && CarnageHack.dice100() < this.rate) {
                this.max_range = 0;
                b.set_max_range(0);
                return;
            }
            --this.max_range;
            if (this.max_range == 0) break;
            ismove = false;
        }
    }

    public boolean collision(int tx, int ty, int tfloor) {
        return this.floor == tfloor && this.x == tx && this.y == ty;
    }

    public int get_direction() {
        return this.direction;
    }

    public void draw(Graphics g, Component compo, int bx, int by) {
        Image icon;
        switch (this.type) {
            case 0: {
                icon = assault;
                break;
            }
            case 1: {
                icon = laser;
                break;
            }
            case 2: {
                icon = shotgun;
                break;
            }
            case 10: {
                icon = missile;
                break;
            }
            case 11: {
                icon = rocket;
                break;
            }
            default: {
                icon = null;
            }
        }
        if (icon != null) {
            g.drawImage(icon, (this.x - bx) * FloorTile.tileBaseX, (this.y - by) * FloorTile.tileBaseY, FloorTile.tileBaseX, FloorTile.tileBaseY, compo);
        }
    }
}

