/*
 * Decompiled with CFR 0.152.
 */
package CarnageHack;

import CarnageHack.CHArrayList;
import CarnageHack.CHutil;
import CarnageHack.CarnageHack;
import CarnageHack.FloorPoint;
import CarnageHack.FloorTile;
import java.awt.Component;
import java.awt.Graphics;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.PrintWriter;

public class DungeonFloor {
    public static final int FLOOR_X = 50;
    public static final int FLOOR_Y = 50;
    static FloorTile wall = new FloorTile(1);
    public CHArrayList wall_list;
    public CHArrayList item_list;
    FloorPoint upstairs;
    FloorPoint downstairs;
    FloorTile[][] tile;

    DungeonFloor(int n) {
        this.init(n);
    }

    DungeonFloor(BufferedReader r, int nfloor) {
        int i;
        this.wall_list = new CHArrayList();
        this.item_list = new CHArrayList();
        this.tile = new FloorTile[50][50];
        for (i = 0; i < 50; ++i) {
            for (int j = 0; j < 50; ++j) {
                this.tile[i][j] = new FloorTile();
            }
        }
        try {
            String wk = r.readLine();
            String[] field = CHutil.split(wk, ',');
            this.upstairs = new FloorPoint(Integer.parseInt(field[0]), Integer.parseInt(field[1]));
            wk = r.readLine();
            field = CHutil.split(wk, ',');
            this.downstairs = new FloorPoint(Integer.parseInt(field[0]), Integer.parseInt(field[1]));
            wk = r.readLine();
            field = CHutil.split(wk, ',');
            int n1 = Integer.parseInt(field[0]);
            int n2 = Integer.parseInt(field[1]);
            for (i = 0; i < n1; ++i) {
                wk = r.readLine();
                field = CHutil.split(wk, ',');
                this.wall_list.add(new FloorPoint(Integer.parseInt(field[0]), Integer.parseInt(field[1])));
            }
            for (i = 0; i < n2; ++i) {
                wk = r.readLine();
                field = CHutil.split(wk, ',');
                this.item_list.add(new FloorPoint(Integer.parseInt(field[0]), Integer.parseInt(field[1])));
            }
            while (!(wk = r.readLine()).equals("=END=")) {
                field = CHutil.split(wk, ',');
                n1 = Integer.parseInt(field[0]);
                n2 = Integer.parseInt(field[1]);
                this.tile[n1][n2].set_id(Integer.parseInt(field[2]));
                CHArrayList item = this.tile[n1][n2].get_item();
                int nmax = Integer.parseInt(field[3]);
                for (i = 0; i < nmax; ++i) {
                    wk = r.readLine();
                    item.add(wk);
                }
            }
        }
        catch (IOException e) {
            this.init(nfloor);
        }
        catch (NumberFormatException e) {
            this.init(nfloor);
        }
    }

    private void init(int n) {
        int i;
        System.out.println("make Floor B" + (n + 1) + "F");
        this.wall_list = new CHArrayList();
        this.item_list = new CHArrayList();
        this.tile = new FloorTile[50][50];
        for (i = 0; i < 50; ++i) {
            for (int j = 0; j < 50; ++j) {
                this.tile[i][j] = new FloorTile();
            }
        }
        this.tile[0][0].set_id(1);
        this.wall_list.add(new FloorPoint(0, 0));
        this.tile[49][0].set_id(1);
        this.wall_list.add(new FloorPoint(49, 0));
        this.tile[0][49].set_id(1);
        this.wall_list.add(new FloorPoint(0, 49));
        this.tile[49][49].set_id(1);
        this.wall_list.add(new FloorPoint(49, 49));
        for (i = 1; i < 49; ++i) {
            this.tile[i][0].set_id(1);
            this.wall_list.add(new FloorPoint(i, 0));
            this.tile[i][49].set_id(1);
            this.wall_list.add(new FloorPoint(i, 49));
        }
        for (i = 1; i < 49; ++i) {
            this.tile[0][i].set_id(1);
            this.wall_list.add(new FloorPoint(0, i));
            this.tile[49][i].set_id(1);
            this.wall_list.add(new FloorPoint(49, i));
        }
        this.plot_wall();
        this.upstairs = this.plot_stairs(2);
        this.downstairs = this.plot_stairs(3);
        this.plot_parts(n);
    }

    public boolean save(PrintWriter w) {
        boolean ret;
        try {
            FloorPoint fp;
            int i;
            String wk = this.upstairs.x + "," + this.upstairs.y;
            w.println(wk);
            wk = this.downstairs.x + "," + this.downstairs.y;
            w.println(wk);
            wk = this.wall_list.size() + "," + this.item_list.size();
            w.println(wk);
            for (i = 0; i < this.wall_list.size(); ++i) {
                fp = (FloorPoint)this.wall_list.get(i);
                wk = fp.x + "," + fp.y;
                w.println(wk);
            }
            for (i = 0; i < this.item_list.size(); ++i) {
                fp = (FloorPoint)this.item_list.get(i);
                wk = fp.x + "," + fp.y;
                w.println(wk);
            }
            for (i = 0; i < 50; ++i) {
                for (int j = 0; j < 50; ++j) {
                    CHArrayList item = this.tile[i][j].get_item();
                    wk = i + "," + j + "," + this.tile[i][j].get_id() + "," + item.size();
                    w.println(wk);
                    for (int k = 0; k < item.size(); ++k) {
                        wk = (String)item.get(k);
                        w.println(wk);
                    }
                }
            }
            w.println("=END=");
            ret = true;
        }
        catch (Exception e) {
            System.out.println("fail save map.");
            ret = false;
        }
        return ret;
    }

    public void clear_downstairs() {
        this.tile[this.downstairs.x][this.downstairs.y].set_id(0);
        this.downstairs.x = -1;
        this.downstairs.y = -1;
    }

    void plot_wall() {
        int n = (int)Math.floor(Math.random() * 10.0) * 10;
        if (n > 0) {
            for (int i = 0; i < n; ++i) {
                int y;
                int x;
                while (this.tile[x = (int)(Math.random() * 50.0)][y = (int)(Math.random() * 50.0)].get_id() != 0) {
                }
                this.tile[x][y].set_id(1);
                this.wall_list.add(new FloorPoint(x, y));
            }
        }
    }

    FloorPoint plot_stairs(int n) {
        int y;
        int x;
        while (this.tile[x = (int)Math.floor(Math.random() * 48.0) + 1][y = (int)Math.floor(Math.random() * 48.0) + 1].get_id() != 0) {
        }
        this.tile[x][y].set_id(n);
        return new FloorPoint(x, y);
    }

    void plot_parts(int n) {
        int nmax = (int)Math.floor(Math.random() * (double)(n / 5 + 1) * 2.0) + 1;
        for (int i = 0; i < nmax; ++i) {
            int y;
            int x;
            while (this.tile[x = (int)Math.floor(Math.random() * 48.0) + 1][y = (int)Math.floor(Math.random() * 48.0) + 1].get_item().size() > 0) {
            }
            this.plot_parts_one(x, y, n);
        }
    }

    void plot_parts_one(int x, int y, int nfloor) {
        int nmax = CarnageHack.dice100() > 70 ? (int)Math.floor(Math.random() * 5.0) + 1 : 1;
        for (int i = 0; i < nmax; ++i) {
            String[] field = CHutil.split(CarnageHack.generate_parts(), ':', 3);
            this.additem(x, y, field[0], field[1], Integer.parseInt(field[2], 10));
        }
        int rsupply = nfloor > 10 ? 50 : 100 - (nfloor - 1) * 5;
        if (CarnageHack.dice100() >= rsupply) {
            this.additem(x, y, "+", "", 1);
        }
    }

    public boolean iswall(int x, int y) {
        if (x >= 0 && x < 50 && y >= 0 && y < 50) {
            return this.tile[x][y].get_id() == 1;
        }
        return false;
    }

    public int get_up_stairsx() {
        return this.upstairs.x;
    }

    public int get_up_stairsy() {
        return this.upstairs.y;
    }

    public int get_down_stairsx() {
        return this.downstairs.x;
    }

    public int get_down_stairsy() {
        return this.downstairs.y;
    }

    public boolean isitem(int x, int y) {
        if (x >= 0 && x < 50 && y >= 0 && y < 50) {
            return this.tile[x][y].get_item().size() > 0;
        }
        return false;
    }

    public void additem(int x, int y, String t, String s, int n) {
        if (!CarnageHack.isdefaultparts(t, s) && x >= 0 && x < 50 && y >= 0 && y < 50) {
            CHArrayList item = this.tile[x][y].get_item();
            int nmax = item.size();
            for (int i = 0; i < nmax; ++i) {
                String wk = (String)item.get(i);
                String[] field = CHutil.split(wk, ':', 3);
                if (!field[2].equals(s)) continue;
                int nwk = Integer.parseInt(field[1]);
                item.set(i, field[0] + ":" + (nwk += n) + ":" + field[2]);
                return;
            }
            if (nmax == 0) {
                this.item_list.add(new FloorPoint(x, y));
            }
            item.add(t + ":" + n + ":" + s);
        }
    }

    public CHArrayList delitem(int x, int y) {
        if (x >= 0 && x < 50 && y >= 0 && y < 50) {
            CHArrayList item = this.tile[x][y].get_item();
            CHArrayList ret = new CHArrayList(item);
            item.clear();
            int nmax = this.item_list.size();
            for (int i = 0; i < nmax; ++i) {
                FloorPoint fp = (FloorPoint)this.item_list.get(i);
                if (fp.x != x || fp.y != y) continue;
                this.item_list.remove(i);
                break;
            }
            return ret;
        }
        return null;
    }

    public void draw_floor(Graphics g, Component compo, int bx, int by, int cx, int cy) {
        for (int x = 0; x < cx; ++x) {
            for (int y = 0; y < cy; ++y) {
                if (x + bx > 0 && x + bx < 50 && y + by > 0 && y + by < 50) {
                    this.tile[x + bx][y + by].draw(g, x * FloorTile.tileBaseX, y * FloorTile.tileBaseY, compo);
                    continue;
                }
                wall.draw(g, x * FloorTile.tileBaseX, y * FloorTile.tileBaseY, compo);
            }
        }
    }
}

