/*
 * Decompiled with CFR 0.152.
 */
package CarnageHack;

import CarnageHack.CHutil;
import CarnageHack.FloorTile;
import CarnageHack.OkeBullette;
import CarnageHack.OkeDungeon;
import CarnageHack.OkeSoftChipPanel;
import CarnageHack.OkeSoftPanel;
import java.awt.Canvas;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.Toolkit;

class CHviewSplash
extends Canvas {
    Image banner;
    private static final long serialVersionUID = 99L;

    CHviewSplash() {
        MediaTracker mt = new MediaTracker(this);
        Toolkit tk = Toolkit.getDefaultToolkit();
        this.banner = tk.getImage(this.getClass().getResource("icon/banner.png"));
        mt.addImage(this.banner, 0);
        CHutil.init(this, mt);
        FloorTile.init(this, mt);
        OkeBullette.init(this, mt);
        OkeDungeon.init(this, mt);
        OkeSoftChipPanel.init(this, mt);
        OkeSoftPanel.init(this, mt);
        try {
            mt.waitForAll();
        }
        catch (Exception e) {
            System.out.println("Intterupted while loading image.");
        }
        this.setSize(256, 256);
    }

    @Override
    public void update(Graphics g) {
        this.paint(g);
    }

    @Override
    public void paint(Graphics g) {
        int y = 0;
        int n = FloorTile.startup_image(g, 0, y, 256, this);
        int cx = 256 / FloorTile.tileBaseX;
        y += (n / cx + 1) * FloorTile.tileBaseY;
        n = OkeDungeon.startup_image(g, 0, y, 256, this);
        y += (n / cx + 1) * FloorTile.tileBaseY;
        n = OkeSoftChipPanel.startup_image(g, 0, y, 256, this);
        g.drawImage(this.banner, 0, y += (n / 8 + 1) * 32, this);
    }
}

