/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.interceptor.reader;

import com.google.common.collect.ImmutableSet;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jboss.weld.interceptor.reader.AbstractInterceptorMetadata;
import org.jboss.weld.interceptor.spi.model.InterceptionType;

public class TargetClassInterceptorMetadata
extends AbstractInterceptorMetadata {
    public static final TargetClassInterceptorMetadata EMPTY_INSTANCE = new TargetClassInterceptorMetadata(Collections.<InterceptionType, List<Method>>emptyMap());
    private final Set<Method> interceptorMethods;

    public static TargetClassInterceptorMetadata of(Map<InterceptionType, List<Method>> interceptorMethodMap) {
        if (interceptorMethodMap.isEmpty()) {
            return EMPTY_INSTANCE;
        }
        return new TargetClassInterceptorMetadata(interceptorMethodMap);
    }

    private TargetClassInterceptorMetadata(Map<InterceptionType, List<Method>> interceptorMethodMap) {
        super(interceptorMethodMap);
        this.interceptorMethods = this.initInterceptorMethods(interceptorMethodMap);
    }

    private Set<Method> initInterceptorMethods(Map<InterceptionType, List<Method>> interceptorMethodMap) {
        ImmutableSet.Builder builder = ImmutableSet.builder();
        for (List<Method> methodList : interceptorMethodMap.values()) {
            builder.addAll(methodList);
        }
        return builder.build();
    }

    @Override
    protected boolean isTargetClassInterceptor() {
        return true;
    }

    public boolean isInterceptorMethod(Method method) {
        return this.interceptorMethods.contains(method);
    }
}

