// Worker thread
// Command処理を実行する
// ・Queuing command.
// ・To process the command sequentially.
// ・And stack to undo list.

//  cmdAddress宛先に対応するcmd送信処理関数
//												  DispObj						  GroupObj				 CommandMgr					ObjIDMgr					DispField						Dialog						InputMgr					SaveLoadMgr
const eachDestOfFuncTbl = [cmdSendUiThread, cmdSendUiThread, cmdSendCommandMgr, cmdSendUiThread, cmdSendUiThread, cmdSendUiThread, cmdSendUiThread, cmdSendSaveLoadMgr];

// UI threadにcmd情報を送信
// (InstanceがUI threadにあるobjに対して使用する)
function cmdSendUiThread(cmdObj) {
	// 宛先の実体がUI thread側にあるものは、一律postMessageでcommandを送り付ける
	self.postToUI.post(cmdObj);
};
function cmdSendCommandMgr(cmdObj) {
};
function cmdSendSaveLoadMgr(cmdObj) {
};



// commandごとに undo commandの作成処理関数を登録
const cmdUndoFunc = [];
cmdUndoFunc[cmdCmd.createTextbox] = undoCreateTextbox;
cmdUndoFunc[cmdCmd.createImagebox] = undoCreateImagebox; 
cmdUndoFunc[cmdCmd.movebox] = undoMovebox;
cmdUndoFunc[cmdCmd.scalebox] = undoScalebox;
cmdUndoFunc[cmdCmd.rollbox] = undoRollbox;
cmdUndoFunc[cmdCmd.deletebox] = undoDeletebox; 


// Undoコマンド作成関数
function undoCreateTextbox(cmd) {
	debuglog("undoCreateTextbox");
	var undoCmd = new CCommandObj();
	undoCmd.createCommand(cmdType.request, cmd.from, cmd.to, cmdCmd.deletebox, cmd.param1, cmd.param2, cmd.msgID);
	return undoCmd;
};
function undoCreateImagebox(cmd) {
};
function undoMovebox(cmd) {
	debuglog("undoMovebox");
	var undoCmd = new CCommandObj();
	// dummy
	undoCmd.createCommand(cmdType.request, cmd.from, cmd.to, cmdCmd.deletebox, cmd.param1, cmd.param2, cmd.msgID);
	return undoCmd;
};
function undoScalebox(cmd) {
	debuglog("undoScalebox");
	var undoCmd = new CCommandObj();
	// dummy
	undoCmd.createCommand(cmdType.request, cmd.from, cmd.to, cmdCmd.deletebox, cmd.param1, cmd.param2, cmd.msgID);
	return undoCmd;
};
function undoRollbox(cmd) {
	debuglog("undoRollbox");
	var undoCmd = new CCommandObj();
	// dummy
	undoCmd.createCommand(cmdType.request, cmd.from, cmd.to, cmdCmd.deletebox, cmd.param1, cmd.param2, cmd.msgID);
	return undoCmd;
};
function undoDeletebox(cmd) {
};





class CCommandMgr {
	constructor(){
		this.cmdProcessTbl = {};
		this.cmdQue = new Queue();
		this.undoQue = new Queue();
	}

	debuglog (str) {
		debuglog("【CommandMgr】 " + str);
	}


	// コマンド要求してもらうためのI/F関数
	requestCommand (cmdObj) {
		this.debuglog( "requestCommand()" );

		// 処理予約queueにコマンド インスタンスを登録
		this.cmdQue.enqueue( cmdObj );

		return true;
	}

	// cmdQueにある Commandを処理
	processCommands () {
		// Queに cmdが溜まっている場合はここで処理
		// その間 UI threadから要求があった場合は threadの Msg queに溜まる
		// (Receiveできないため)
		while( 0 < this.cmdQue.size() ){
			this.processSingleCommand();
		}
	}
	// cmdQueに積まれた commandを1回処理
	// (worker thread の onmessage event handlerから呼び出される)
	processSingleCommand () {
		if( this.cmdQue.size() < 1 ){
			this.debugLog("processCommand() cmdQue is empty!");
			return;
		}

		let cmdObj = null;
		cmdObj = this.cmdQue.dequeue();
		this.debuglog( "processCommand() dequeue." );

		// cmd内部処理実行
		this.cmdProcess( cmdObj );

		// 応答cmd作成
		this.cmdCreateResponse( cmdObj );
		
		// Undo情報作成
		this.createUndoInfo( cmdObj );
		
		// cmdの宛先によりcmd送信処理分け
		eachDestOfFuncTbl[ cmdObj.to ]( cmdObj );
	}


	// 以降、private method -----------------
	cmdProcess ( cmd ) {
		// 必要ならここでcmdごとに必要な計算を行う
	}

	cmdCreateResponse ( cmd ) {
		cmd.type = cmdType.result;
	}

	// 処理するcmdから逆操作情報を作成し、Undo queに積む
	createUndoInfo ( cmd ) {
		this.debuglog("createUndoInfo");
		var undoCmd = cmdUndoFunc[ cmd.cmd ]( cmd );
		this.undoQue.enqueue( undoCmd );
	}
} // class CCommandMgr
