(*
Open Source Lazarus/Free Pascal code (GNU GPL v3)

This program is for converting files in the Unbound Bible format
(www.unboundbible.org) into a format that can be readed by the
program Manuscript4u (and may be others).

It removes the tabulation marks, the number of the verse and double
spaces that some files have between the label of the verse and the
beginning of the text. It also adds a space at the end of the verse.
The labels are formated so it has a fixed length, like this:

01O 001:001 text text text.  (01 is Genesis and "O" stands for Old Testament)
01O 001:002 text text text.
01O 001:003 text text text.
01O 001:004 text text text.
...
19O 119:103 text text text text (19 is Psalms)


Copyright (C) 2011 Maxwell Granatto Borges
You can write to me at mgborges10@yahoo.com and if you add anything to this
software, please let me know! Search on the internet for Manuscript4u, maybe
there is a newer version avaiable.

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.

--------------------------------------------------------------------------------

Em português:
 Ausência de garantias

  1. UMA VEZ QUE O PROGRAMA É LICENCIADO SEM ÔNUS, NÃO HÁ QUALQUER GARANTIA
  PARA O PROGRAMA, NA EXTENSÃO PERMITIDA PELAS LEIS APLICÁVEIS. EXCETO QUANDO
  EXPRESSADO DE FORMA ESCRITA, OS DETENTORES DOS DIREITOS AUTORAIS E/OU
  TERCEIROS DISPONIBILIZAM O PROGRAMA "NO ESTADO", SEM QUALQUER TIPO DE
  GARANTIAS, EXPRESSAS OU IMPLÍCITAS, INCLUINDO, MAS NÃO LIMITADO A,
  AS GARANTIAS IMPLÍCITAS DE COMERCIALIZAÇÃO E AS DE ADEQUAÇÃO A QUALQUER
  PROPÓSITO. O RISCO TOTAL COM A QUALIDADE E DESEMPENHO DO PROGRAMA É SEU.
  SE O PROGRAMA SE MOSTRAR DEFEITUOSO, VOCÊ ASSUME OS CUSTOS DE TODAS AS
  MANUTENÇÕES, REPAROS E CORREÇÕES.

  2. EM NENHUMA OCASIÃO, A MENOS QUE EXIGIDO PELAS LEIS APLICÁVEIS OU ACORDO
  ESCRITO, OS DETENTORES DOS DIREITOS AUTORAIS,  OU QUALQUER OUTRA PARTE QUE
  POSSA MODIFICAR E/OU REDISTRIBUIR O PROGRAMA CONFORME PERMITIDO ACIMA,
  SERÃO RESPONSABILIZADOS POR VOCÊ POR DANOS, INCLUINDO QUALQUER DANO EM GERAL,
  ESPECIAL, ACIDENTAL OU CONSEQÜENTE, RESULTANTES DO USO OU INCAPACIDADE DE
  USO DO PROGRAMA (INCLUINDO, MAS NÃO LIMITADO A, A PERDA DE DADOS OU DADOS
  TORNADOS INCORRETOS, OU PERDAS SOFRIDAS POR VOCÊ OU POR OUTRAS PARTES,
  OU FALHAS DO PROGRAMA AO OPERAR COM QUALQUER OUTRO PROGRAMA), MESMO QUE TAL
  DETENTOR OU PARTE TENHAM SIDO AVISADOS DA POSSIBILIDADE DE TAIS DANOS.
*)
unit convertu1;

{$mode objfpc}{$H+}

interface

uses
  Classes, SysUtils, FileUtil, LResources, Forms, Controls, Graphics, Dialogs,
  StdCtrls, Grids, ComCtrls, ClipBrd, SynEdit;

const StProgName = 'convert 1.0 - to convert UnboundBible format to manuscript4u format';

type
  str3 = string[3];
  str11 = string[11];
  { Tconvertf1 }

  Tconvertf1 = class(TForm)
    CheckBox1: TCheckBox;
    Memo1: TMemo;
    Memo2: TMemo;
    Memo3: TMemo;
    OpenDialog1: TOpenDialog;
    SaveDialog1: TSaveDialog;
    StatusBar1: TStatusBar;
    ToolBar1: TToolBar;
    ToolButton1: TToolButton;
    ToolButton3: TToolButton;
    ToolButton5: TToolButton;
    ToolButton6: TToolButton;
    procedure FormClose(Sender: TObject; var CloseAction: TCloseAction);
    procedure FormCreate(Sender: TObject);
    procedure FormResize(Sender: TObject);
    procedure Memo1KeyUp(Sender: TObject; var Key: Word; Shift: TShiftState);
    procedure Memo2Change(Sender: TObject);
    procedure Memo2KeyUp(Sender: TObject; var Key: Word; Shift: TShiftState);
    procedure Memo3Change(Sender: TObject);
    procedure ToolButton1Click(Sender: TObject);
 //   procedure ToolButton2Click(Sender: TObject);
    procedure ToolButton3Click(Sender: TObject);
//    procedure ToolButton4Click(Sender: TObject);
    procedure ToolButton5Click(Sender: TObject);
    procedure ToolButton6Click(Sender: TObject);
  private
    { private declarations }
  public
    { public declarations }
   procedure Help;
   procedure Memo2ToMemo1;
   procedure Memo1ToMemo2;
   procedure Memo1ToLineList1;

   procedure LineList1ToLineList2;
   procedure LineList2ToLineList1;

   procedure StripSpaces;
   procedure StripNumbers;
   procedure ReplaceTab4Space;{replace Tab por um espaço}
   procedure ReadArq(StArqEnt:string; listno:byte);
  end; 

var
  convertf1: Tconvertf1;
  linelist1, LineList2 : TStringList;

implementation

{ Tconvertf1 }

procedure Tconvertf1.ToolButton1Click(Sender: TObject); {Convert}
var i,k,cab:Cardinal;
    stName:str3;
    sstAux:ShortString;
    strAux,strAuxLine:string;

//01O = zero + um + letra "o" maiúscula (não é zero)

// '42N','43N','44N','45N','46N','47N','48N','49N','50N','51N','52N','53N','54N','55N','56N','57N','58N','59N','60N','61N','62N','63N','64N','65N','66N');
//  40N,41M,42N,43N,44N,45N,46N,47N,48N,49N,50N,51N,52N,53N,54N,55N,56N,57N,58N,59N,60N,61N,62N,63N,64N,65N,66N
//  Mat,Mar,Lou,Iwa,Pra,Rwm,1Ko,2Ko,Gal,Efe,Flp,Kol,1Qe,2Qe,1Tm,2Tm,Tit,Flm,Heb,Iak,1Pe,2Pe,1Jw,2Jw,3Jw,Iou,Apo

function BookCod(stData:str3):str3;
begin
 if stData = '01O' then result := 'Gen' else
 if stData = '02O' then result := 'Exo' else
 if stData = '03O' then result := 'Lev' else
 if stData = '04O' then result := 'Num' else
 if stData = '05O' then result := 'Deu' else
 if stData = '06O' then result := 'Jos' else
 if stData = '07O' then result := 'Jdg' else
 if stData = '08O' then result := 'Rut' else
 if stData = '09O' then result := '1Sa' else
 if stData = '10O' then result := '2Sa' else
 if stData = '11O' then result := '1Ki' else
 if stData = '12O' then result := '2Ki' else
 if stData = '13O' then result := '1Ch' else
 if stData = '14O' then result := '2Ch' else
 if stData = '15O' then result := 'Esd' else
 if stData = '16O' then result := 'Neh' else
 if stData = '17O' then result := 'Est' else
 if stData = '18O' then result := 'Job' else
 if stData = '19O' then result := 'Psa' else
 if stData = '20O' then result := 'Pro' else
 if stData = '21O' then result := 'Ecc' else
 if stData = '22O' then result := 'Son' else
 if stData = '23O' then result := 'Isa' else
 if stData = '24O' then result := 'Jer' else
 if stData = '25O' then result := 'Lam' else
 if stData = '26O' then result := 'Eze' else
 if stData = '27O' then result := 'Dan' else
 if stData = '28O' then result := 'Ose' else
 if stData = '29O' then result := 'Joe' else
 if stData = '30O' then result := 'Amo' else
 if stData = '31O' then result := 'Obd' else
 if stData = '32O' then result := 'Jon' else
 if stData = '33O' then result := 'Mic' else
 if stData = '34O' then result := 'Nah' else
 if stData = '35O' then result := 'Hab' else
 if stData = '36O' then result := 'Zep' else
 if stData = '37O' then result := 'Hag' else
 if stData = '38O' then result := 'Zac' else
 if stData = '39O' then result := 'Mal' else


 if stData = '40N' then result := 'Mat' else
 if stData = '41N' then result := 'Mar' else
 if stData = '42N' then result := 'Luk' else
 if stData = '43N' then result := 'Jhn' else
 if stData = '44N' then result := 'Act' else
 if stData = '45N' then result := 'Rom' else
 if stData = '46N' then result := '1Co' else
 if stData = '47N' then result := '2Co' else
 if stData = '48N' then result := 'Gal' else
 if stData = '49N' then result := 'Eph' else
 if stData = '50N' then result := 'Php' else
 if stData = '51N' then result := 'Col' else
 if stData = '52N' then result := '1Te' else
 if stData = '53N' then result := '2Te' else
 if stData = '54N' then result := '1Tm' else
 if stData = '55N' then result := '2Tm' else
 if stData = '56N' then result := 'Tit' else
 if stData = '57N' then result := 'Phm' else
 if stData = '58N' then result := 'Heb' else
 if stData = '59N' then result := 'Jam' else
 if stData = '60N' then result := '1Pe' else
 if stData = '61N' then result := '2Pe' else
 if stData = '62N' then result := '1Jo' else
 if stData = '63N' then result := '2Jo' else
 if stData = '64N' then result := '3Jo' else
 if stData = '65N' then result := 'Jud' else
 if stData = '66N' then result := 'Rev' else

{I'm not sure about the correctness of the following}
 if stData = '67A' then result := 'Tob' else
 if stData = '68A' then result := 'Jdt' else
 if stData = '69A' then result := 'Esg' else
 if stData = '70A' then result := 'Wos' else
 if stData = '71A' then result := 'Ecu' else
 if stData = '72A' then result := 'Brc' else
 if stData = '73A' then result := 'Eje' else
 if stData = '74A' then result := 'Aza' else
 if stData = '75A' then result := 'Sus' else
 if stData = '76A' then result := 'Bel' else
 if stData = '77A' then result := '1Ma' else
 if stData = '78A' then result := '2Ma' else
 if stData = '79A' then result := '3Ma' else
 if stData = '80A' then result := '4Ma' else
 if stData = '81N' then result := '1Es' else
 if stData = '82N' then result := '2Es' else
 if stData = '83N' then result := 'Man' else
 if stData = '84N' then result := '151' else
 if stData = '85N' then result := 'Pss' else
 if stData = '86N' then result := 'Ode';// else result := '';
end;{function}

function IsVerse(strLabel:string):boolean;
begin
  result:=false;
  if Copy(strLabel,1,3) = '01O' then result := true else
  if Copy(strLabel,1,3) = '02O' then result := true else
  if Copy(strLabel,1,3) = '03O' then result := true else
  if Copy(strLabel,1,3) = '04O' then result := true else
  if Copy(strLabel,1,3) = '05O' then result := true else
  if Copy(strLabel,1,3) = '06O' then result := true else
  if Copy(strLabel,1,3) = '07O' then result := true else
  if Copy(strLabel,1,3) = '08O' then result := true else
  if Copy(strLabel,1,3) = '09O' then result := true else
  if Copy(strLabel,1,3) = '10O' then result := true else
  if Copy(strLabel,1,3) = '11O' then result := true else
  if Copy(strLabel,1,3) = '12O' then result := true else
  if Copy(strLabel,1,3) = '13O' then result := true else
  if Copy(strLabel,1,3) = '14O' then result := true else
  if Copy(strLabel,1,3) = '15O' then result := true else
  if Copy(strLabel,1,3) = '16O' then result := true else
  if Copy(strLabel,1,3) = '17O' then result := true else
  if Copy(strLabel,1,3) = '18O' then result := true else
  if Copy(strLabel,1,3) = '19O' then result := true else
  if Copy(strLabel,1,3) = '20O' then result := true else
  if Copy(strLabel,1,3) = '21O' then result := true else
  if Copy(strLabel,1,3) = '22O' then result := true else
  if Copy(strLabel,1,3) = '23O' then result := true else
  if Copy(strLabel,1,3) = '24O' then result := true else
  if Copy(strLabel,1,3) = '25O' then result := true else
  if Copy(strLabel,1,3) = '26O' then result := true else
  if Copy(strLabel,1,3) = '27O' then result := true else
  if Copy(strLabel,1,3) = '28O' then result := true else
  if Copy(strLabel,1,3) = '29O' then result := true else
  if Copy(strLabel,1,3) = '30O' then result := true else
  if Copy(strLabel,1,3) = '31O' then result := true else
  if Copy(strLabel,1,3) = '32O' then result := true else
  if Copy(strLabel,1,3) = '33O' then result := true else
  if Copy(strLabel,1,3) = '34O' then result := true else
  if Copy(strLabel,1,3) = '35O' then result := true else
  if Copy(strLabel,1,3) = '36O' then result := true else
  if Copy(strLabel,1,3) = '37O' then result := true else
  if Copy(strLabel,1,3) = '38O' then result := true else
  if Copy(strLabel,1,3) = '39O' then result := true else
  if Copy(strLabel,1,3) = '40N' then result := true else
  if Copy(strLabel,1,3) = '41N' then result := true else
  if Copy(strLabel,1,3) = '42N' then result := true else
  if Copy(strLabel,1,3) = '43N' then result := true else
  if Copy(strLabel,1,3) = '44N' then result := true else
  if Copy(strLabel,1,3) = '45N' then result := true else
  if Copy(strLabel,1,3) = '46N' then result := true else
  if Copy(strLabel,1,3) = '47N' then result := true else
  if Copy(strLabel,1,3) = '48N' then result := true else
  if Copy(strLabel,1,3) = '49N' then result := true else
  if Copy(strLabel,1,3) = '50N' then result := true else
  if Copy(strLabel,1,3) = '51N' then result := true else
  if Copy(strLabel,1,3) = '52N' then result := true else
  if Copy(strLabel,1,3) = '53N' then result := true else
  if Copy(strLabel,1,3) = '54N' then result := true else
  if Copy(strLabel,1,3) = '55N' then result := true else
  if Copy(strLabel,1,3) = '56N' then result := true else
  if Copy(strLabel,1,3) = '57N' then result := true else
  if Copy(strLabel,1,3) = '58N' then result := true else
  if Copy(strLabel,1,3) = '59N' then result := true else
  if Copy(strLabel,1,3) = '60N' then result := true else
  if Copy(strLabel,1,3) = '61N' then result := true else
  if Copy(strLabel,1,3) = '62N' then result := true else
  if Copy(strLabel,1,3) = '63N' then result := true else
  if Copy(strLabel,1,3) = '64N' then result := true else
  if Copy(strLabel,1,3) = '65N' then result := true else
  if Copy(strLabel,1,3) = '66N' then result := true else
  if Copy(strLabel,1,3) = '67A' then result := true else
  if Copy(strLabel,1,3) = '68A' then result := true else
  if Copy(strLabel,1,3) = '69A' then result := true else
  if Copy(strLabel,1,3) = '70A' then result := true else
  if Copy(strLabel,1,3) = '71A' then result := true else
  if Copy(strLabel,1,3) = '72A' then result := true else
  if Copy(strLabel,1,3) = '73A' then result := true else
  if Copy(strLabel,1,3) = '74A' then result := true else
  if Copy(strLabel,1,3) = '75A' then result := true else
  if Copy(strLabel,1,3) = '76A' then result := true else
  if Copy(strLabel,1,3) = '77A' then result := true else
  if Copy(strLabel,1,3) = '78A' then result := true else
  if Copy(strLabel,1,3) = '79A' then result := true else
  if Copy(strLabel,1,3) = '80A' then result := true else
  if Copy(strLabel,1,3) = '81A' then result := true else
  if Copy(strLabel,1,3) = '82A' then result := true else
  if Copy(strLabel,1,3) = '83A' then result := true else
  if Copy(strLabel,1,3) = '84A' then result := true else
  if Copy(strLabel,1,3) = '85A' then result := true else
  if Copy(strLabel,1,3) = '86A' then result := true else
  if Copy(strLabel,1,3) = '87A' then result := true else
  if Copy(strLabel,1,3) = '88A' then result := true else
  if Copy(strLabel,1,3) = '89A' then result := true else
  if Copy(strLabel,1,3) = '90A' then result := true else
  if Copy(strLabel,1,3) = '91A' then result := true else
  if Copy(strLabel,1,3) = '92A' then result := true else
  if Copy(strLabel,1,3) = '93A' then result := true else
  if Copy(strLabel,1,3) = '94A' then result := true else
  if Copy(strLabel,1,3) = '95A' then result := true else
  if Copy(strLabel,1,3) = '96A' then result := true else
  if Copy(strLabel,1,3) = '97A' then result := true else
  if Copy(strLabel,1,3) = '98A' then result := true else
  if Copy(strLabel,1,3) = '99A' then result := true;
end;{function IsVerse}

begin
 Memo1ToLineList1;

 ReplaceTab4Space;

 {stores head lines on Memo3}
 Memo3.Lines.Clear;
 cab:=0;
 while not IsVerse(Linelist1[cab])
  and (cab<500)  {cab com no máximo 500 linhas }
   do
   begin
    if Linelist1.Count-1 >= cab then Memo3.Lines.Append(LineList1[cab]);
    cab:=cab+1
   end;
   Memo3.Lines.Append('--------------------------------------------------------');
   if ( (LineList1.Count-1 >= 1) {and ( Length(Memo1.Lines[i])>7) })
    then Memo3.Lines.Append('    000:000 '+Copy(LineList1[1],7,Length(LineList1[1])));

// Memo2.Lines.Clear;
// with LineList1 do

 LineList2.Clear;

 if LineList1.Count-1 >= cab then begin
 for i:=cab to LineList1.Count-1 do begin
  strAuxLine:=LineList1[i];
  if strAuxLine<>'' then begin  {makes error if try this on empty line, besides it is good to eliminate empty lines on this section}
  if strAuxLine[6] = ' ' then {cap é menor que 10}
   strAuxLine:=Copy(LineList1[i],1,4)+'0'+Copy(LineList1[i],5,Length(LineList1[i] ) );
   if strAuxLine[7] = ' ' then          {cap é menor que 100}
    strAuxLine:=Copy(strAuxLine,1,4)+'0'+Copy(strAuxLine,5,Length(strAuxLine) );
   if (strAuxLine[10] = ' ') or (strAuxLine[11] = ' ') then  {ver é menor que 10 e/ou 100 }
    strAuxLine:=Copy(strAuxLine,1,8)+'0'+Copy(strAuxLine,9,2)+Copy(StrAuxLine,11,Length(StrAuxLine) );
  LineList2.Append(strAuxLine);
  end;{if strAuxLine<>''}
 end;{for}

 end {if Memo1}
 else begin
  ShowMessage('Please open a file in the UnboundBible format.');
  Exit; {não é texto Unbound Bible porque deveria ter versiculo depois do cabeçalho, isto é, ter dado isVerse true e o cab seria menor que o texto todo}
 end;

(*
19O 010 1 31231 tttttttt
19O 100 23 23233 tttttt
19O 120 143 32323 ttttttt
*)

 LineList1.Clear;
 with LineList2 do
 for i:=0 to Count-1 do begin
  sstAux:=LineList2[i];
  if sstAux[11] = ' ' then begin {ver é menor que 10}
   LineList1.Append(Copy(LineList2[i],1,8)+'0'+Copy(LineList2[i],9,2)+Copy(LineList2[i],11,Length(LineList2[i])));
  end{if}
  else LineList1.Append(LineList2[i]);
 end;{for}

// Memo1ToMemo2;
// LineList1ToLineList2;

 if (CheckBox1.Checked) then begin
  StripSpaces;  {reads from LineList1 and Appends to LineList2}
  StripNumbers; {reads from LineList2 and Appends to LineList1}
 end;

 {xxxxxxxxxxxxxxxxxxxxxxxx}
 memo2.visible:=false; {só para Windows! torna muito mais rapido}
 {Cabeçalho (Head lines)}
 Memo2.Lines.Clear;
 for i:=0 to Memo3.Lines.Count-1 do Memo2.Lines.Append(Memo3.Lines[i]);

 {Pass LineList1 to Memo2}

 with LineList1 do
 for i:=0 to Count-1 do begin
  if IsVerse(LineList1[i]) then begin
//   if Copy(Lines[i],Length(Lines[i])-1,1) = '.' then Lines[i]:=Copy(Lines[i],1,Length(Lines[i])-1)+' . '
//    else Lines[i] := Lines[i]+' ';
   Memo2.Lines.Append(Copy(LineList1[i],1,7)+':'+Copy(LineList1[i],9,Length(LineList1[i]))+' ');
  end;
 end;{for}
 memo2.visible:=true;  {só para Windows}
(* a última rotina (logo acima) já termina no memo2*)

end;{proc.}

procedure Tconvertf1.Memo1ToMemo2;
 var i:Cardinal;
begin
 Memo2.Lines.Clear; {copia Memo1 para Memo2}
 with Memo1 do
 for i:=0 to Lines.Count-1 do begin
   Memo2.Lines.Append(Lines[i]);
 end;{for}
  Memo1.SelStart:=0;
  Memo2.SelStart:=0;
end;

procedure Tconvertf1.Memo2ToMemo1;
 var i:Cardinal;
begin
 Memo1.Lines.Clear; {copia Memo2 para Memo1}
 with Memo2 do
 for i:=0 to Lines.Count-1 do begin
   Memo1.Lines.Append(Lines[i]);
 end;{for}
  Memo1.SelStart:=0;
  Memo2.SelStart:=0;
end;

procedure Tconvertf1.LineList1ToLineList2;
 var i:Cardinal;
begin
 Memo2.Lines.Clear; {copia Memo1 para Memo2}
 with LineList1 do
 for i:=0 to Count-1 do begin
   Memo2.Lines.Append(LineList1[i]);
 end;{for}
//  Memo1.SelStart:=0;
//  Memo2.SelStart:=0;
end;

procedure Tconvertf1.LineList2ToLineList1;
 var i:Cardinal;
begin
 LineList1.Clear; {copia Memo2 para Memo1}
 with Memo2 do
 for i:=0 to Lines.Count-1 do begin
   LineList1.Append(Lines[i]);
 end;{for}
//  Memo1.SelStart:=0;
//  Memo2.SelStart:=0;
end;


procedure Tconvertf1.Memo1ToLineList1;
 var i:Cardinal;
begin
 LineList1.Clear; {copia Memo1 para LineList}
 with Memo1 do
 for i:=0 to Lines.Count-1 do begin
   LineList1.Append(Lines[i]);
 end;{for}
//  Memo1.SelStart:=0;
//  Memo2.SelStart:=0;
end;

procedure Tconvertf1.StripSpaces; {Porque a algumas Unbound Bibles tem com dois espaços entre o rotulo e o começo do texto}
var i:Cardinal;       {reads from LineList1 and Appends to LineList2}
    sstAux:ShortString;
begin
 LineList2.Clear;
 with LineList1 do
 for i:=0 to Count-1 do begin
  sstAux:=Copy(LineList1[i],13,1);
  if sstAux = ' ' then begin
   LineList2.Append(Copy(LineList1[i],1,11)+Copy(LineList1[i],13,Length(LineList1[i])));
  end{if}
  else LineList2.Append(LineList1[i]);
 end;{for}
// Memo1ToMemo2;
// LineList1ToLineList2;
// Memo1.SelStart:=0;
// Memo2.SelStart:=0;
end;

procedure Tconvertf1.StripNumbers;   {Strip Numbers} {reads from LineList2 and Appends to LineList1}
//type  TAlg = set of '0'..'9';//,'1','2','3','4','5','6','7','8','9';

var sstAux:ShortString;
    i,k:Cardinal;
    IntAux:integer;
    boNum:boolean;
    chrAux:char;
begin
 sstAux:='';
 LineList1.Clear;
 for i:=0 to LineList2.Count-1 do begin
  boNum:=true;
  sstAux:=Copy(LineList2[i],13,50);
  k:=POS(' ',sstAux);
  chrAux:=sstAux[1];
  if (    ( ord(chrAux) < ord('0') ) or ( ord(chrAux) > ord('9') )    ) then boNum := false;
  if boNum then LineList1.Append(  Copy( LineList2[i],1,12) + Copy( LineList2[i],13+k,Length(LineList2[i]) ) )
   else LineList1.Append( LineList2[i] );
 end; {for}
// Memo1toMemo2;
//  LineList1ToLineList2;
// Memo1.SelStart:=0;
// Memo2.SelStart:=0;
 // if not boNum then ShowMessage('At least one verse didn`t had any number to be removed ('+ch0+').');
end;

procedure Tconvertf1.ToolButton5Click(Sender: TObject); {Save as}
var botao:Integer;
begin                   // SaveDialog1.FileName := Copy(Memo2.Lines[1],7,Length(Memo2.Lines[1]))+'.txt';
//  if FileExists(SaveDialog1.FileName) then begin
//   botao:=MessageDlg(SaveDialog1.FileName+#13+'already exists. Overwrite it?',mtCustom,[mbYes,mbNo], 0);
//    if botao=mrYes then Memo2.Lines.SaveToFile(SaveDialog1.FileName) else
     if SaveDialog1.Execute then begin
      Memo2.Lines.SaveToFile(SaveDialog1.FileName);
      StatusBar1.Panels[2].Text:=SaveDialog1.FileName;
      StatusBar1.Panels[3].Text:='Sav';
    end;{SaveDialog1}
//   end;{if botao}
//  end;{if FileExists}
end;

procedure Tconvertf1.ToolButton6Click(Sender: TObject);
begin
//  Application.Terminate;
  Close;
end;

procedure Tconvertf1.Help;
begin
 with Memo1.Lines do
 begin
 Clear;
 Add('');
 Add(' To convert a Bible file as it can be download from,');
 Add('               www.unboundbible.org');
 Add('   to a format that can be readed by the program');
 Add('                   Manuscript4u');
 Add('Procedures:');
 Add('');
 Add(' 1 - Open an Unbound Bible file.');
 Add('');
 Add(' 2 - Click on "Convert" and wait a few seconds.');
 Add('');
 Add(' 3 - "Save as" (it will save the text on the right');
 Add('     side window).');
 Add('');
 Add('-------------------------------------------------------------------------');
 Add('');
 Add(' obs. Some texts have numbers between the label');
 Add(' of the verse and the beginning of the text. e.g.:');
 Add('');
 Add('01O 001:001  10 In the beginning God created the heaven and the earth.');
 Add('');
 Add(' If you don`t want them, check on "Remove extra numbers"');
 Add(' before "Convert"ing. The result will be like that:');
 Add('');
 Add('01O 001:001 In the beginning God created the heaven and the earth.');
 Add('');
 Add(' This is optional, the file will work with or without');
 Add(' these numbers.');
 Add('');
 Add('-------------------------------------------------------------------------');
 Add('');
 Add(' This program is GNU/GPL v.3 (source code in');
 Add(' Lazarus/Free Pascal)');
 Add(' copyright (c) 2011 Maxwell Granatto Borges');
 Add('                     mgborges10@yahoo.com');
 Add('');
 Add(' This program is distributed in the hope that it will be');
 Add(' useful, but WITHOUT ANY WARRANTY; without even the implied');
 Add(' warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR');
 Add(' PURPOSE.  See the GNU General Public License for more');
 Add(' details. ');
 Add('');
 Add('Ex:');
 Add('');
 Add('01O 1 2 23 Open an Unbound Bible file.');
 Add('02O 4 15 36 Click on "Convert" and wait a few seconds.');
 Add('43N 27 8 59 "Save as" (it will save the text on the right side window).');
 end;
end;


procedure Tconvertf1.FormCreate(Sender: TObject);
begin
 Top:=0;
 Left:=0;

 Caption:=StProgName;
 Height:=Screen.Height-100;
 Width:=Screen.Width-40;

 Memo1.Color := clNavy;
 Memo2.Color := clBlack;
 Memo1.Font.Color := clWhite;
 Memo2.Font.Color := clYellow;

// Memo1.ScrollBars:=ssNone;
// Memo2.ScrollBars:=ssNone;

 linelist1 := TStringList.Create;
 linelist2 := TStringList.Create;

 Help;
(*
 with Memo1 do begin
  Width := Trunc((convertf1.Width)/2)-10;
  Height := Trunc(convertf1.Height-60);
  Top := 40;
  Left := 2;
 end;{with Memo1}

 with Memo2 do begin
  Width := Memo1.Width;
  Height := Memo1.Height;
  Top := Memo1.Top;
  Left := Memo1.Width+Memo1.Left;
 end;{with Memo2}
*)
// Memo1.Lines.LoadFromFile('/home/max/lazprogs/pleion/biblia-livre/convert/biblialivre2.txt');

end;

procedure Tconvertf1.FormClose(Sender: TObject; var CloseAction: TCloseAction);
var botao:Integer;      {ON CLOSE do Form}
begin
 if  StatusBar1.Panels[3].Text = 'Mod' then begin
  botao:=MessageDlg('The text on the right side window ('+Copy( Memo2.Lines[1],7,Length(Memo2.Lines[1]))+')'+#13+'is not saved. Do you want to save it ?',mtCustom,[mbYes,mbNo], 0);
  if botao=mrYes then
   if SaveDialog1.Execute then
    Memo2.Lines.SaveToFile(SaveDialog1.FileName);
 end;
 linelist1.free;
 linelist2.free;
 CloseAction:=caFree;
end;

procedure Tconvertf1.FormResize(Sender: TObject);
begin

 //Memo2.Height := Trunc(convertf1.Height-60);

 with Memo1 do begin
  Width := Trunc((convertf1.Width)/2)-4;                    ///  Width := convertf1.Width-10;
  Height := convertf1.Height-60;
  Top := 30;
  Left := 2;
 end;{with Memo1}

 with Memo2 do begin
  Width := Memo1.Width;
  Height := Memo1.Height;
  Top := Memo1.Top;
  Left := Memo1.Width+Memo1.Left+2;
 end;{with Memo2}

 StatusBar1.Panels[0].Width:=100;
 StatusBar1.Panels[3].Width:=30;
 StatusBar1.Panels[4].Width:=100;
 StatusBar1.Panels[1].Width:=Memo1.Width-StatusBar1.Panels[0].Width;
 StatusBar1.Panels[2].Width:=Memo1.Width-StatusBar1.Panels[4].Width-StatusBar1.Panels[3].Width;

  Memo1.SelStart:=0;
  Memo2.SelStart:=0;
(*
 with Memo3 do begin
  Width := Memo1.Width;
  Height := Memo2.Height-Memo1.Height-10;
  Top := Memo1.Top+Memo1.Height+5;
  Left := Memo1.Left;
 end;{with Memo2}
*)
end;

procedure Tconvertf1.Memo1KeyUp(Sender: TObject; var Key: Word; Shift: TShiftState );
begin
 StatusBar1.Panels[0].Text:=IntToStr(Memo1.CaretPos.X+1)+':'+IntToStr(Memo1.CaretPos.Y+1);
end;

procedure Tconvertf1.ToolButton3Click(Sender: TObject);  {Open}
var botao:Integer;      {ON CLOSE do Form}
begin
 if  StatusBar1.Panels[3].Text = 'Mod' then begin
  botao:=MessageDlg('The text on the right side window ('+Copy( Memo2.Lines[1],7,Length(Memo2.Lines[1] ))+')'+#13+'is not saved. Do you want to save it ?',mtCustom,[mbYes,mbNo], 0);
  if botao=mrYes then
   if SaveDialog1.Execute then
    Memo2.Lines.SaveToFile(SaveDialog1.FileName);
 end;
  if OpenDialog1.Execute then begin
   Memo1.Lines.LoadFromFile(OpenDialog1.FileName);

//   ReadArq(OpenDialog1.FileName,1);
//   Memo1ToLineList1;
   StatusBar1.Panels[1].Text:=OpenDialog1.FileName;
//   SaveDialog1.FileName:=OpenDialog1.FileName;
   SaveDialog1.FileName := ExtractFileName(OpenDialog1.FileName)+'ub.txt';
  end;
end;

procedure Tconvertf1.ReplaceTab4Space;{replace Tab por um espaço}
var word2change,wordchanged : string;
    options       : TReplaceFlags;
    i:Cardinal;
begin
 options := [rfReplaceAll, rfIgnoreCase];
 word2change := '	';
 wordchanged := ' ';
 for i:=0 to LineList1.Count-1 do
  LineList1[i] := StringReplace( LineList1[i], word2change, wordchanged, options);
end;

procedure Tconvertf1.Memo2Change(Sender: TObject);
begin
 StatusBar1.Panels[3].Text:='Mod';
end;

procedure Tconvertf1.Memo2KeyUp(Sender: TObject; var Key: Word; Shift: TShiftState
  );
begin
 StatusBar1.Panels[4].Text:=IntToStr(Memo2.CaretPos.X+1)+':'+IntToStr(Memo2.CaretPos.Y+1);
end;

procedure Tconvertf1.Memo3Change(Sender: TObject);
begin

end;


{from concat}
procedure Tconvertf1.ReadArq(StArqEnt:string; listno:byte);
var
  Arq : TextFile;
  Linha : string;
  i       : Integer;
begin
// greek := TStringList.Create;
 if listno=1 then linelist1.clear; {else if listno=2 then linelist2.clear;}
 AssignFile(Arq,StArqEnt);
 {$I-}
  Reset(Arq);
 {$I+}
 if IOresult = 0 then begin
   While (Not EOF (Arq)) do
   try
    begin
     Readln(Arq,Linha);
     linelist1.Add(Linha);
   end;
   except
//    pgdplist.free;
    showmessage('Cant read File.'+#13+StArqEnt);
    closefile(Arq);
    Exit;
   end;
   closefile(Arq);
 end else begin
//    pgdplist.free;
    showmessage('File not found.'+#13+StArqEnt);
    Exit;
 end;

 {dont forget to free list on formclose}
end;

{end from concat}

initialization
  {$I convertu1.lrs}

end.

