/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.collect.testing.google;

import com.google.common.annotations.GwtCompatible;
import com.google.common.collect.Multimap;
import com.google.common.collect.testing.Helpers;
import com.google.common.collect.testing.features.CollectionSize;
import com.google.common.collect.testing.features.MapFeature;
import com.google.common.collect.testing.google.AbstractMultimapTester;
import com.google.common.truth.Truth;
import java.util.Collection;

@GwtCompatible
public class MultimapAsMapGetTester<K, V>
extends AbstractMultimapTester<K, V, Multimap<K, V>> {
    @CollectionSize.Require(value={CollectionSize.SEVERAL})
    @MapFeature.Require(value={MapFeature.SUPPORTS_REMOVE})
    public void testPropagatesRemoveToMultimap() {
        this.resetContainer(Helpers.mapEntry(this.sampleKeys().e0, this.sampleValues().e0), Helpers.mapEntry(this.sampleKeys().e0, this.sampleValues().e3), Helpers.mapEntry(this.sampleKeys().e0, this.sampleValues().e2));
        Collection result = (Collection)this.multimap().asMap().get(this.sampleKeys().e0);
        MultimapAsMapGetTester.assertTrue((boolean)result.remove(this.sampleValues().e0));
        MultimapAsMapGetTester.assertFalse((boolean)this.multimap().containsEntry(this.sampleKeys().e0, this.sampleValues().e0));
        MultimapAsMapGetTester.assertEquals((int)2, (int)this.multimap().size());
    }

    @CollectionSize.Require(absent={CollectionSize.ZERO})
    @MapFeature.Require(value={MapFeature.SUPPORTS_REMOVE})
    public void testPropagatesRemoveLastElementToMultimap() {
        Collection result = (Collection)this.multimap().asMap().get(this.sampleKeys().e0);
        MultimapAsMapGetTester.assertTrue((boolean)result.remove(this.sampleValues().e0));
        this.assertGet(this.sampleKeys().e0, new Object[0]);
    }

    @CollectionSize.Require(absent={CollectionSize.ZERO})
    @MapFeature.Require(value={MapFeature.SUPPORTS_REMOVE})
    public void testPropagatesClearToMultimap() {
        Collection result = (Collection)this.multimap().asMap().get(this.sampleKeys().e0);
        result.clear();
        this.assertGet(this.sampleKeys().e0, new Object[0]);
        Truth.assertThat((Collection)result).isEmpty();
    }

    @CollectionSize.Require(absent={CollectionSize.ZERO})
    @MapFeature.Require(value={MapFeature.SUPPORTS_PUT, MapFeature.ALLOWS_NULL_VALUES})
    public void testAddNullValue() {
        Collection result = (Collection)this.multimap().asMap().get(this.sampleKeys().e0);
        MultimapAsMapGetTester.assertTrue((boolean)result.add(null));
        MultimapAsMapGetTester.assertTrue((boolean)this.multimap().containsEntry(this.sampleKeys().e0, null));
    }

    @CollectionSize.Require(absent={CollectionSize.ZERO})
    @MapFeature.Require(value={MapFeature.SUPPORTS_REMOVE, MapFeature.ALLOWS_NULL_VALUE_QUERIES})
    public void testRemoveNullValue() {
        Collection result = (Collection)this.multimap().asMap().get(this.sampleKeys().e0);
        MultimapAsMapGetTester.assertFalse((boolean)result.remove(null));
    }

    @CollectionSize.Require(absent={CollectionSize.ZERO})
    @MapFeature.Require(value={MapFeature.SUPPORTS_PUT}, absent={MapFeature.ALLOWS_NULL_VALUES})
    public void testAddNullValueUnsupported() {
        Collection result = (Collection)this.multimap().asMap().get(this.sampleKeys().e0);
        try {
            result.add(null);
            MultimapAsMapGetTester.fail((String)"Expected NullPointerException");
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    @CollectionSize.Require(absent={CollectionSize.ZERO})
    @MapFeature.Require(value={MapFeature.SUPPORTS_PUT})
    public void testPropagatesAddToMultimap() {
        Collection result = (Collection)this.multimap().asMap().get(this.sampleKeys().e0);
        result.add(this.sampleValues().e3);
        Truth.assertThat((Collection)this.multimap().get(this.sampleKeys().e0)).has().exactly(this.sampleValues().e0, this.sampleValues().e3, new Object[0]);
    }

    @CollectionSize.Require(absent={CollectionSize.ZERO})
    @MapFeature.Require(value={MapFeature.SUPPORTS_REMOVE, MapFeature.SUPPORTS_PUT})
    public void testPropagatesRemoveThenAddToMultimap() {
        int oldSize = this.getNumElements();
        Object k0 = this.sampleKeys().e0;
        Object v0 = this.sampleValues().e0;
        Collection result = (Collection)this.multimap().asMap().get(k0);
        MultimapAsMapGetTester.assertTrue((boolean)result.remove(v0));
        MultimapAsMapGetTester.assertFalse((boolean)this.multimap().containsKey(k0));
        MultimapAsMapGetTester.assertFalse((boolean)this.multimap().containsEntry(k0, v0));
        Truth.assertThat((Collection)result).isEmpty();
        Object v1 = this.sampleValues().e1;
        Object v2 = this.sampleValues().e2;
        MultimapAsMapGetTester.assertTrue((boolean)result.add(v1));
        MultimapAsMapGetTester.assertTrue((boolean)result.add(v2));
        Truth.assertThat((Collection)result).has().exactly(v1, v2, new Object[0]);
        Truth.assertThat((Collection)this.multimap().get(k0)).has().exactly(v1, v2, new Object[0]);
        MultimapAsMapGetTester.assertTrue((boolean)this.multimap().containsKey(k0));
        MultimapAsMapGetTester.assertFalse((boolean)this.multimap().containsEntry(k0, v0));
        MultimapAsMapGetTester.assertTrue((boolean)this.multimap().containsEntry(k0, v2));
        MultimapAsMapGetTester.assertEquals((int)(oldSize + 1), (int)this.multimap().size());
    }

    @CollectionSize.Require(absent={CollectionSize.ZERO})
    @MapFeature.Require(value={MapFeature.SUPPORTS_REMOVE})
    public void testReflectsMultimapRemove() {
        Collection result = (Collection)this.multimap().asMap().get(this.sampleKeys().e0);
        this.multimap().removeAll(this.sampleKeys().e0);
        Truth.assertThat((Collection)result).isEmpty();
    }
}

