/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
package seisekilist;

import java.awt.BorderLayout;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.Enumeration;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.SwingConstants;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import javax.swing.filechooser.FileFilter;
import javax.swing.filechooser.FileNameExtensionFilter;
import javax.swing.plaf.FontUIResource;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableModel;

/**
 *
 * @author ishin
 *
 *
 *
 */
public class SeisekiList extends JFrame implements ActionListener {

    private final static String FONT_NAME = "ＭＳ ゴシック";
    private final static int FONT_SIZE = 12;
    private final static int MIN_WIDTH = 640;
    private final static int MIN_HEIGHT = 400;
    private final static String TITLE = "成績管理";

    private JButton inCsvBtn;
    private JButton outCsvBtn;
    private JButton histogramBtn;
    private JButton clearBtn;
    private JLabel statusBar;
    private JTable cTbl;
    private DefaultTableModel tableModel;
    private ReadCSVData rcd;
    private List<ScoreData> csvData;

    private final static String[] ACTIVE_ITEMS = {
        "CSV取込", "CSV出力", "ヒストグラム", "クリア"
    };

    private final static String[] COLUMNS_NAMES = {
        "番号", "氏名", "平均", "合計",
        "英語", "数学", "国語", "社会", "理科",};

    public SeisekiList() {
        setInit();
        initComponents();

    }

    private void setInit() {
        setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
        setLayout(new BorderLayout());
        setMinimumSize(new Dimension(MIN_WIDTH, MIN_HEIGHT));
        setTitle(TITLE);

    }

    private void initComponents() {

        JPanel nPanel = new JPanel();
        nPanel.setLayout(new BoxLayout(nPanel, BoxLayout.X_AXIS));

        //oCbx = new JComboBox(ACTIVE_ITEMS);
        inCsvBtn = new JButton("csv取込");
        outCsvBtn = new JButton("csv出力");
        histogramBtn = new JButton("ヒストグラム");
        clearBtn = new JButton("クリア");

        nPanel.add(inCsvBtn);
        nPanel.add(outCsvBtn);
        nPanel.add(histogramBtn);
        nPanel.add(clearBtn);

        tableModel = new DefaultTableModel(COLUMNS_NAMES, 0);
        cTbl = new JTable(tableModel);
        JScrollPane sp = new JScrollPane();
        sp.setViewportView(cTbl);

        statusBar = new JLabel("Ready.");
        JPanel sPanel = new JPanel();
        sPanel.setLayout(new FlowLayout(FlowLayout.LEFT));
        sPanel.add(statusBar);

        add(nPanel, BorderLayout.NORTH);
        add(sp, BorderLayout.CENTER);
        add(sPanel, BorderLayout.SOUTH);

        DefaultTableCellRenderer r = new DefaultTableCellRenderer();
        r.setHorizontalAlignment(SwingConstants.RIGHT);
        cTbl.getColumnModel().getColumn(0).setCellRenderer(r);
        for (int i = 2; i < 9; i++) {
            cTbl.getColumnModel().getColumn(i).setCellRenderer(r);
        }

        inCsvBtn.addActionListener(this);
        outCsvBtn.addActionListener(this);
        outCsvBtn.setEnabled(false);
        histogramBtn.addActionListener(this);
        histogramBtn.setEnabled(false);
        clearBtn.addActionListener(this);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        // クリアボタン
        if (e.getSource() == clearBtn) {
            statusBar.setText(ACTIVE_ITEMS[3]);
            tableModel.setRowCount(0);
            csvData = null;
            outCsvBtn.setEnabled(false);
            histogramBtn.setEnabled(false);
        }

        // 開始ボタン
        if (e.getSource() == inCsvBtn) {
            // CSV取り込み
            statusBar.setText(ACTIVE_ITEMS[0]);
            csvfileInput();
        }

        if (e.getSource() == outCsvBtn) {
            // CSV出力
            statusBar.setText(ACTIVE_ITEMS[1]);
            csvfileOutput();
        }

        if (e.getSource() == histogramBtn) {
            // ヒストグラム
            if (csvData != null) {
                statusBar.setText(ACTIVE_ITEMS[2]);
                drawHistogram();
            }
        }

    }

    private void drawHistogram() {
        // ヒストグラムを作成、表示
        Histogram hview = new Histogram(this, csvData);
        hview.setVisible(true);
    }

    private void csvfileOutput() {
        // ＣＳＶファイルを出力
        JFileChooser filechooser = new JFileChooser("./");
        FileFilter filter = new FileNameExtensionFilter("CSVファイル", "csv", "CSV");
        filechooser.setFileFilter(filter);
        filechooser.setSelectedFile(new File("output.csv"));
        int selected = filechooser.showSaveDialog(this);
        switch (selected) {
            case JFileChooser.APPROVE_OPTION:
                File file = filechooser.getSelectedFile();
                System.out.println(file.getName());
                writeCSVData(file);
                break;
            case JFileChooser.CANCEL_OPTION:
                System.out.println("キャンセルされました");
                break;
            case JFileChooser.ERROR_OPTION:
                System.out.println("エラー又は取消しがありました");
                break;
            default:
                break;
        }

    }
    private void writeCSVData(File file) {
        WriteCSVData wcd = new WriteCSVData(file);
        wcd.writeScoreData(csvData);
        
    }

    private void csvfileInput() {
        // ＣＳＶファイル取り込み
        JFileChooser filechooser = new JFileChooser("./");
        FileFilter filter = new FileNameExtensionFilter("CSVファイル", "csv", "CSV");
        filechooser.setFileFilter(filter);

        int selected = filechooser.showOpenDialog(this);
        switch (selected) {
            case JFileChooser.APPROVE_OPTION:
                File file = filechooser.getSelectedFile();
                System.out.println(file.getName());
                readCSVData(file);
                break;
            case JFileChooser.CANCEL_OPTION:
                System.out.println("キャンセルされました");
                break;
            case JFileChooser.ERROR_OPTION:
                System.out.println("エラー又は取消しがありました");
                break;
            default:
                break;
        }

    }

    private void readCSVData(File file) {
        rcd = new ReadCSVData();
        csvData = rcd.readScoreData(file);
        if(csvData != null){
            outCsvBtn.setEnabled(true);
            histogramBtn.setEnabled(true);
        }

        String[] data = new String[9];
        for (int i = 0; i < csvData.size(); i++) {
            ScoreData sd = csvData.get(i);

            data[0] = sd.getID();
            data[1] = sd.getName();
            data[2] = String.valueOf(sd.getAverage());
            data[3] = String.valueOf(sd.getTotal());
            System.out.print("no : " + sd.getID());
            System.out.print("  name : " + sd.getName());
            System.out.print("  avg : " + sd.getAverage());
            System.out.print("  total : " + sd.getTotal());

            for (int j = 0; j < sd.getScore().size(); j++) {
                data[j + 4] = sd.getScore().get(j);
                System.out.print("   : " + data[j + 4]);
            }
            System.out.println("");
            tableModel.addRow(data);

        }
    }

    /**
     * @param args the command line arguments
     */
    public static void main(String[] args) {
        EventQueue.invokeLater(new Runnable() {
            @Override
            public void run() {
                createAndShowGUI();
            }
        });
    }

    public static void createAndShowGUI() {
        FontUIResource font = new FontUIResource(FONT_NAME, Font.PLAIN, FONT_SIZE);
        setUIFont(font);
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());

        } catch (ClassNotFoundException | IllegalAccessException |
                InstantiationException | UnsupportedLookAndFeelException e) {
            Logger.getLogger(SeisekiList.class
                    .getName()).log(Level.SEVERE, null, e);
        }

        SeisekiList ga = new SeisekiList();
        ga.setLocationRelativeTo(null);
        ga.setVisible(true);
    }

    private static void setUIFont(FontUIResource font) {
        Enumeration keys = UIManager.getDefaults().keys();
        while (keys.hasMoreElements()) {
            Object key = keys.nextElement();
            Object value = UIManager.get(key);
            if (value instanceof FontUIResource) {
                UIManager.put(key, font);
            }
        }
    }
}
