/*
 * Copyright(C) 2012 - 2013 orinos Co.,Ltd. All rights reserved.
 * http://www.orinos.co.jp/
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

package com.aimluck.eip.modules.actions.opinionbox;

import java.util.ArrayList;
import java.util.List;

import org.apache.jetspeed.portal.portlets.VelocityPortlet;
import org.apache.jetspeed.services.logging.JetspeedLogFactoryService;
import org.apache.jetspeed.services.logging.JetspeedLogger;
import org.apache.turbine.util.RunData;
import org.apache.velocity.context.Context;

import com.aimluck.eip.common.ALEipConstants;
import com.aimluck.eip.modules.actions.common.ALBaseAction;
import com.aimluck.eip.opinionbox.OpinionBoxReplyFormData;
import com.aimluck.eip.opinionbox.OpinionBoxSelectData;
import com.aimluck.eip.opinionbox.util.OpinionBoxUtils;
import com.aimluck.eip.util.ALEipUtils;

/**
 * 目安箱のアクションクラスです。 <BR>
 *
 */
public class OpinionBoxAction extends ALBaseAction {

  /** 返信用キー */
  private final String RESULT_ON_OPINIONBOX_DETAIL = "resultOnOpinionBoxDetail";

  /** 返信用エラーメッセージキー */
  private final String ERROR_MESSAGE_LIST_ON_OPINIONBOX_DETAIL =
    "errmsgsOnOpinionBoxDetail";

  /** 返信用 result */
  private Object resultOnOpinionBoxDetail;

  /** 返信用異常系のメッセージを格納するリスト */
  private List<String> errmsgListOnOpinionBoxDetail;

  /** logger */
  private static final JetspeedLogger logger = JetspeedLogFactoryService
    .getLogger(OpinionBoxAction.class.getName());

  /**
   * 通常表示の際の処理を記述します。 <BR>
   *
   * @param portlet
   * @param context
   * @param rundata
   * @throws Exception
   */
  @Override
  protected void buildNormalContext(VelocityPortlet portlet, Context context,
      RunData rundata) throws Exception {

    // セッション情報をクリア
    OpinionBoxUtils.clearOpinionBoxSession(rundata, context);
    ALEipUtils.setTemp(rundata, context, "OpinionBox_Maximize", "false");

    OpinionBoxSelectData listData = new OpinionBoxSelectData();
    listData.initField();
    listData.setRowsNum(Integer.parseInt(portlet
      .getPortletConfig()
      .getInitParameter("p1a-rows")));
    if (listData.doViewList(this, rundata, context)) {
      setTemplate(rundata, "opinionbox");
    }

  }

  /**
   * 最大化表示の際の処理を記述します。 <BR>
   *
   * @param portlet
   * @param context
   * @param rundata
   */
  @Override
  protected void buildMaximizedContext(VelocityPortlet portlet,
      Context context, RunData rundata) {

    // セッション情報をクリア
    OpinionBoxUtils.clearOpinionBoxSession(rundata, context);
    ALEipUtils.setTemp(rundata, context, "OpinionBox_Maximize", "true");

    OpinionBoxSelectData listData = new OpinionBoxSelectData();
    listData.initField();
    // PSMLからパラメータをロードする
    // 最大表示件数（最大化時）
    listData.setRowsNum(Integer.parseInt(ALEipUtils
      .getPortlet(rundata, context)
      .getPortletConfig()
      .getInitParameter("p1b-rows")));
    listData.doViewList(this, rundata, context);
    setTemplate(rundata, "opinionbox-list");
  }

  /**
   *
   * @param obj
   */
  public void setResultDataOnOpinionBoxDetail(Object obj) {
    resultOnOpinionBoxDetail = obj;
  }

  /**
   *
   * @param msg
   */
  public void addErrorMessagesOnOpinionBoxDetail(List<String> msgs) {
    if (errmsgListOnOpinionBoxDetail == null) {
      errmsgListOnOpinionBoxDetail = new ArrayList<String>();
    }
    errmsgListOnOpinionBoxDetail.addAll(msgs);
  }

  /**
   * トピックに返信します。 <BR>
   *
   * @param rundata
   * @param context
   * @throws Exception
   */
  public void doOpinionBox_reply(RunData rundata, Context context) throws Exception {
    OpinionBoxReplyFormData formData = new OpinionBoxReplyFormData();
    formData.initField();
    if (formData.doInsert(this, rundata, context)) {
      // データ登録が成功したとき
      doOpinionBox_detail(rundata, context);
    } else {
      // トピック詳細表示用の情報を再取得
      OpinionBoxSelectData detailData = new OpinionBoxSelectData();
      detailData.initField();
      if (detailData.doViewDetail(this, rundata, context)) {
        setTemplate(rundata, "opinionbox-detail");
      } else {
        doOpinionBox_list(rundata, context);
      }
    }
  }

  /**
   * トピックを一覧表示します。 <BR>
   *
   * @param rundata
   * @param context
   * @throws Exception
   */
  public void doOpinionBox_list(RunData rundata, Context context) throws Exception {
    OpinionBoxSelectData listData = new OpinionBoxSelectData();
    listData.initField();
    // PSMLからパラメータをロードする
    // 最大表示件数（最大化時）
    listData.setRowsNum(Integer.parseInt(ALEipUtils
      .getPortlet(rundata, context)
      .getPortletConfig()
      .getInitParameter("p1b-rows")));
    listData.doViewList(this, rundata, context);
    setTemplate(rundata, "opinionbox-list");
  }

  /**
   * トピックを詳細表示します。 <BR>
   *
   * @param rundata
   * @param context
   * @throws Exception
   */
  public void doOpinionBox_detail(RunData rundata, Context context)
      throws Exception {
    OpinionBoxSelectData detailData = new OpinionBoxSelectData();
    detailData.initField();
    if (detailData.doViewDetail(this, rundata, context)) {
      if (detailData.showReplyForm()) {
        OpinionBoxReplyFormData formData = new OpinionBoxReplyFormData();
        formData.initField();
        formData.doViewForm(this, rundata, context);
      }
      setTemplate(rundata, "opinionbox-detail");
    } else {
      doOpinionBox_list(rundata, context);
    }
  }

  /**
   *
   * @param context
   */
  public void putDataOnOpinionBoxDetail(RunData rundata, Context context) {
    context.put(RESULT_ON_OPINIONBOX_DETAIL, resultOnOpinionBoxDetail);
    context.put(ERROR_MESSAGE_LIST_ON_OPINIONBOX_DETAIL, errmsgListOnOpinionBoxDetail);

    // For security
    context.put(ALEipConstants.SECURE_ID, rundata.getUser().getTemp(
      ALEipConstants.SECURE_ID));
  }

}
