/*
 * Copyright(C) 2012 orinos Co.,Ltd. All rights reserved.
 * http://www.orinos.co.jp/
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

package com.aimluck.eip.modules.screens;

import java.util.Calendar;
import java.util.List;

import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;

import org.apache.cayenne.DataRow;
import org.apache.cayenne.exp.Expression;
import org.apache.cayenne.exp.ExpressionFactory;
import org.apache.jetspeed.services.logging.JetspeedLogFactoryService;
import org.apache.jetspeed.services.logging.JetspeedLogger;
import org.apache.turbine.util.RunData;

import com.aimluck.eip.cayenne.om.portlet.AvzTLunchOrder;
import com.aimluck.eip.cayenne.om.portlet.AvzTLunchOrderItem;
import com.aimluck.eip.cayenne.om.portlet.AvzTLunchUserOrder;
import com.aimluck.eip.common.ALEipUser;
import com.aimluck.eip.lunchorder.LunchOrderForUserTotalResultData;
import com.aimluck.eip.lunchorder.util.LunchOrderUtils;
import com.aimluck.eip.orm.Database;
import com.aimluck.eip.orm.query.ResultList;
import com.aimluck.eip.orm.query.SQLTemplate;
import com.aimluck.eip.orm.query.SelectQuery;
import com.aimluck.eip.util.ALEipUtils;

/**
 * 注文表（集計）ファイル出力を取り扱うクラスです
 */
public class LunchOrderMonthTotalCsvExportScreen extends ALCSVScreen {
  /**
   * logger
   */
  private static final JetspeedLogger logger =
    JetspeedLogFactoryService.getLogger(LunchOrderMonthTotalCsvExportScreen.class
      .getName());

  /**
   * HTTP コンテンツタイプ
   *
   * @see org.apache.turbine.modules.screens.RawScreen#getContentType(org.apache.turbine.util.RunData)
   */
  @Override
  protected String getContentType(RunData rundata) {
    return "application/octet-stream";
  }

  /** 件名 */
  private String name;

  /**
   * 出力ファイル名（接頭辞）
   */
  public static String FILE_NAME = "";

  /**
   * 拡張子名
   */
  public static final String FILE_EXTENTION = ".csv";

  /**
   * CSVデータ改行値
   */
  public static final String LINE_SEPARATOR =
    System.getProperty("line.separator");

  /**
   * CSVデータ区切り文字
   */
  public static final String COLOMN_SEPARATOR = ",";

  @Override
  protected void doOutput(RunData rundata) throws Exception {
    ServletOutputStream out = null;

    try {

      Calendar today = Calendar.getInstance();
      String result = getCSVString(rundata);
      FILE_NAME =
        name //rundata.getParameters().getString("store_name")
          + "月単位集計表"
          + "-"
          + today.get(Calendar.YEAR)
          + "-"
          + (today.get(Calendar.MONTH) + 1)
          + "-"
          + today.get(Calendar.DAY_OF_MONTH)
          + FILE_EXTENTION;
      String fileName =
        new String(FILE_NAME.getBytes("Shift_JIS"), "ISO-8859-1");

      HttpServletResponse response = rundata.getResponse();
      // ファイル名の送信(attachment部分をinlineに変更すればインライン表示)
      response.setHeader("Content-disposition", "attachment; filename=\""
        + fileName
        + "\"");
      response.setHeader("Cache-Control", "no-cache");
      response.setHeader("Pragma", "No-cache");

      // ファイル内容の出力
      out = response.getOutputStream();
      out.write(result.getBytes("Shift_JIS"));
      out.flush();
      out.close();
    } catch (Exception e) {
      logger.error("[ERROR]", e);
    }

  }

  /**
   * CSV文字列取り出し用メソッド。<br />
   * CSV文字列を返します。
   *
   * @param rundata
   *            RunData
   * @return
   */
  @Override
  protected String getCSVString(RunData rundata) {
    StringBuffer sb = new StringBuffer();
    // ヘッダライン設定
    makeHeaderLine(sb);

    // IDを取得
    String storeMapId =
      rundata.getParameters().getString("target_order_map_id");// 選択された弁当屋IDを親クラスのメソッドにて取得
    // 対象年
    String targetYear = rundata.getParameters().getString("target_year");
    // 対象月
    String targetMonth = rundata.getParameters().getString("target_month");
    // 月の桁数判定
    if (targetMonth.length() == 1) {
    	targetMonth = "0" + targetMonth;
    }
    String targetYm = targetYear+"-"+targetMonth;

    int orderMapId = Integer.valueOf(storeMapId);

    // 件名を取得する
    Expression nameExp =
    	ExpressionFactory.matchDbExp(AvzTLunchOrder.ORDER_MAP_ID_PK_COLUMN, orderMapId);
    SelectQuery<AvzTLunchOrder> kenName = Database.query(AvzTLunchOrder.class,nameExp);
    name = kenName.getResultList().get(0).getStoreName();



    // SQLの作成
    StringBuffer idStatement = new StringBuffer();
    idStatement.append("SELECT DISTINCT ");
    idStatement.append("  A.USER_ID ");
    idStatement.append("FROM AVZ_T_LUNCH_USER_ORDER as A ");
    idStatement.append("LEFT JOIN AVZ_T_LUNCH_ORDER_ITEM as B ");
    idStatement.append("  on A.ITEM_ID = B.ITEM_ID ");
    idStatement.append("LEFT JOIN AVZ_T_LUNCH_ORDER as C ");
    idStatement.append("  on B.ORDER_MAP_ID = C.ORDER_MAP_ID ");
    idStatement.append("WHERE C.ORDER_MAP_ID  = ").append(storeMapId);
    idStatement.append(" AND TO_CHAR(A.ORDER_DATE, 'YYYY-MM') LIKE '").append(targetYm).append("%'");

    String idQuery = idStatement.toString();

    SQLTemplate<AvzTLunchUserOrder> orderForUser =
      Database.sql(AvzTLunchUserOrder.class, idQuery);
    List<DataRow> orderForUsers = orderForUser.fetchListAsDataRow();

    int userSize = orderForUsers.size();
    DataRow dataRow;
    if (userSize > 0) {// 弁当注文しているユーザーがいる場合
      for (int i = 0; i < userSize; i++) {
        String sourceOrderItemName = "";
        int orderSumForUser = 0;

        dataRow = orderForUsers.get(i);

        int userId =
          (((Integer) ALEipUtils.getObjFromDataRow(
            dataRow,
            AvzTLunchUserOrder.USER_ID_COLUMN)).intValue());


        // SQLの作成
        StringBuffer itemStatement = new StringBuffer();
        itemStatement.append("SELECT DISTINCT ");
        itemStatement.append("  A.ITEM_ID ");
        itemStatement.append("FROM AVZ_T_LUNCH_USER_ORDER as A ");
        itemStatement.append("LEFT JOIN AVZ_T_LUNCH_ORDER_ITEM as B ");
        itemStatement.append("  on A.ITEM_ID = B.ITEM_ID ");
        itemStatement.append("LEFT JOIN AVZ_T_LUNCH_ORDER as C ");
        itemStatement.append("  on B.ORDER_MAP_ID = C.ORDER_MAP_ID ");
        itemStatement.append("WHERE C.ORDER_MAP_ID  = ").append(storeMapId);
        itemStatement.append(" AND A.USER_ID  = ").append(userId);
        itemStatement.append(" AND TO_CHAR(A.ORDER_DATE, 'YYYY-MM') LIKE '").append(targetYm).append("%'");

        String itemQuery = itemStatement.toString();

        SQLTemplate<AvzTLunchUserOrder> orderItem =
          Database.sql(AvzTLunchUserOrder.class, itemQuery);
        List<DataRow> orderItems = orderItem.fetchListAsDataRow();

        int orderItemSize = orderItems.size();
        DataRow dataRowForItem;
        for (int k = 0; k < orderItemSize; k++) {// 注文した商品ごとの注文数を検索
          dataRowForItem = orderItems.get(k);
          int itemId =
            (((Integer) ALEipUtils.getObjFromDataRow(
              dataRowForItem,
              AvzTLunchUserOrder.ITEM_ID_COLUMN)).intValue());

          // SQLの作成
          StringBuffer amountStatement = new StringBuffer();
          amountStatement.append("SELECT ORDER_AMOUNT ");

          amountStatement.append("FROM AVZ_T_LUNCH_USER_ORDER  ");
          amountStatement.append("WHERE ITEM_ID  = ").append(itemId);
          amountStatement.append(" AND USER_ID  = ").append(userId);
          amountStatement.append(" AND TO_CHAR(ORDER_DATE, 'YYYY-MM') LIKE '").append(targetYm).append("%'");

          String sumQuery = amountStatement.toString();

          SQLTemplate<AvzTLunchUserOrder> orderSum =
            Database.sql(AvzTLunchUserOrder.class, sumQuery);
          List<DataRow> orderSums = orderSum.fetchListAsDataRow();
          int orderSumSize = orderSums.size();
          DataRow dataRowForOrderSums;
          int combineOrderSum = 0;
          for (int m = 0; m < orderSumSize; m++) {// 同一商品の注文数は足していく処理
            dataRowForOrderSums = orderSums.get(m);
            combineOrderSum =
              combineOrderSum
                + (((Integer) ALEipUtils.getObjFromDataRow(
                  dataRowForOrderSums,
                  AvzTLunchUserOrder.ORDER_AMOUNT_COLUMN)).intValue());

          }

          // 名前
          sb.append("\""
            + ALEipUtils.getUserFullName(userId)
            + "\""
            + COLOMN_SEPARATOR);

          // 件名
          //sb.append("\"" + name + "\"" + COLOMN_SEPARATOR);

          // 商品名
          sb.append("\""
            + LunchOrderUtils.getItemName(itemId)
            + "\""
            + COLOMN_SEPARATOR);

          // 注文数
          sb.append("\"" + combineOrderSum + "\"" + COLOMN_SEPARATOR);

          // 商品単価
          sb.append("\"" + LunchOrderUtils.getPrice(itemId) + "\"" + COLOMN_SEPARATOR);

          // 小計金額
          sb.append("\"" + combineOrderSum * LunchOrderUtils.getPrice(itemId) + "\"" + COLOMN_SEPARATOR);
          sb.append(LINE_SEPARATOR);

            }
          }
        }


    // 生成文字列 デバック用出力
    logger.debug(sb.toString());

    return sb.toString();
  }

  @Override
  protected String getFileName() {

    return null;
  }

  /**
   * CSVのヘッダ情報を生成します。
   *
   * @param sb
   *            StringBuffer
   */
  private void makeHeaderLine(StringBuffer sb) {
	sb.append("\"名前\"" + COLOMN_SEPARATOR);
	//sb.append("\"件名\"" + COLOMN_SEPARATOR);
	sb.append("\"商品名\"" + COLOMN_SEPARATOR);
    sb.append("\"注文数\"" + COLOMN_SEPARATOR);
    sb.append("\"商品価格\"" + COLOMN_SEPARATOR);
    sb.append("\"小計金額\"");
    sb.append(LINE_SEPARATOR);
  }
}
