/*
 * Copyright(C) 2010 avanza Co.,Ltd. All rights reserved.
 * http://www.avnz.co.jp/
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 */

package com.aimluck.eip.lunchorder;

import com.aimluck.commons.field.ALNumberField;
import com.aimluck.commons.field.ALStringField;
import com.aimluck.eip.common.ALData;

/**
 * LunchOrderのResultDataです。 <BR>
 *
 */
public class LunchOrderResultData implements ALData {

  /** 締め切り時刻用フラグ */
  private ALStringField deadlineflag;

  /** ID */
  private ALNumberField order_map_id;

  /** ユーザーID */
  private int user_id;

  /** 弁当屋名 */
  private ALStringField store_name;

  /** コメント */
  private ALStringField comment;

  /** 項目総数 */
  private ALNumberField item_num;

  /** 項番表示・非表示ステータス */
  private ALStringField item_num_status;

  /** 最低注文条件の有無（種類） */
  private ALStringField min_status;

  /** 最低注文金額 */
  private ALNumberField min_plice;

  /** 最低注文数 */
  private ALNumberField min_num;

  /** 締め切り時刻 */
  private ALNumberField deadline_date;

  /** 登録日 */
  private ALStringField create_date;

  /** 更新日 */
  private ALStringField update_date;

  /** 一覧画面表示時のステータス */
  private ALStringField status;

  /** 注文済みかどうか */
  private boolean is_order;

  /** ログインユーザーID */
  private int login_user_id;

  /**
   *
   * @see com.aimluck.eip.common.ALData#initField()
   */
  public void initField() {
    deadlineflag = new ALStringField();
    order_map_id = new ALNumberField();
    store_name = new ALStringField();
    comment = new ALStringField();
    item_num = new ALNumberField();
    item_num_status = new ALStringField();
    min_status = new ALStringField();
    min_plice = new ALNumberField();
    min_num = new ALNumberField();
    deadline_date = new ALNumberField();
    create_date = new ALStringField();
    update_date = new ALStringField();
    status = new ALStringField();
  }

  public ALStringField getDeadLineFlag() {
    return deadlineflag;
  }

  public void setDeadLineFlag(String string) {
    deadlineflag.setValue(string);
  }

  /**
   * @return
   */
  public ALNumberField getOrderMapId() {
    return order_map_id;
  }

  /**
   * @param i
   */
  public void setOrderMapId(int i) {
    order_map_id.setValue(i);
  }

  /**
   * @return
   */
  public int getUserId() {
    return user_id;
  }

  /**
   * @param i
   */
  public void setUserId(int i) {
    user_id  = i;
  }

  /**
   * @return
   */
  public ALStringField getStoreName() {
    return store_name;
  }

  /**
   * @param string
   */
  public void setStoreName(String string) {
    store_name.setValue(string);
  }

  /**
   * @return
   */
  public ALStringField getComment() {
    return comment;
  }

  /**
   * @param string
   */
  public void setComment(String string) {
    comment.setValue(string);
  }

  /**
   *
   * @return
   */
  public ALNumberField getItemNum() {
    return item_num;
  }

  /**
   * @param i
   */
  public void setItemNum(int i) {
    item_num.setValue(i);
  }

  /**
   * @return
   */
  public ALStringField getItemNumStatus() {
    return item_num_status;
  }

  /**
   * @param string
   */
  public void setItemNumStatus(String string) {
    item_num_status.setValue(string);
  }

  /**
   * @return
   */
  public ALStringField getMinStatus() {
    return min_status;
  }

  /**
   * @param string
   */
  public void setMinStatus(String string) {
    min_status.setValue(string);
  }

  /**
   *
   * @return
   */
  public ALNumberField getMinPlice() {
    return min_plice;
  }

  /**
   * @param i
   */
  public void setMinPlice(int i) {
    min_plice.setValue(i);
  }

  /**
   *
   * @return
   */
  public ALNumberField getMinNum() {
    return min_num;
  }

  /**
   * @param i
   */
  public void setMinNum(int i) {
    min_num.setValue(i);
  }

  /**
   * @return
   */
  public ALStringField getCreateDate() {
    return create_date;
  }

  /**
   * @param string
   */
  public void setCreateDate(String string) {
    create_date.setValue(string);
  }

  /**
   * @return
   */
  public ALStringField getUpdateDate() {
    return update_date;
  }

  /**
   * @param string
   */
  public void setUpdateDate(String string) {
    update_date.setValue(string);
  }

  /**
   * @return
   */
  public ALNumberField getDeadlineDate() {
    return deadline_date;
  }

  /**
   * @param i
   */
  public void setDeadlineDate(int i) {
    deadline_date.setValue(i);
  }

  /**
   * @return
   */
  public ALStringField getStatus() {
    return status;
  }

  /**
   * @param string
   */
  public void setStatus(String string) {
    status.setValue(string);
  }

  /**
   *
   */
  public void setIsOrder(boolean order) {
	  is_order = order;
  }
  public boolean isOrder() {
	  return is_order;
  }

  /**
  *
  */
 public void setLoginUserId(int id) {
	  login_user_id = id;
 }
 public int getLoginUserId() {
	  return login_user_id;
 }
}
