/*
 * Copyright(C) 2012 orinos Co.,Ltd. All rights reserved.
 * http://www.orinos.co.jp/
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

package com.aimluck.eip.lunchorder;

import java.util.Calendar;
import java.util.Date;
import java.util.jar.Attributes;

import javax.xml.crypto.Data;

import org.apache.cayenne.exp.Expression;
import org.apache.cayenne.exp.ExpressionFactory;
import org.apache.cayenne.query.QualifiedQuery;
import org.apache.jetspeed.services.logging.JetspeedLogFactoryService;
import org.apache.jetspeed.services.logging.JetspeedLogger;
import org.apache.turbine.util.RunData;
import org.apache.velocity.context.Context;

import com.aimluck.commons.field.ALDateField;
import com.aimluck.commons.field.ALDateTimeField;
import com.aimluck.eip.cayenne.om.portlet.AvzTLunchOrder;
import com.aimluck.eip.cayenne.om.portlet.AvzTLunchOrderItem;
import com.aimluck.eip.cayenne.om.portlet.AvzTLunchUser;
import com.aimluck.eip.cayenne.om.portlet.AvzTLunchUserOrder;
import com.aimluck.eip.common.ALAbstractSelectData;
import com.aimluck.eip.common.ALDBErrorException;
import com.aimluck.eip.common.ALData;
import com.aimluck.eip.common.ALPageNotFoundException;
import com.aimluck.eip.modules.actions.common.ALAction;
import com.aimluck.eip.orm.Database;
import com.aimluck.eip.orm.query.ResultList;
import com.aimluck.eip.orm.query.SelectQuery;
import com.aimluck.eip.util.ALEipUtils;

/**
 * 注文表検索データ(初期画面)を管理するクラスです。 <BR>
 *
 */
public class LunchOrderMonthTotalSelectData extends
    ALAbstractSelectData<AvzTLunchOrder, Object> implements ALData {

  /** logger */
  private static final JetspeedLogger logger =
    JetspeedLogFactoryService.getLogger(LunchOrderMonthTotalSelectData.class.getName());


  /**
   *
   * @param action
   * @param rundata
   * @param context
   * @see com.aimluck.eip.common.ALAbstractSelectData#init(com.aimluck.eip.modules.actions.common.ALAction,
   *      org.apache.turbine.util.RunData, org.apache.velocity.context.Context)
   */
  @Override
  public void init(ALAction action, RunData rundata, Context context)

  throws ALPageNotFoundException, ALDBErrorException {

    super.init(action, rundata, context);

  }

  /**
   * 一覧データを取得します。 <BR>
   *
   * @param rundata
   * @param context
   * @return
   * @see com.aimluck.eip.common.ALAbstractListData#selectData(org.apache.turbine.util.RunData,
   *      org.apache.velocity.context.Context)
   */
  @Override
  public ResultList<AvzTLunchOrder> selectList(RunData rundata, Context context) {// 検索条件を設定した
    // SelectQuery
    // を元に検索するメソッド
    try {

      SelectQuery<AvzTLunchOrder> query = getSelectQuery(rundata, context);
      buildSelectQueryForListView(query);
      query.orderAscending("storeName");
      ResultList<AvzTLunchOrder> list = query.getResultList();
      return list;

    } catch (Exception ex) {
      logger.error("Exception", ex);
      return null;
    }

  }

  /**
   * 検索条件を設定した SelectQuery を返します。 <BR>
   *
   * @param rundata
   * @param context
   * @return
   */
  private SelectQuery<AvzTLunchOrder> getSelectQuery(RunData rundata,
      Context context) {
    SelectQuery<AvzTLunchOrder> query = Database.query(AvzTLunchOrder.class);

    // 集計フラグが立っているもの
    Expression exp0 =
    	ExpressionFactory.matchExp(AvzTLunchOrder.TOTALIZATION_TARGET_FLG_PROPERTY, "1");

    // 削除されていないもの
    //Expression exp1 =
    //	ExpressionFactory.matchExp(AvzTLunchOrder.DEL_FLG_PROPERTY, "0");
    //query.setQualifier(exp0.andExp(exp1));

    query.setQualifier(exp0);

    return buildSelectQueryForFilter(query, rundata, context);
  }

  /**
   * ResultData に値を格納して返します。（一覧データ） <BR>
   *
   * @param obj
   * @return
   * @see com.aimluck.eip.common.ALAbstractSelectData#getListData(java.lang.Object)
   */
  @Override
  protected Object getResultData(AvzTLunchOrder obj) {// 結果を保存
    try {
      AvzTLunchOrder record = obj;

      LunchOrderResultData rd = new LunchOrderResultData();// インスタンス生成
      rd.initField(); // オブジェクトのフィールドを初期化

      // order map id を代入
      rd.setOrderMapId(record.getOrderMapId());
      // 件名
      rd.setStoreName(record.getStoreName());
      // コメント
      rd.setComment(record.getComment());


      return rd;

    } catch (Exception ex) {
      logger.error("Exception", ex);
      return null;
    }
  }

  /**
   * 詳細データを取得します。 <BR>
   *
   * @param rundata
   * @param context
   * @return
   * @see com.aimluck.eip.common.ALAbstractSelectData#selectDetail(org.apache.turbine.util.RunData,
   *      org.apache.velocity.context.Context)
   */
  @Override
  public Object selectDetail(RunData rundata, Context context)
      throws ALPageNotFoundException {
    return null;
  }

  /**
   * ResultData に値を格納して返します。（詳細データ） <BR>
   *
   * @param obj
   * @return
   * @see com.aimluck.eip.common.ALAbstractSelectData#getResultDataDetail(java.lang.Object)
   */
  @Override
  protected Object getResultDataDetail(Object obj) {
    return null;
  }


  /**
   * @return
   * @see com.aimluck.eip.common.ALAbstractSelectData#getColumnMap()
   */
  @Override
  protected Attributes getColumnMap() {
    Attributes map = new Attributes();
    return map;
  }

/**
 * @return search_date
 */
public ALDateTimeField getSearchDate() {
	Date now = Calendar.getInstance().getTime();
	ALDateTimeField temp = new ALDateTimeField();
	temp.setValue(now);
	return temp;
}



}
