/*
 * Copyright(C) 2012 - 2013 orinos Co.,Ltd. All rights reserved.
 * http://www.orinos.co.jp/
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

package com.aimluck.eip.modules.screens;

import java.util.ArrayList;
import java.util.List;

import org.apache.jetspeed.services.logging.JetspeedLogFactoryService;
import org.apache.jetspeed.services.logging.JetspeedLogger;
import org.apache.turbine.util.RunData;
import org.apache.velocity.context.Context;

import com.aimluck.eip.improveope.ImproveopeReceiveFormData;
import com.aimluck.eip.improveope.ImproveopeReceiveSelectData;
import com.aimluck.eip.improveope.util.ImproveopeUtils;
import com.aimluck.eip.util.ALEipUtils;

/**
 * 申請を処理するクラスです。
 *
 */

public class ImproveopeReceiveFormScreen extends ALVelocityScreen {

  /** logger */
  private static final JetspeedLogger logger = JetspeedLogFactoryService
    .getLogger(ImproveopeReceiveFormScreen.class.getName());

  /** 返信用キー */
  private final String RESULT_ON_RECEIVE_FORM = "resultOnReceiveForm";

  /** 返信用エラーメッセージキー */
  private final String ERROR_MESSAGE_LIST_ON_RECEIVE_FORM =
    "errmsgsOnReceiveForm";

  /** 返信用 result */
  private Object resultOnReceiveForm;

  /** 返信用異常系のメッセージを格納するリスト */
  private List<String> errmsgListOnReceiveForm;

  /**
   *
   * @param rundata
   * @param context
   * @throws Exception
   */
  @Override
  protected void doOutput(RunData rundata, Context context) throws Exception {

    try {
      doImproveope_form(rundata, context);
    } catch (Exception ex) {
      logger.error("[ImproveopeReceiveFormScreen] Exception.", ex);
      ALEipUtils.redirectDBError(rundata);
    }
  }

  protected void doImproveope_form(RunData rundata, Context context) {
	ImproveopeReceiveSelectData detailData = new ImproveopeReceiveSelectData();
	detailData.initField();
	detailData.doViewDetail(this, rundata, context);

	ImproveopeReceiveFormData formData = new ImproveopeReceiveFormData();
    formData.initField();
    formData.doViewForm(this, rundata, context);


    String layout_template = "portlets/html/ja/ajax-improveope-receive-form.vm";
    setTemplate(rundata, context, layout_template);
  }

  /**
  *
  * @param obj
  */
 public void setResultDataOnReceiveForm(Object obj) {
	 resultOnReceiveForm = obj;
 }

 /**
  *
  * @param msg
  */
 public void addErrorMessagesOnReceiveForm(List<String> msgs) {
   if (errmsgListOnReceiveForm == null) {
	   errmsgListOnReceiveForm = new ArrayList<String>();
   }
   errmsgListOnReceiveForm.addAll(msgs);
 }

 /**
  *
  * @param context
  */
 public void putDataOnReceiveForm(RunData rundata, Context context) {
   context.put(RESULT_ON_RECEIVE_FORM, resultOnReceiveForm);
   context.put(ERROR_MESSAGE_LIST_ON_RECEIVE_FORM, errmsgListOnReceiveForm);
 }
  /**
   * @return
   */
  @Override
  protected String getPortletName() {
    return ImproveopeUtils.MSGBOARD_PORTLET_NAME;
  }
}
