/*
 * Copyright(C) 2012 - 2013 orinos Co.,Ltd. All rights reserved.
 * http://www.orinos.co.jp/
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

package com.aimluck.eip.modules.actions.improveope;

import java.util.ArrayList;
import java.util.List;

import org.apache.jetspeed.portal.portlets.VelocityPortlet;
import org.apache.jetspeed.services.logging.JetspeedLogFactoryService;
import org.apache.jetspeed.services.logging.JetspeedLogger;
import org.apache.turbine.util.RunData;
import org.apache.velocity.context.Context;

import com.aimluck.eip.common.ALEipConstants;
import com.aimluck.eip.improveope.ImproveopeTopicFormData;
import com.aimluck.eip.improveope.ImproveopeTopicMultiDelete;
import com.aimluck.eip.improveope.ImproveopeTopicReplyFormData;
import com.aimluck.eip.improveope.ImproveopeTopicSelectData;
import com.aimluck.eip.util.ALEipUtils;

/**
 * 掲示板のアクションクラス
 *
 */
public class CellImproveopeAction extends ImproveopeAction {

  /** logger */
  private static final JetspeedLogger logger =
    JetspeedLogFactoryService.getLogger(ImproveopeAction.class.getName());

  /** 返信用キー */
  private final String RESULT_ON_TOPIC_DETAIL = "resultOnTopicDetail";

  /** 返信用エラーメッセージキー */
  private final String ERROR_MESSAGE_LIST_ON_TOPIC_DETAIL =
    "errmsgsOnTopicDetail";

  /** 返信用 result */
  private Object resultOnTopicDetail;

  /** 返信用異常系のメッセージを格納するリスト */
  private List<String> errmsgListOnTopicDetail;

  /**
   * 通常表示の際の処理を記述します。
   *
   * @param portlet
   * @param context
   * @param rundata
   * @throws Exception
   */
  @Override
  protected void buildNormalContext(VelocityPortlet portlet, Context context,
      RunData rundata) throws Exception {

  }

  /**
   * 最大化表示の際の処理を記述します。
   *
   * @param portlet
   * @param context
   * @param rundata
   */
  @Override
  protected void buildMaximizedContext(VelocityPortlet portlet,
      Context context, RunData rundata) {

    // MODEを取得
    String mode = rundata.getParameters().getString(ALEipConstants.MODE);
    try {
      if (ALEipConstants.MODE_FORM.equals(mode)) {
        doImproveope_topic_form(rundata, context);
      } else if (ALEipConstants.MODE_DETAIL.equals(mode)) {
        doImproveope_topic_detail(rundata, context);
      } else if (ALEipConstants.MODE_LIST.equals(mode)) {
        doImproveope_topic_list(rundata, context);
      } else if (getMode() == null) {
        doImproveope_topic_list(rundata, context);
      }
    } catch (Exception ex) {
      logger.error("Exception", ex);
    }

  }

  /**
   * トピック登録のフォームを表示する.
   *
   * @param rundata
   * @param context
   * @throws Exception
   */
  @Override
  public void doImproveope_topic_form(RunData rundata, Context context)
      throws Exception {
    ImproveopeTopicFormData formData = new ImproveopeTopicFormData();
    formData.initField();
//    formData.loadCategoryList(rundata, context);
    formData.doViewForm(this, rundata, context);
    setTemplate(rundata, "improveope-topic-form");
  }

  /**
   * トピックを登録します。
   *
   * @param rundata
   * @param context
   * @throws Exception
   */
  @Override
  public void doImproveope_topic_insert(RunData rundata, Context context)
      throws Exception {
    ImproveopeTopicFormData formData = new ImproveopeTopicFormData();
    formData.initField();
//    formData.loadCategoryList(rundata, context);
    if (formData.doInsert(this, rundata, context)) {
      // データ登録が成功したとき
      doImproveope_topic_list(rundata, context);
      // JetspeedLink jsLink = JetspeedLinkFactory.getInstance(rundata);
      // rundata.setRedirectURI(jsLink.getPortletById(
      // ALEipUtils.getPortlet(rundata, context).getID()).addQueryData(
      // "eventSubmit_doImproveope_topic_list", "1").toString());
      // rundata.getResponse().sendRedirect(rundata.getRedirectURI());
      // jsLink = null;
    } else {
      setTemplate(rundata, "improveope-topic-form");
    }

  }

  /**
   * トピックを削除します。
   *
   * @param rundata
   * @param context
   * @throws Exception
   */
  @Override
  public void doImproveope_topic_delete(RunData rundata, Context context)
      throws Exception {
    ImproveopeTopicFormData formData = new ImproveopeTopicFormData();
    formData.initField();
    if (formData.doDelete(this, rundata, context)) {
      // データ削除が成功したとき
      doImproveope_topic_list(rundata, context);
      // JetspeedLink jsLink = JetspeedLinkFactory.getInstance(rundata);
      // rundata.setRedirectURI(jsLink.getPortletById(
      // ALEipUtils.getPortlet(rundata, context).getID()).addQueryData(
      // "eventSubmit_doImproveope_topic_list", "1").toString());
      // rundata.getResponse().sendRedirect(rundata.getRedirectURI());
      // jsLink = null;
    }

  }

  /**
   * 返信記事を削除します。
   *
   * @param rundata
   * @param context
   * @throws Exception
   */
  @Override
  public void doImproveope_topic_reply_delete(RunData rundata, Context context)
      throws Exception {
    ImproveopeTopicReplyFormData formData = new ImproveopeTopicReplyFormData();
    formData.initField();
    if (formData.doDelete(this, rundata, context)) {
      // データ削除が成功したとき
      doImproveope_topic_detail(rundata, context);
      // JetspeedLink jsLink = JetspeedLinkFactory.getInstance(rundata);
      // rundata.setRedirectURI(jsLink.getPortletById(
      // ALEipUtils.getPortlet(rundata, context).getID()).addQueryData(
      // "eventSubmit_doImproveope_topic_detail", "1").toString());
      // rundata.getResponse().sendRedirect(rundata.getRedirectURI());
      // jsLink = null;
    }
  }

  /**
   * トピックを削除します。（複数）
   *
   * @param rundata
   * @param context
   * @throws Exception
   */
  @Override
  public void doImproveope_topic_multi_delete(RunData rundata, Context context)
      throws Exception {
    ImproveopeTopicMultiDelete delete = new ImproveopeTopicMultiDelete();
    delete.doMultiAction(this, rundata, context);
    doImproveope_topic_list(rundata, context);
    // JetspeedLink jsLink = JetspeedLinkFactory.getInstance(rundata);
    // rundata.setRedirectURI(jsLink.getPortletById(
    // ALEipUtils.getPortlet(rundata, context).getID()).addQueryData(
    // "eventSubmit_doImproveope_topic_list", "1").toString());
    // rundata.getResponse().sendRedirect(rundata.getRedirectURI());
    // jsLink = null;
  }

  /**
   * トピックを一覧表示します。
   *
   * @param rundata
   * @param context
   * @throws Exception
   */
  @Override
  public void doImproveope_topic_list(RunData rundata, Context context)
      throws Exception {
    ImproveopeTopicSelectData listData = new ImproveopeTopicSelectData();
    listData.initField();
//    listData.loadCategoryList(rundata, context);
    // PSMLからパラメータをロードする
    // 最大表示件数（最大化時）
    listData.setRowsNum(Integer.parseInt(ALEipUtils
      .getPortlet(rundata, context)
      .getPortletConfig()
      .getInitParameter("p1b-rows")));
    listData.doViewList(this, rundata, context);
    setTemplate(rundata, "improveope-topic-list");
  }

  /**
   * トピックを詳細表示します。
   *
   * @param rundata
   * @param context
   * @throws Exception
   */
  @Override
  public void doImproveope_topic_detail(RunData rundata, Context context)
      throws Exception {
    ImproveopeTopicSelectData detailData = new ImproveopeTopicSelectData();
    detailData.initField();
    if (detailData.doViewDetail(this, rundata, context)) {
      if (detailData.showReplyForm()) {
        ImproveopeTopicReplyFormData formData = new ImproveopeTopicReplyFormData();
        formData.initField();
        formData.doViewForm(this, rundata, context);
      }
      setTemplate(rundata, "improveope-topic-detail");
    } else {
      doImproveope_topic_list(rundata, context);
    }
  }

  /**
   * 掲示板で使用したセッション情報を消去する．
   *
   */
  @Override
  public void clearImproveopeSession(RunData rundata, Context context) {
    List<String> list = new ArrayList<String>();
    list.add("entityid");
    list.add("com.aimluck.eip.improveope.ImproveopeTopicSelectDatasort");
    list.add("com.aimluck.eip.improveope.ImproveopeTopicSelectDatasorttype");
    list.add("com.aimluck.eip.improveope.ImproveopeTopicSelectDatasorttype");
    list.add("com.aimluck.eip.improveope.ImproveopeTopicSelectDatafilter");
    list.add("com.aimluck.eip.improveope.ImproveopeTopicSelectDatafiltertype");
    list.add("com.aimluck.eip.improveope.ImproveopeTopicSelectDatasort");
    list.add("com.aimluck.eip.improveope.ImproveopeTopicSelectDatasorttype");
    ALEipUtils.removeTemp(rundata, context, list);

  }

  /**
   * 返信フォームを表示する.
   *
   * @param rundata
   * @param context
   * @throws Exception
   */
  public void doImproveope_reply_form(RunData rundata, Context context)
      throws Exception {
    ImproveopeTopicReplyFormData formData = new ImproveopeTopicReplyFormData();
    formData.initField();
    putData(rundata, context);
    formData.doViewForm(this, rundata, context);
    setTemplate(rundata, "improveope-reply-form");
  }

  /**
   * トピックに返信します。
   *
   * @param rundata
   * @param context
   * @throws Exception
   */
  @Override
  public void doImproveope_topic_reply(RunData rundata, Context context)
      throws Exception {
    ImproveopeTopicReplyFormData formData = new ImproveopeTopicReplyFormData();
    formData.initField();
    if (formData.doInsert(this, rundata, context)) {
      // データ登録が成功したとき
      doImproveope_topic_detail(rundata, context);
    } else {
      setTemplate(rundata, "improveope-reply-form");
    }
  }

  /**
   *
   * @param obj
   */
  @Override
  public void setResultDataOnTopicDetail(Object obj) {
    resultOnTopicDetail = obj;
  }

  /**
   *
   * @param msg
   */
  @Override
  public void addErrorMessagesOnTopicDetail(List<String> msgs) {
    if (errmsgListOnTopicDetail == null) {
      errmsgListOnTopicDetail = new ArrayList<String>();
    }
    errmsgListOnTopicDetail.addAll(msgs);
  }

  /**
   *
   * @param context
   */
  @Override
  public void putDataOnTopicDetail(RunData rundata, Context context) {
    context.put(RESULT_ON_TOPIC_DETAIL, resultOnTopicDetail);
    context.put(ERROR_MESSAGE_LIST_ON_TOPIC_DETAIL, errmsgListOnTopicDetail);

    // For security
    context.put(ALEipConstants.SECURE_ID, rundata.getUser().getTemp(
      ALEipConstants.SECURE_ID));
  }
}
