/*
 * Copyright(C) 2012 - 2013 orinos Co.,Ltd. All rights reserved.
 * http://www.orinos.co.jp/
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

package com.aimluck.eip.improveope.util;

import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;

import javax.imageio.ImageIO;

import org.apache.cayenne.exp.Expression;
import org.apache.cayenne.exp.ExpressionFactory;
import org.apache.jetspeed.om.security.UserIdPrincipal;
import org.apache.jetspeed.services.JetspeedSecurity;
import org.apache.jetspeed.services.logging.JetspeedLogFactoryService;
import org.apache.jetspeed.services.logging.JetspeedLogger;
import org.apache.jetspeed.services.resources.JetspeedResources;
import org.apache.turbine.services.TurbineServices;
import org.apache.turbine.util.RunData;
import org.apache.velocity.context.Context;

import com.aimluck.eip.cayenne.om.portlet.OriMPoint;
import com.aimluck.eip.cayenne.om.portlet.OriTImproveopeApply;
import com.aimluck.eip.cayenne.om.portlet.OriTImproveopeApplyCheck;
import com.aimluck.eip.cayenne.om.portlet.OriTImproveopeApplyMemberMap;
import com.aimluck.eip.cayenne.om.portlet.OriTImproveopeFile;
import com.aimluck.eip.cayenne.om.portlet.OriTImproveopeTopic;
import com.aimluck.eip.cayenne.om.portlet.OriTPointHistory;
import com.aimluck.eip.common.ALActivity;
import com.aimluck.eip.common.ALBaseUser;
import com.aimluck.eip.common.ALDBErrorException;
import com.aimluck.eip.common.ALEipConstants;
import com.aimluck.eip.common.ALEipUser;
import com.aimluck.eip.common.ALPageNotFoundException;
import com.aimluck.eip.fileupload.beans.FileuploadBean;
import com.aimluck.eip.fileupload.beans.FileuploadLiteBean;
import com.aimluck.eip.fileupload.util.FileuploadUtils;
import com.aimluck.eip.mail.util.ALMailUtils;
import com.aimluck.eip.orm.Database;
import com.aimluck.eip.orm.query.SelectQuery;
import com.aimluck.eip.services.accessctl.ALAccessControlFactoryService;
import com.aimluck.eip.services.accessctl.ALAccessControlHandler;
import com.aimluck.eip.services.orgutils.ALOrgUtilsService;
import com.aimluck.eip.services.social.ALActivityService;
import com.aimluck.eip.services.social.model.ALActivityPutRequest;
import com.aimluck.eip.services.storage.ALStorageService;
import com.aimluck.eip.util.ALCellularUtils;
import com.aimluck.eip.util.ALCommonUtils;
import com.aimluck.eip.util.ALEipUtils;
import com.aimluck.eip.whatsnew.util.WhatsNewUtils;
//import com.aimluck.eip.cayenne.om.portlet.EipTMsgboardCategory;
//import com.aimluck.eip.cayenne.om.portlet.EipTMsgboardCategoryMap;
//import com.aimluck.eip.cayenne.om.portlet.EipTMsgboardFile;
//import com.aimluck.eip.cayenne.om.portlet.EipTMsgboardTopic;
//import com.aimluck.eip.cayenne.om.portlet.EipTMsgboardCategory;
//import com.aimluck.eip.cayenne.om.portlet.EipTMsgboardCategoryMap;
//import com.aimluck.eip.cayenne.om.portlet.EipTMsgboardFile;
//import com.aimluck.eip.cayenne.om.portlet.EipTMsgboardTopic;
//import com.aimluck.eip.improveope.ImproveopeCategoryResultData;

/**
 * 掲示板のユーティリティクラス <BR>
 *
 */
public class ImproveopeUtils {

  /** logger */
  private static final JetspeedLogger logger = JetspeedLogFactoryService
    .getLogger(ImproveopeUtils.class.getName());

  /** 所有者の識別子 */
  public static final String OWNER_ID = "ownerid";

  /** 掲示板の添付ファイルを保管するディレクトリの指定 */
  private static final String FOLDER_FILEDIR_MSGBOARD = JetspeedResources
    .getString("aipo.filedir", "");

  /** 掲示板の添付ファイルを保管するディレクトリのカテゴリキーの指定 */
  protected static final String CATEGORY_KEY = JetspeedResources.getString(
    "aipo.improveope.categorykey",
    "");

  /** デフォルトエンコーディングを表わすシステムプロパティのキー */
  public static final String FILE_ENCODING = JetspeedResources.getString(
    "content.defaultencoding",
    "UTF-8");

  /** 全てのユーザーが閲覧／返信可 */
  public static final int ACCESS_PUBLIC_ALL = 0;

  /** 全てのユーザーが閲覧可。ただし返信できるのは所属メンバーのみ。 */
  public static final int ACCESS_PUBLIC_MEMBER = 1;

  /** 所属メンバーのみ閲覧／閲覧可 */
  public static final int ACCESS_SEACRET_MEMBER = 2;

  /** 自分のみ閲覧／返信可 */
  public static final int ACCESS_SEACRET_SELF = 3;

  /** カテゴリの公開／非公開の値（公開） */
  public static final String PUBLIC_FLG_VALUE_PUBLIC = "T";

  /** カテゴリの公開／非公開の値（非公開） */
  public static final String PUBLIC_FLG_VALUE_NONPUBLIC = "F";

  /** カテゴリの状態値（自分のみのカテゴリ） */
  public static final String STAT_VALUE_OWNER = "O";

  /** カテゴリの状態値（共有カテゴリ） */
  public static final String STAT_VALUE_SHARE = "S";

  /** カテゴリの状態値（公開カテゴリ） */
  public static final String STAT_VALUE_ALL = "A";

  public static final String MSGBOARD_PORTLET_NAME = "Improveope";

  /** 検索キーワード変数の識別子 */
  public static final String TARGET_KEYWORD = "keyword";

  /** パラメータリセットの識別子 */
  private static final String RESET_FLAG = "reset_params";

  /** ポイントタイプ 投稿*/
  public static final String POINT_TYPE_T = "T";
  /** ポイントタイプ 投稿コメント*/
  public static final String POINT_TYPE_C = "C";
  /** ポイントタイプ 申請*/
  public static final String POINT_TYPE_A = "A";
  /** ポイントタイプ 評価*/
  public static final String POINT_TYPE_H = "H";
  /** ポイントタイプ 採用*/
  public static final String POINT_TYPE_P = "P";
  /** ポイントタイプ 最終評価*/
  public static final String POINT_TYPE_E = "E";

  public static String[] pointType = { "T","C","A","H","P","E" };

  /**
   * トピックオブジェクトモデルを取得します。 <BR>
   *
   * @param rundata
   * @param context
   * @param isJoin
   *          カテゴリテーブルをJOINするかどうか
   * @return
   */
  public static OriTImproveopeTopic getOriTImproveopeParentTopic(RunData rundata,
      Context context, boolean isJoin) throws ALPageNotFoundException,
      ALDBErrorException {
    String topicid =
      ALEipUtils.getTemp(rundata, context, ALEipConstants.ENTITY_ID);
    try {
      if (topicid == null || Integer.valueOf(topicid) == null) {
        // トピック ID が空の場合
        logger.debug("[ImproveopeTopic] Empty ID...");
        throw new ALPageNotFoundException();
      }

      int userid = ALEipUtils.getUserId(rundata);

      SelectQuery<OriTImproveopeTopic> query =
        Database.query(OriTImproveopeTopic.class);
      Expression exp1 =
        ExpressionFactory.matchDbExp(
        		OriTImproveopeTopic.TOPIC_ID_PK_COLUMN,
          Integer.valueOf(topicid));
      query.setQualifier(exp1);
      Expression exp2 =
        ExpressionFactory.matchExp(
        		OriTImproveopeTopic.PARENT_ID_PROPERTY,
          Integer.valueOf(0));
      query.andQualifier(exp2);
      query.distinct(true);

      List<OriTImproveopeTopic> topics = query.fetchList();
      if (topics == null || topics.size() == 0) {
        // 指定した トピック ID のレコードが見つからない場合
        logger.debug("[ImproveopeTopic] Not found ID...");
        throw new ALPageNotFoundException();
      }

      OriTImproveopeTopic topic = topics.get(0);

      // アクセス権限チェック
//      EipTMsgboardCategory category = topic.getEipTMsgboardCategory();
//      boolean accessible = false;
//      if (category.getPublicFlag().equals("T")) {
//        accessible = true;
//      } else {
//        @SuppressWarnings("unchecked")
//        List<EipTMsgboardCategoryMap> maps =
//          category.getEipTMsgboardCategoryMaps();
//        for (EipTMsgboardCategoryMap map : maps) {
//          if (map.getUserId().equals(Integer.valueOf(userid))) {
//            accessible = true;
//            break;
//          }
//        }
//      }
//      if (!accessible) {
//        ALEipUtils.redirectPermissionError(rundata);
//      }

      return topic;
    } catch (ALPageNotFoundException pageNotFound) {
      // logger.error("[ImproveopeUtils]", pageNotFound);
      throw pageNotFound;
    } catch (Exception ex) {
      logger.error("[ImproveopeUtils]", ex);
      throw new ALDBErrorException();

    }
  }

  /**
   * 返信記事オブジェクトモデルを取得します。 <BR>
   *
   * @param rundata
   * @param context
   * @param isSuperUser
   *          カテゴリテーブルをJOINするかどうか
   * @return
   */
  public static OriTImproveopeTopic getOriTImproveopeTopicReply(RunData rundata,
      Context context, String topicid, boolean isSuperUser)
      throws ALPageNotFoundException, ALDBErrorException {
    try {
      if (topicid == null || Integer.valueOf(topicid) == null) {
        // トピック ID が空の場合
        logger.debug("[ImproveopeTopic] Empty ID...");
        throw new ALPageNotFoundException();
      }

      SelectQuery<OriTImproveopeTopic> query =
        Database.query(OriTImproveopeTopic.class);
      Expression exp1 =
        ExpressionFactory.matchDbExp(
        		OriTImproveopeTopic.TOPIC_ID_PK_COLUMN,
          Integer.valueOf(topicid));
      query.setQualifier(exp1);

      if (!isSuperUser) {
        Expression exp2 =
          ExpressionFactory.matchExp(
        		  OriTImproveopeTopic.OWNER_ID_PROPERTY,
            Integer.valueOf(ALEipUtils.getUserId(rundata)));
        query.andQualifier(exp2);
      }

      List<OriTImproveopeTopic> topics = query.fetchList();
      if (topics == null || topics.size() == 0) {
        // 指定した トピック ID のレコードが見つからない場合
        logger.debug("[ImproveopeTopic] Not found ID...");
        throw new ALPageNotFoundException();
      }
      return topics.get(0);
    } catch (Exception ex) {
      logger.error("[ImproveopeUtils]", ex);
      throw new ALDBErrorException();

    }
  }

  /**
   * ファイルオブジェクトモデルを取得します。 <BR>
   *
   * @param rundata
   * @param context
   * @return
   */
  public static OriTImproveopeFile getOriTImproveopeFile(RunData rundata)
      throws ALPageNotFoundException, ALDBErrorException {
    try {
      int attachmentIndex =
        rundata.getParameters().getInt("attachmentIndex", -1);
      if (attachmentIndex < 0) {
        // ID が空の場合
        logger.debug("[ImproveopeUtils] Empty ID...");
        throw new ALPageNotFoundException();

      }

      SelectQuery<OriTImproveopeFile> query =
        Database.query(OriTImproveopeFile.class);
      Expression exp =
        ExpressionFactory.matchDbExp(
        		OriTImproveopeFile.FILE_ID_PK_COLUMN,
          Integer.valueOf(attachmentIndex));
      query.andQualifier(exp);

      List<OriTImproveopeFile> files = query.fetchList();
      if (files == null || files.size() == 0) {
        // 指定した ID のレコードが見つからない場合
        logger.debug("[ImproveopeUtils] Not found ID...");
        throw new ALPageNotFoundException();
      }
      return files.get(0);
    } catch (Exception ex) {
      logger.error("[ImproveopeUtils]", ex);
      throw new ALDBErrorException();
    }
  }

  /**
   * トピックオブジェクトモデルを取得します。 <BR>
   *
   * @param rundata
   * @param context
   * @param isJoin
   *          カテゴリテーブルをJOINするかどうか
   * @return
   */
  public static List<OriTImproveopeTopic> getEipTMsgboardTopicList(
      RunData rundata, Context context, boolean isJoin)
      throws ALPageNotFoundException, ALDBErrorException {
    String topicid =
      ALEipUtils.getTemp(rundata, context, ALEipConstants.ENTITY_ID);
    try {
      if (topicid == null || Integer.valueOf(topicid) == null) {
        // トピック ID が空の場合
        logger.debug("[ImproveopeTopic] Empty ID...");
        throw new ALPageNotFoundException();
      }

      SelectQuery<OriTImproveopeTopic> query =
        Database.query(OriTImproveopeTopic.class);
      Expression exp001 =
        ExpressionFactory.matchExp(
        		OriTImproveopeTopic.PARENT_ID_PROPERTY,
          Integer.valueOf(topicid));

      // アクセス制御
      Expression exp01 =
        ExpressionFactory.matchDbExp(
        		OriTImproveopeTopic.TOPIC_ID_PK_COLUMN,
          Integer.valueOf(topicid));
//      Expression exp11 =
//        ExpressionFactory.matchExp(
//        		OriTImproveopeTopic.EIP_TMSGBOARD_CATEGORY_PROPERTY
//            + "."
//            + OriTImproveopeTopic.PUBLIC_FLAG_PROPERTY,
//          "T");
//      Expression exp21 =
//        ExpressionFactory.matchExp(
//          EipTMsgboardTopic.EIP_TMSGBOARD_CATEGORY_PROPERTY
//            + "."
//            + EipTMsgboardCategory.PUBLIC_FLAG_PROPERTY,
//          "F");
//      Expression exp22 =
//        ExpressionFactory.matchExp(
//          EipTMsgboardTopic.EIP_TMSGBOARD_CATEGORY_PROPERTY
//            + "."
//            + EipTMsgboardCategory.EIP_TMSGBOARD_CATEGORY_MAPS_PROPERTY
//            + "."
//            + EipTMsgboardCategoryMap.USER_ID_PROPERTY,
//          Integer.valueOf(ALEipUtils.getUserId(rundata)));
//      query.setQualifier((exp01.andExp(exp11.orExp(exp21.andExp(exp22))))
//        .orExp(exp001));
      query.distinct(true);

      List<OriTImproveopeTopic> topics = query.fetchList();
      if (topics == null || topics.size() == 0) {
        // 指定した トピック ID のレコードが見つからない場合
        logger.debug("[ImproveopeTopic] Not found ID...");
        throw new ALPageNotFoundException();
      }
      return topics;
    } catch (Exception ex) {
      logger.error("[ImproveopeUtils]", ex);
      throw new ALDBErrorException();

    }
  }

  /**
   * トピックオブジェクトモデルを取得します。 <BR>
   *
   * @param rundata
   * @param context
   * @param isSuperUser
   *          カテゴリテーブルをJOINするかどうか
   * @return
   */
  public static List<OriTImproveopeTopic> getOriTImproveopeTopicListToDeleteTopic(
      RunData rundata, Context context, boolean isSuperUser)
      throws ALPageNotFoundException, ALDBErrorException {
    String topicid =
      ALEipUtils.getTemp(rundata, context, ALEipConstants.ENTITY_ID);
    try {
      if (topicid == null || Integer.valueOf(topicid) == null) {
        // トピック ID が空の場合
        logger.debug("[ImproveopeTopic] Empty ID...");
        throw new ALPageNotFoundException();
      }

      int userid = ALEipUtils.getUserId(rundata);

      SelectQuery<OriTImproveopeTopic> query =
        Database.query(OriTImproveopeTopic.class);

      Expression exp01 =
        ExpressionFactory.matchDbExp(OriTImproveopeTopic.OWNER_ID_COLUMN, Integer
          .valueOf(userid));
      Expression exp02 =
        ExpressionFactory.matchDbExp(
        		OriTImproveopeTopic.TOPIC_ID_PK_COLUMN,
          Integer.valueOf(topicid));
      Expression exp03 =
        ExpressionFactory.matchExp(
        		OriTImproveopeTopic.PARENT_ID_PROPERTY,
          Integer.valueOf(topicid));

      if (isSuperUser) {
        query.andQualifier((exp02).orExp(exp03));
      } else {
        query.andQualifier((exp01.andExp(exp02)).orExp(exp03));
      }

      List<OriTImproveopeTopic> topics = query.fetchList();
      if (topics == null || topics.size() == 0) {
        // 指定した トピック ID のレコードが見つからない場合
        logger.debug("[ImproveopeTopic] Not found ID...");
        throw new ALPageNotFoundException();
      }

      boolean isdelete = false;
      int size = topics.size();
      for (int i = 0; i < size; i++) {
    	  OriTImproveopeTopic topic = topics.get(i);
        if (topic.getOwnerId().intValue() == userid || isSuperUser) {
          isdelete = true;
          break;
        }
      }
      if (!isdelete) {
        // 指定した トピック ID のレコードが見つからない場合
        logger.debug("[ImproveopeTopic] Not found ID...");
        throw new ALPageNotFoundException();
      }

      return topics;
    } catch (Exception ex) {
      logger.error("[ImproveopeUtils]", ex);
      throw new ALDBErrorException();

    }
  }

  /**
   * カテゴリオブジェクトモデルを取得します。 <BR>
   *
   * @param rundata
   * @param context
   * @return
   */
//  public static EipTMsgboardCategory getEipTMsgboardCategory(RunData rundata,
//      Context context, boolean ownerOnly) throws ALPageNotFoundException,
//      ALDBErrorException {
//    String categoryid =
//      ALEipUtils.getTemp(rundata, context, ALEipConstants.ENTITY_ID);
//    try {
//      if (categoryid == null || Integer.valueOf(categoryid) == null) {
//        // カテゴリ IDが空の場合
//        logger.debug("[ImproveopeCategory] Empty ID...");
//        throw new ALPageNotFoundException();
//      }
//
//      SelectQuery<EipTMsgboardCategory> query =
//        Database.query(EipTMsgboardCategory.class);
//
//      Expression exp1 =
//        ExpressionFactory.matchDbExp(
//          EipTMsgboardCategory.CATEGORY_ID_PK_COLUMN,
//          Integer.valueOf(categoryid));
//      query.setQualifier(exp1);
//      Expression exp2 =
//        ExpressionFactory.noMatchDbExp(
//          EipTMsgboardCategory.TURBINE_USER_PROPERTY
//            + "."
//            + TurbineUser.USER_ID_PK_COLUMN,
//          Integer.valueOf(0));
//      query.andQualifier(exp2);
//      if (ownerOnly) {
//        /*
//         * Expression exp3 = ExpressionFactory.matchDbExp(
//         * EipTMsgboardCategory.TURBINE_USER_PROPERTY + "." +
//         * TurbineUser.USER_ID_PK_COLUMN, Integer.valueOf(ALEipUtils
//         * .getUserId(rundata))); query.andQualifier(exp3);
//         */
//      }
//
//      // アクセス制御
//
//      int loginUserId = ALEipUtils.getUserId(rundata);
//
//      ALAccessControlFactoryService aclservice =
//        (ALAccessControlFactoryService) ((TurbineServices) TurbineServices
//          .getInstance())
//          .getService(ALAccessControlFactoryService.SERVICE_NAME);
//      ALAccessControlHandler aclhandler = aclservice.getAccessControlHandler();
//      boolean hasAclviewOther =
//        aclhandler.hasAuthority(
//          loginUserId,
//          ALAccessControlConstants.POERTLET_FEATURE_MSGBOARD_CATEGORY_OTHER,
//          ALAccessControlConstants.VALUE_ACL_LIST);
//
//      Expression exp01 =
//        ExpressionFactory.matchExp(
//          EipTMsgboardCategory.PUBLIC_FLAG_PROPERTY,
//          "T");
//      Expression exp02 =
//        ExpressionFactory.matchExp(
//          EipTMsgboardCategory.EIP_TMSGBOARD_CATEGORY_MAPS_PROPERTY
//            + "."
//            + EipTMsgboardCategoryMap.STATUS_PROPERTY,
//          "O");
//      Expression exp03 =
//        ExpressionFactory.matchExp(
//          EipTMsgboardCategory.EIP_TMSGBOARD_CATEGORY_MAPS_PROPERTY
//            + "."
//            + EipTMsgboardCategoryMap.STATUS_PROPERTY,
//          "A");
//      Expression exp11 =
//        ExpressionFactory.matchExp(
//          EipTMsgboardCategory.PUBLIC_FLAG_PROPERTY,
//          "F");
//      Expression exp12 =
//        ExpressionFactory.matchExp(
//          EipTMsgboardCategory.EIP_TMSGBOARD_CATEGORY_MAPS_PROPERTY
//            + "."
//            + EipTMsgboardCategoryMap.USER_ID_PROPERTY,
//          Integer.valueOf(loginUserId));
//
//      if (!hasAclviewOther) {
//        query.andQualifier((exp01.andExp(exp02.orExp(exp03))).orExp(exp11
//          .andExp(exp12)));
//      } else {
//        query.andQualifier((exp01.andExp(exp02.orExp(exp03))).orExp(exp11
//          .andExp(exp02.orExp(exp03))));
//      }
//      query.distinct(true);
//
//      List<EipTMsgboardCategory> categories = query.fetchList();
//      if (categories == null || categories.size() == 0) {
//        // 指定したカテゴリ IDのレコードが見つからない場合
//        logger.debug("[ImproveopeUtils] Not found ID...");
//        throw new ALPageNotFoundException();
//      }
//      return categories.get(0);
//    } catch (Exception ex) {
//      logger.error("[ImproveopeUtils]", ex);
//      throw new ALDBErrorException();
//
//    }
//  }

  /**
   * <BR>
   *
   * @param rundata
   * @param context
   * @return
   */
//  public static List<Integer> getWhatsNewInsertList(RunData rundata,
//      int categoryid, String is_public) throws ALPageNotFoundException,
//      ALDBErrorException {
//
//    int userid = ALEipUtils.getUserId(rundata);
//    List<ALEipUser> result = new ArrayList<ALEipUser>();
//
//    if ("F".equals(is_public)) {
//      try {
//
//        SelectQuery<EipTMsgboardCategoryMap> query =
//          Database.query(EipTMsgboardCategoryMap.class);
//        query.select(EipTMsgboardCategoryMap.USER_ID_COLUMN);
//
//        Expression exp1 =
//          ExpressionFactory.matchExp(
//            EipTMsgboardCategoryMap.CATEGORY_ID_PROPERTY,
//            Integer.valueOf(categoryid));
//        query.setQualifier(exp1);
//
//        // アクセス制御
//        Expression exp11 =
//          ExpressionFactory.matchExp(
//            EipTMsgboardCategoryMap.EIP_TMSGBOARD_CATEGORY_PROPERTY
//              + "."
//              + EipTMsgboardCategory.PUBLIC_FLAG_PROPERTY,
//            PUBLIC_FLG_VALUE_PUBLIC);
//        Expression exp12 =
//          ExpressionFactory.matchExp(
//            EipTMsgboardCategoryMap.EIP_TMSGBOARD_CATEGORY_PROPERTY
//              + "."
//              + EipTMsgboardCategory.PUBLIC_FLAG_PROPERTY,
//            PUBLIC_FLG_VALUE_NONPUBLIC);
//        Expression exp13 =
//          ExpressionFactory.matchExp(
//            EipTMsgboardCategoryMap.STATUS_PROPERTY,
//            STAT_VALUE_SHARE);
//        Expression exp14 =
//          ExpressionFactory.matchExp(
//            EipTMsgboardCategoryMap.STATUS_PROPERTY,
//            STAT_VALUE_OWNER);
//        query.andQualifier(exp11.orExp(exp12.andExp(exp13)).orExp(
//          exp12.andExp(exp14)));
//        query.distinct(true);
//
//        List<EipTMsgboardCategoryMap> uids = query.fetchList();
//        List<Integer> userIds = new ArrayList<Integer>();
//        if (uids != null && uids.size() != 0) {
//          int size = uids.size();
//          for (int i = 0; i < size; i++) {
//            EipTMsgboardCategoryMap uid = uids.get(i);
//            Integer id = uid.getUserId();
//            if (id.intValue() != userid) {
//              result.add(ALEipUtils.getALEipUser(id.intValue()));
//              userIds.add(id.intValue());
//            }
//          }
//        }
//        return userIds;
//
//        /* メンバー全員に新着ポートレット登録 */
//        /*-
//        ALAccessControlFactoryService aclservice =
//          (ALAccessControlFactoryService) ((TurbineServices) TurbineServices
//            .getInstance())
//            .getService(ALAccessControlFactoryService.SERVICE_NAME);
//        ALAccessControlHandler aclhandler =
//          aclservice.getAccessControlHandler();
//        List<Integer> userIds =
//          aclhandler.getAcceptUserIdsInListExceptLoginUser(
//            ALEipUtils.getUserId(rundata),
//            ALAccessControlConstants.POERTLET_FEATURE_MSGBOARD_TOPIC,
//            ALAccessControlConstants.VALUE_ACL_DETAIL,
//            result);
//
//        return userIds;
//         */
//      } catch (Exception ex) {
//        logger.error("[ImproveopeUtils]", ex);
//        throw new ALDBErrorException();
//      }
//    } else {
//      /* 自分以外の全員に新着ポートレット登録 */
//      ALAccessControlFactoryService aclservice =
//        (ALAccessControlFactoryService) ((TurbineServices) TurbineServices
//          .getInstance())
//          .getService(ALAccessControlFactoryService.SERVICE_NAME);
//      ALAccessControlHandler aclhandler = aclservice.getAccessControlHandler();
//      List<Integer> userIds =
//        aclhandler.getAcceptUserIdsExceptLoginUser(
//          ALEipUtils.getUserId(rundata),
//          ALAccessControlConstants.POERTLET_FEATURE_MSGBOARD_TOPIC,
//          ALAccessControlConstants.VALUE_ACL_DETAIL);
//      return userIds;
//
//    }
//  }

//  public static List<ImproveopeCategoryResultData> loadCategoryList(
//      RunData rundata) {
//    // カテゴリ一覧
//    List<ImproveopeCategoryResultData> categoryList =
//      new ArrayList<ImproveopeCategoryResultData>();
//    try {
//      SelectQuery<EipTMsgboardCategory> query =
//        Database.query(EipTMsgboardCategory.class);
//
//      // アクセス制御
//      Expression exp01 =
//        ExpressionFactory.matchExp(
//          EipTMsgboardCategory.PUBLIC_FLAG_PROPERTY,
//          ImproveopeUtils.PUBLIC_FLG_VALUE_PUBLIC);
//      Expression exp02 =
//        ExpressionFactory.matchExp(
//          EipTMsgboardCategory.EIP_TMSGBOARD_CATEGORY_MAPS_PROPERTY
//            + "."
//            + EipTMsgboardCategoryMap.STATUS_PROPERTY,
//          ImproveopeUtils.STAT_VALUE_OWNER);
//      Expression exp03 =
//        ExpressionFactory.matchExp(
//          EipTMsgboardCategory.EIP_TMSGBOARD_CATEGORY_MAPS_PROPERTY
//            + "."
//            + EipTMsgboardCategoryMap.STATUS_PROPERTY,
//          ImproveopeUtils.STAT_VALUE_ALL);
//      Expression exp11 =
//        ExpressionFactory.matchExp(
//          EipTMsgboardCategory.PUBLIC_FLAG_PROPERTY,
//          ImproveopeUtils.PUBLIC_FLG_VALUE_NONPUBLIC);
//      Expression exp12 =
//        ExpressionFactory.matchExp(
//          EipTMsgboardCategory.EIP_TMSGBOARD_CATEGORY_MAPS_PROPERTY
//            + "."
//            + EipTMsgboardCategoryMap.USER_ID_PROPERTY,
//          Integer.valueOf(ALEipUtils.getUserId(rundata)));
//      query.setQualifier((exp01.andExp(exp02.orExp(exp03))).orExp(exp11
//        .andExp(exp12)));
//      query.orderAscending(EipTMsgboardCategory.CATEGORY_NAME_PROPERTY);
//      query.distinct(true);
//
//      ImproveopeCategoryResultData otherRd = null;
//
//      List<EipTMsgboardCategory> aList = query.fetchList();
//      int size = aList.size();
//      for (int i = 0; i < size; i++) {
//        EipTMsgboardCategory record = aList.get(i);
//        ImproveopeCategoryResultData rd = new ImproveopeCategoryResultData();
//        rd.initField();
//        rd.setCategoryId(record.getCategoryId().longValue());
//        rd.setCategoryName(record.getCategoryName());
//        if (record.getCategoryId().longValue() == 1) {
//          // カテゴリ「その他」は最後に追加するため，ここではリストに追加しない．
//          otherRd = rd;
//        } else {
//          categoryList.add(rd);
//        }
//      }
//      if (otherRd != null) {
//        categoryList.add(otherRd);
//      }
//    } catch (Exception ex) {
//      logger.error("Exception", ex);
//      return null;
//    }
//    return categoryList;
//  }

  /**
   * 添付ファイルを取得します。
   *
   * @param uid
   * @return
   */
  public static ArrayList<FileuploadLiteBean> getFileuploadList(RunData rundata) {
    String[] fileids =
      rundata
        .getParameters()
        .getStrings(FileuploadUtils.KEY_FILEUPLOAD_ID_LIST);
    if (fileids == null) {
      return null;
    }

    ArrayList<String> hadfileids = new ArrayList<String>();
    ArrayList<String> newfileids = new ArrayList<String>();

    for (int j = 0; j < fileids.length; j++) {
      if (fileids[j].trim().startsWith("s")) {
        hadfileids.add(fileids[j].trim().substring(1));
      } else {
        newfileids.add(fileids[j].trim());
      }
    }

    ArrayList<FileuploadLiteBean> fileNameList =
      new ArrayList<FileuploadLiteBean>();
    FileuploadLiteBean filebean = null;

    // 新規にアップロードされたファイルの処理
    if (newfileids.size() > 0) {
      String folderName =
        rundata.getParameters().getString(
          FileuploadUtils.KEY_FILEUPLOAD_FODLER_NAME);
      if (folderName == null || folderName.equals("")) {
        return null;
      }

      for (String newfileid : newfileids) {
        if ("".equals(newfileid)) {
          continue;
        }
        int fileid = 0;
        try {
          fileid = Integer.parseInt(newfileid);
        } catch (Exception e) {
          continue;
        }

        if (fileid == 0) {
          filebean = new FileuploadLiteBean();
          filebean.initField();
          filebean.setFolderName("photo");
          filebean.setFileName("以前の写真ファイル");
          fileNameList.add(filebean);
        } else {
          BufferedReader reader = null;
          try {
            reader =
              new BufferedReader(new InputStreamReader(ALStorageService
                .getFile(
                  FileuploadUtils.FOLDER_TMP_FOR_ATTACHMENT_FILES,
                  ALEipUtils.getUserId(rundata)
                    + ALStorageService.separator()
                    + folderName,
                  fileid + FileuploadUtils.EXT_FILENAME), FILE_ENCODING));
            String line = reader.readLine();
            if (line == null || line.length() <= 0) {
              continue;
            }
            filebean = new FileuploadLiteBean();
            filebean.initField();
            filebean.setFolderName(newfileid);
            filebean.setFileId(fileid);
            filebean.setFileName(line);
            fileNameList.add(filebean);
          } catch (Exception e) {
            logger.error("Exception", e);
          } finally {
            try {
              reader.close();
            } catch (Exception e) {
              logger.error("Exception", e);
            }
          }
        }
      }
    }

    // すでにあるファイルの処理
    if (hadfileids.size() > 0) {
      ArrayList<Integer> hadfileidsValue = new ArrayList<Integer>();
      for (String hadfileid : hadfileids) {
        int fileid = 0;
        try {
          fileid = Integer.parseInt(hadfileid);
          hadfileidsValue.add(fileid);
        } catch (Exception e) {
          continue;
        }
      }

      try {
        SelectQuery<OriTImproveopeFile> reqquery =
          Database.query(OriTImproveopeFile.class);
        Expression reqexp1 =
          ExpressionFactory.inDbExp(
        		  OriTImproveopeFile.FILE_ID_PK_COLUMN,
            hadfileidsValue);
        reqquery.setQualifier(reqexp1);
        List<OriTImproveopeFile> requests = reqquery.fetchList();
        for (OriTImproveopeFile file : requests) {
          filebean = new FileuploadBean();
          filebean.initField();
          filebean.setFileId(file.getFileId());
          filebean.setFileName(file.getFileName());
          filebean.setFlagNewFile(false);
          fileNameList.add(filebean);
        }
      } catch (Exception ex) {
        logger.error("[BlogUtils] Exception.", ex);
      }
    }
    return fileNameList;
  }

  public static boolean insertFileDataDelegate(RunData rundata,
      Context context, OriTImproveopeTopic topic,
      List<FileuploadLiteBean> fileuploadList, String folderName,
      List<String> msgList) {
    if (fileuploadList == null || fileuploadList.size() <= 0) {
      fileuploadList = new ArrayList<FileuploadLiteBean>();
    }

    int uid = ALEipUtils.getUserId(rundata);
    String orgId = Database.getDomainName();

    List<Integer> hadfileids = new ArrayList<Integer>();
    for (FileuploadLiteBean file : fileuploadList) {
      if (!file.isNewFile()) {
        hadfileids.add(file.getFileId());
      }
    }

    SelectQuery<OriTImproveopeFile> dbquery =
      Database.query(OriTImproveopeFile.class);
    dbquery.andQualifier(ExpressionFactory.matchDbExp(
    		OriTImproveopeFile.ORI_TIMPROVEOPE_TOPIC_PROPERTY,
      topic.getTopicId()));
    List<OriTImproveopeFile> existsFiles = dbquery.fetchList();
    List<OriTImproveopeFile> delFiles = new ArrayList<OriTImproveopeFile>();
    for (OriTImproveopeFile file : existsFiles) {
      if (!hadfileids.contains(file.getFileId())) {
        delFiles.add(file);
      }
    }

    // ローカルファイルに保存されているファイルを削除する．
    if (delFiles.size() > 0) {
      int delsize = delFiles.size();
      for (int i = 0; i < delsize; i++) {
        ALStorageService.deleteFile(ImproveopeUtils.getSaveDirPath(orgId, uid)
          + (delFiles.get(i)).getFilePath());
      }
      // データベースから添付ファイルのデータ削除
      Database.deleteAll(delFiles);
    }

    // ファイル追加処理
    try {
      for (FileuploadLiteBean filebean : fileuploadList) {
        if (!filebean.isNewFile()) {
          continue;
        }

        // サムネイル処理
        String[] acceptExts = ImageIO.getWriterFormatNames();
        byte[] fileThumbnail =
          FileuploadUtils.getBytesShrinkFilebean(
            orgId,
            folderName,
            uid,
            filebean,
            acceptExts,
            FileuploadUtils.DEF_THUMBNAIL_WIDTH,
            FileuploadUtils.DEF_THUMBNAIL_HEIGHT,
            msgList);

        String filename = "0_" + String.valueOf(System.nanoTime());

        // 新規オブジェクトモデル
        OriTImproveopeFile file = Database.create(OriTImproveopeFile.class);
        // 所有者
        file.setOwnerId(Integer.valueOf(uid));
        // トピックID
        //file.OriTImproveopeTopic(topic);
        file.setOriTImproveopeTopic(topic);
        // ファイル名
        file.setFileName(filebean.getFileName());
        // ファイルパス
        file.setFilePath(ImproveopeUtils.getRelativePath(filename));
        // サムネイル画像
        if (fileThumbnail != null) {
          file.setFileThumbnail(fileThumbnail);
        }
        // 作成日
        file.setCreateDate(Calendar.getInstance().getTime());
        // 更新日
        file.setUpdateDate(Calendar.getInstance().getTime());

        // ファイルの移動
        ALStorageService.copyTmpFile(uid, folderName, String.valueOf(filebean
          .getFileId()), FOLDER_FILEDIR_MSGBOARD, CATEGORY_KEY
          + ALStorageService.separator()
          + uid, filename);
      }

      // 添付ファイル保存先のフォルダを削除
      ALStorageService.deleteTmpFolder(uid, folderName);
    } catch (Exception e) {
      Database.rollback();
      logger.error("Exception", e);
      return false;
    }
    return true;
  }

  /**
   * ユーザ毎のルート保存先（絶対パス）を取得します。
   *
   * @param uid
   * @return
   */
  public static String getSaveDirPath(String orgId, int uid) {
    return ALStorageService.getDocumentPath(
      FOLDER_FILEDIR_MSGBOARD,
      CATEGORY_KEY + ALStorageService.separator() + uid);
  }

  /**
   * ユーザ毎の保存先（相対パス）を取得します。
   *
   * @param uid
   * @return
   */
  public static String getRelativePath(String fileName) {
    return new StringBuffer().append("/").append(fileName).toString();
  }

  @Deprecated
  public static void shiftWhatsNewReadFlag(RunData rundata, int entityid) {
    int uid = ALEipUtils.getUserId(rundata);
    boolean isPublic = false;

    SelectQuery<OriTImproveopeTopic> query =
      Database.query(OriTImproveopeTopic.class);
    Expression exp =
      ExpressionFactory
        .matchExp(OriTImproveopeTopic.PARENT_ID_PROPERTY, entityid);
    query.setQualifier(exp);
    query.select(OriTImproveopeTopic.TOPIC_ID_PK_COLUMN);
    query.distinct(true);

    List<OriTImproveopeTopic> topics = query.fetchList();

    query = Database.query(OriTImproveopeTopic.class);
    exp =
      ExpressionFactory.matchDbExp(
    		  OriTImproveopeTopic.TOPIC_ID_PK_COLUMN,
        entityid);
    query.setQualifier(exp);

    List<OriTImproveopeTopic> topic = query.fetchList();
//    if (topic != null
//      && ((topic.get(0)).getEipTMsgboardCategory().getPublicFlag().equals("T"))) {
//      isPublic = true;
//    }

    if (topics != null) {

      int size = topics.size();
      Integer _id = null;

      for (int i = 0; i < size; i++) {
      	OriTImproveopeTopic record = topics.get(i);
        _id = record.getTopicId();
        WhatsNewUtils.shiftWhatsNewReadFlag(
          WhatsNewUtils.WHATS_NEW_TYPE_MSGBOARD_TOPIC,
          _id.intValue(),
          uid);
      }

    WhatsNewUtils.shiftWhatsNewReadFlag(
    WhatsNewUtils.WHATS_NEW_TYPE_MSGBOARD_TOPIC,
    entityid,
    uid);

    }

//
//      if (isPublic) {
//        for (int i = 0; i < size; i++) {
//        	OriTImproveopeTopic record = topics.get(i);
//          _id = record.getTopicId();
//          WhatsNewUtils.shiftWhatsNewReadFlagPublic(
//            WhatsNewUtils.WHATS_NEW_TYPE_MSGBOARD_TOPIC,
//            _id.intValue(),
//            uid);
//        }
//      } else {
//        for (int i = 0; i < size; i++) {
//        	OriTImproveopeTopic record = topics.get(i);
//          _id = record.getTopicId();
//          WhatsNewUtils.shiftWhatsNewReadFlag(
//            WhatsNewUtils.WHATS_NEW_TYPE_MSGBOARD_TOPIC,
//            _id.intValue(),
//            uid);
//        }
//      }
//    }
//    if (isPublic) {
//      WhatsNewUtils.shiftWhatsNewReadFlagPublic(
//        WhatsNewUtils.WHATS_NEW_TYPE_MSGBOARD_TOPIC,
//        entityid,
//        uid);
//    } else {
//      WhatsNewUtils.shiftWhatsNewReadFlag(
//        WhatsNewUtils.WHATS_NEW_TYPE_MSGBOARD_TOPIC,
//        entityid,
//        uid);
//    }

  }

  /**
   * 表示切り替えで指定した検索キーワードを取得する．
   *
   * @param rundata
   * @param context
   * @return
   */
  public static String getTargetKeyword(RunData rundata, Context context) {
    String target_keyword = null;
    String keywordParam = rundata.getParameters().getString(TARGET_KEYWORD);
    target_keyword = ALEipUtils.getTemp(rundata, context, TARGET_KEYWORD);

    if (keywordParam == null && (target_keyword == null)) {
      ALEipUtils.setTemp(rundata, context, TARGET_KEYWORD, "");
      target_keyword = "";
    } else if (keywordParam != null) {
      ALEipUtils.setTemp(rundata, context, TARGET_KEYWORD, keywordParam.trim());
      target_keyword = keywordParam;
    }
    return target_keyword;
  }

  /**
   * 表示切り替えのリセットフラグがあるかを返す．
   *
   * @param rundata
   * @param context
   * @return
   */
  public static boolean hasResetFlag(RunData rundata, Context context) {
    String resetflag = rundata.getParameters().getString(RESET_FLAG);
    return resetflag != null;
  }

  /**
   * フィルターを初期化する．
   *
   * @param rundata
   * @param context
   * @param className
   */
  public static void resetFilter(RunData rundata, Context context,
      String className) {
    ALEipUtils.setTemp(rundata, context, TARGET_KEYWORD, "");
  }

  /**
   * アクセス権限をチェックします。
   *
   * @return
   */
  public static boolean checkPermission(RunData rundata, Context context,
      int defineAclType, String pfeature) {

    if (defineAclType == 0) {
      return true;
    }

    if (pfeature == null || "".equals(pfeature)) {
      return true;
    }

    ALAccessControlFactoryService aclservice =
      (ALAccessControlFactoryService) ((TurbineServices) TurbineServices
        .getInstance()).getService(ALAccessControlFactoryService.SERVICE_NAME);
    ALAccessControlHandler aclhandler = aclservice.getAccessControlHandler();
    boolean hasAuthority =
      aclhandler.hasAuthority(
        ALEipUtils.getUserId(rundata),
        pfeature,
        defineAclType);

    return hasAuthority;
  }

  /**
   * トピックに対する返信数を返します
   *
   * @param topic_id
   * @return
   */
  public static Integer countReply(Integer topic_id) {
    SelectQuery<OriTImproveopeTopic> query =
      Database.query(OriTImproveopeTopic.class);

    Expression exp1 =
      ExpressionFactory
        .matchDbExp(OriTImproveopeTopic.PARENT_ID_COLUMN, topic_id);
    query.setQualifier(exp1);

    return query.getCount();
  }

  public static void createTopicActivity(OriTImproveopeTopic topic,
      String loginName, boolean isNew) {
    createTopicActivity(topic, loginName, null, isNew);
  }

  public static void createTopicActivity(OriTImproveopeTopic topic,
      String loginName, List<String> recipients, boolean isNew) {
    ALActivity RecentActivity =
      ALActivity.getRecentActivity("Improveope", topic.getTopicId(), 0f);
    boolean isDeletePrev =
      RecentActivity != null && RecentActivity.isReplace(loginName);

    String title =
      new StringBuilder("業務提案の掲示板「")
        .append(topic.getTopicName())
        .append("」を")
        .append(isNew ? "作成しました。" : "編集しました。")
        .toString();
    String portletParams =
      new StringBuilder("?template=ImproveopeTopicDetailScreen").append(
        "&entityid=").append(topic.getTopicId()).toString();

    if (recipients != null && recipients.size() > 0) {
      ALActivityService.create(new ALActivityPutRequest()
        .withAppId("Improveope")
        .withUserId(topic.getOwnerId())
        .withLoginName(loginName)
        .withPortletParams(portletParams)
        .withRecipients(recipients)
        .withTitle(title)
        .withPriority(0f)
        .withExternalId(String.valueOf(topic.getTopicId())));
    } else {
      ALActivityService.create(new ALActivityPutRequest()
        .withAppId("Improveope")
        .withLoginName(loginName)
        .withUserId(topic.getOwnerId())
        .withPortletParams(portletParams)
        .withTitle(title)
        .withPriority(0f)
        .withExternalId(String.valueOf(topic.getTopicId())));
    }
    if (isDeletePrev) {
      RecentActivity.Delete();
    }
  }

  /**
   * アクティビティを通知先・社内参加者の「あなた宛のお知らせ」に表示させる（返信用）
   *
   * @param topic
   * @param loginName
   * @param recipients
   */
  public static void createNewTopicActivity(OriTImproveopeTopic topic,
      String loginName, List<String> recipient) {
    ALActivity RecentActivity =
      ALActivity.getRecentActivity("Improveope", topic.getTopicId(), 1f);
    boolean isDeletePrev =
      RecentActivity != null && RecentActivity.isReplace(loginName);

    if (recipient != null) {
      StringBuilder b = new StringBuilder("業務提案の掲示板「");

      b.append(ALCommonUtils.compressString(topic.getTopicName(), 30)).append(
        "」").append("に返信しました。");

      String portletParams =
        new StringBuilder("?template=ImproveopeTopicDetailScreen").append(
          "&entityid=").append(topic.getTopicId()).toString();
      ALActivityService.create(new ALActivityPutRequest()
        .withAppId("Improveope")
        .withUserId(topic.getOwnerId())
        .withLoginName(loginName)
        .withPortletParams(portletParams)
        .withRecipients(recipient)
        .withTitle(b.toString())
        .withPriority(1f)
        .withExternalId(String.valueOf(topic.getTopicId())));
    } else {
      StringBuilder b = new StringBuilder("業務提案の掲示板「");

      b.append(ALCommonUtils.compressString(topic.getTopicName(), 30)).append(
        "」").append("に返信しました。");

      String portletParams =
        new StringBuilder("?template=ImproveopeTopicDetailScreen").append(
          "&entityid=").append(topic.getTopicId()).toString();
      ALActivityService.create(new ALActivityPutRequest()
        .withAppId("Improveope")
        .withUserId(topic.getOwnerId())
        .withLoginName(loginName)
        .withPortletParams(portletParams)
        .withTitle(b.toString())
        .withPriority(1f)
        .withExternalId(String.valueOf(topic.getTopicId())));
    }
    if (isDeletePrev) {
      RecentActivity.Delete();
    }
  }

  public static void createNewCommentActivity(OriTImproveopeTopic topic,
      String loginName) {
    createNewCommentActivity(topic, loginName, null);
  }

  public static void createNewCommentActivity(OriTImproveopeTopic topic,
      String loginName, List<String> recipients) {
    String title =
      new StringBuilder("業務提案の掲示板「")
        .append(ALCommonUtils.compressString(topic.getTopicName(), 30))
        .append("」に")
        .append("返信しました。")
        .toString();
    String portletParams =
      new StringBuilder("?template=ImproveopeTopicDetailScreen").append(
        "&entityid=").append(topic.getTopicId()).toString();

    if (recipients != null && recipients.size() > 0) {
      ALActivityService.create(new ALActivityPutRequest()
        .withAppId("Improveope")
        .withUserId(topic.getOwnerId())
        .withLoginName(loginName)
        .withPortletParams(portletParams)
        .withRecipients(recipients)
        .withTitle(title)
        .withPriority(0f)
        .withExternalId(String.valueOf(topic.getTopicId())));
    } else {
      ALActivityService.create(new ALActivityPutRequest()
        .withUserId(topic.getOwnerId())
        .withAppId("Improveope")
        .withLoginName(loginName)
        .withPortletParams(portletParams)
        .withTitle(title)
        .withPriority(0f)
        .withExternalId(String.valueOf(topic.getTopicId())));
    }
  }

  /**
   * パソコンへ送信するメールの内容を作成する（返信用）．
   *
   * @return
   */
  public static String createReplyMsgForPc(RunData rundata,
		  OriTImproveopeTopic topic, OriTImproveopeTopic parenttopic) {
    boolean enableAsp = JetspeedResources.getBoolean("aipo.asp", false);
    ALEipUser loginUser = null;
    ALBaseUser user = null;

    try {
      loginUser = ALEipUtils.getALEipUser(rundata);
      user =
        (ALBaseUser) JetspeedSecurity.getUser(new UserIdPrincipal(loginUser
          .getUserId()
          .toString()));
    } catch (Exception e) {
      return "";
    }
    String CR = System.getProperty("line.separator");
    StringBuffer body = new StringBuffer("");
    body.append(loginUser.getAliasName().toString());
    if (!"".equals(user.getEmail())) {
      body.append("(").append(user.getEmail()).append(")");
    }
    body.append("さんが業務提案の掲示板").append("に返信しました。").append(CR).append(CR);
    body.append("[タイトル]").append(CR).append(
      parenttopic.getTopicName().toString()).append(CR);

    if (topic.getNote().toString().length() > 0) {
      body
        .append("[返信内容]")
        .append(CR)
        .append(topic.getNote().toString())
        .append(CR);
    }
    body.append(CR);
    body
      .append("[")
      .append(ALOrgUtilsService.getAlias())
      .append("へのアクセス]")
      .append(CR);
    if (enableAsp) {
      body.append("　").append(ALMailUtils.getGlobalurl()).append(CR);
    } else {
      body.append("・社外").append(CR);
      body.append("　").append(ALMailUtils.getGlobalurl()).append(CR);
      body.append("・社内").append(CR);
      body.append("　").append(ALMailUtils.getLocalurl()).append(CR).append(CR);
    }

    body.append("---------------------").append(CR);
    body.append(ALOrgUtilsService.getAlias()).append(CR);

    return body.toString();
  }

  /**
   * 携帯電話へ送信するメールの内容を作成する（返信用）．
   *
   * @return
   */
  public static String createReplyMsgForCellPhone(RunData rundata,
		  OriTImproveopeTopic topic, OriTImproveopeTopic parenttopic, int destUserID) {
    ALEipUser loginUser = null;
    ALBaseUser user = null;
    try {
      loginUser = ALEipUtils.getALEipUser(rundata);
      user =
        (ALBaseUser) JetspeedSecurity.getUser(new UserIdPrincipal(loginUser
          .getUserId()
          .toString()));
    } catch (Exception e) {
      return "";
    }
    String CR = System.getProperty("line.separator");
    StringBuffer body = new StringBuffer("");
    body.append(loginUser.getAliasName().toString());
    if (!"".equals(user.getEmail())) {
      body.append("(").append(user.getEmail()).append(")");
    }
    body.append("さんが業務提案の掲示板").append("に返信しました。").append(CR).append(CR);
    body.append("[タイトル]").append(CR).append(
      parenttopic.getTopicName().toString()).append(CR);
    body.append(CR);

    ALEipUser destUser;
    try {
      destUser = ALEipUtils.getALEipUser(destUserID);
    } catch (ALDBErrorException ex) {
      logger.error("Exception", ex);
      return "";
    }
    body
      .append("[")
      .append(ALOrgUtilsService.getAlias())
      .append("へのアクセス]")
      .append(CR);
    body.append("　").append(ALMailUtils.getGlobalurl()).append("?key=").append(
      ALCellularUtils.getCellularKey(destUser)).append(CR);
    body.append("---------------------").append(CR);
    body.append(ALOrgUtilsService.getAlias()).append(CR);
    return body.toString();
  }

  /**
   * トピックに添付されたすべての添付ファイルを物理削除します。
   *
   * @param topic
   */
  @SuppressWarnings("unchecked")
  public static void deleteAttachmentFiles(OriTImproveopeTopic topic) {
    String orgId = Database.getDomainName();
    List<OriTImproveopeFile> files = topic.getOriTImproveopeFile();
    int uid = topic.getOwnerId();
    for (OriTImproveopeFile file : files) {
      ALStorageService.deleteFile(ImproveopeUtils.getSaveDirPath(orgId, uid)
        + file.getFilePath());
    }
  }

  /**
   * 指定されたユーザが指定カテゴリのトピックに対して返信できるかどうか調べます。
   *
   * @param user_id
   * @param category
   * @return
   */
//  public static boolean hasAuthorityToReply(int user_id,
//      EipTMsgboardCategory category) {
//    if (category.getTurbineUser().getUserId() == user_id) {
//      return true;
//    }
//
//    boolean canAllReply = "T".equals(category.getPublicFlag());
//    List<?> categoryMap = category.getEipTMsgboardCategoryMaps();
//    int mapsize = categoryMap.size();
//    for (int i = 0; i < mapsize; i++) {
//      EipTMsgboardCategoryMap map =
//        (EipTMsgboardCategoryMap) categoryMap.get(i);
//
//      // 全員が返信可能
//      if (canAllReply && "A".equals(map.getStatus())) {
//        return true;
//      } else {
//        // ログインユーザが所属メンバの場合
//        if (map.getUserId().intValue() == user_id) {
//          return true;
//        }
//      }
//    }
//
//    return false;
//  }

  public static Integer getDefaultPoint(String type) {
	  if (type.equals("O")) {
		  return 0;
	  }
	  try {
		  SelectQuery<OriMPoint> query = Database.query(OriMPoint.class);
		  Expression exp =
				  ExpressionFactory.matchExp(OriMPoint.TYPE_PROPERTY, type);
		  query.setQualifier(exp);

		  List<OriMPoint> pointMst = query.fetchList();

		  if (pointMst == null || pointMst.size() <=0) {
			  return 0;
		  }

		  return pointMst.get(0).getPoint();

	  } catch (Exception ex) {
	      logger.error("Exception [getDefaultPoint]", ex);
	      return 0;
	  }
  }
  public static Integer getPointId(String type) {
	  if (type.equals("O")) {
		  return 0;
	  }
	  try {
		  SelectQuery<OriMPoint> query = Database.query(OriMPoint.class);
		  Expression exp =
				  ExpressionFactory.matchExp(OriMPoint.TYPE_PROPERTY, type);
		  query.setQualifier(exp);

		  List<OriMPoint> pointMst = query.fetchList();

		  if (pointMst == null || pointMst.size() <=0) {
			  return 0;
		  }

		  return pointMst.get(0).getPointId();

	  } catch (Exception ex) {
	      logger.error("Exception [getDefaultPoint]", ex);
	      return 0;
	  }
  }


  public static OriMPoint getOriMPoint(RunData rundata, Context context)
		  throws ALPageNotFoundException {
    String pid = ALEipUtils.getTemp(rundata, context, ALEipConstants.ENTITY_ID);
    try {
      if (pid == null || pid == "") {
        // POINT IDが空の場合
        logger.debug("[EventUtils] Empty ID...");
        return null;
      }

      SelectQuery<OriMPoint> query = Database.query(OriMPoint.class);
      Expression exp =
        ExpressionFactory.matchDbExp(OriMPoint.POINT_ID_PK_COLUMN, Integer.valueOf(pid));
      query.setQualifier(exp);

      List<OriMPoint> pointMst = query.fetchList();

      if (pointMst == null || pointMst.size() == 0) {
        // 指定したイベント IDのレコードが見つからない場合
        logger.debug("[getOriMPoint] Not found ID...");
        return null;
      }

      return pointMst.get(0);

    } catch (Exception ex) {
      logger.error("Exception [getOriMPoint]", ex);
      return null;
    }
  }

  /**
   * 採用ポイント付与
   * @param apply
   * @param point
   */
  public static void grantAdoptPoint(OriTImproveopeApply apply, int point) {

    List<OriTImproveopeApplyMemberMap> map = ImproveopeApplyUtils.getOriTImproveopeApplyMemberMap(apply);
    for (OriTImproveopeApplyMemberMap user : map) {

      OriTPointHistory history = ImproveopeUtils.getOriTPointHistoryAdopt(apply, user.getUserId());
      if (history == null) {
        history = Database.create(OriTPointHistory.class);
      }

      history.setApplyId(apply.getApplyId());
      history.setUserId(user.getUserId());
      history.setPoint(point);
      history.setPointId(ImproveopeUtils.getPointId(ImproveopeUtils.POINT_TYPE_P));
      history.setCreateUserId(apply.getUpdateUserId());
      history.setCreateDate(Calendar.getInstance().getTime());
    }

		Database.commit();
  }
  /**
   * 採用ポイント削除
   * @param apply
   * @param point
   */
  public static void grantAdoptPointDelete(OriTImproveopeApply apply) {

    List<OriTImproveopeApplyMemberMap> map = ImproveopeApplyUtils.getOriTImproveopeApplyMemberMap(apply);
    for (OriTImproveopeApplyMemberMap user : map) {

      OriTPointHistory history = ImproveopeUtils.getOriTPointHistoryAdopt(apply, user.getUserId());

      if (history != null) {
        Database.delete(history);
      }
    }
  }

  /**
   * 投稿ポイント付与
   * @param topic
   */
  public static void grantTopicPoint(OriTImproveopeTopic topic) {
	    OriTPointHistory history = Database.create(OriTPointHistory.class);
		history.setTopicId(topic.getTopicId());
		history.setUserId(topic.getOwnerId());
		history.setPointId(ImproveopeUtils.getPointId(ImproveopeUtils.POINT_TYPE_T));
		history.setPoint(ImproveopeUtils.getDefaultPoint(ImproveopeUtils.POINT_TYPE_T));
		history.setCreateUserId(topic.getUpdateUserId());
		history.setCreateDate(Calendar.getInstance().getTime());
		Database.commit();
  }

  /**
   * 投稿コメントポイント付与
   * @param topic
   */
  public static void grantTopicCommentPoint(OriTImproveopeTopic topic) {
	    OriTPointHistory history = Database.create(OriTPointHistory.class);
		history.setTopicId(topic.getTopicId());
		history.setUserId(topic.getOwnerId());
		history.setPointId(ImproveopeUtils.getPointId(ImproveopeUtils.POINT_TYPE_C));
		history.setPoint(ImproveopeUtils.getDefaultPoint(ImproveopeUtils.POINT_TYPE_C));
		history.setCreateUserId(topic.getUpdateUserId());
		history.setCreateDate(Calendar.getInstance().getTime());
		Database.commit();
  }
  /**
   * 申請ポイント付与
   * @param topic
   */
  public static void grantApplyPoint(OriTImproveopeApply apply) {
	    OriTPointHistory history = Database.create(OriTPointHistory.class);
		history.setApplyId(apply.getApplyId());
		history.setUserId(apply.getOwnerId());
		history.setPointId(ImproveopeUtils.getPointId(ImproveopeUtils.POINT_TYPE_A));
		history.setPoint(ImproveopeUtils.getDefaultPoint(ImproveopeUtils.POINT_TYPE_A));
		history.setCreateUserId(apply.getUpdateUserId());
		history.setCreateDate(Calendar.getInstance().getTime());
		Database.commit();
  }
  /**
   * 評価ポイント付与
   * @param topic
   */
  public static void grantCheckPoint(OriTImproveopeApplyCheck check) {
	    OriTPointHistory history = Database.create(OriTPointHistory.class);
		history.setApplyId(check.getOriTImproveopeApply().getApplyId());
		history.setUserId(check.getUserId());
		history.setPointId(ImproveopeUtils.getPointId(ImproveopeUtils.POINT_TYPE_H));
		history.setPoint(ImproveopeUtils.getDefaultPoint(ImproveopeUtils.POINT_TYPE_H));
		history.setCreateUserId(check.getUpdateUserId());
		history.setCreateDate(Calendar.getInstance().getTime());
		Database.commit();
  }

  public static OriTPointHistory getOriTPointHistoryAdopt(OriTImproveopeApply apply) {
		SelectQuery<OriTPointHistory> query = Database.query(OriTPointHistory.class);
		Expression exp =
				ExpressionFactory.matchExp(OriTPointHistory.USER_ID_PROPERTY, Integer.valueOf(apply.getOwnerId()));
		query.setQualifier(exp);
		Expression exp2 =
				ExpressionFactory.matchExp(OriTPointHistory.APPLY_ID_PROPERTY, Integer.valueOf(apply.getApplyId()));
		query.andQualifier(exp2);
		Expression exp3 =
				ExpressionFactory.matchExp(OriTPointHistory.POINT_ID_PROPERTY, ImproveopeUtils.getPointId(ImproveopeUtils.POINT_TYPE_P));
		query.andQualifier(exp3);
		List<OriTPointHistory> pointList = query.fetchList();
		if (pointList != null && pointList.size() > 0) {
			return pointList.get(0);
		}
		return null;
  }
  public static OriTPointHistory getOriTPointHistoryAdopt(OriTImproveopeApply apply, int user_id) {
    SelectQuery<OriTPointHistory> query = Database.query(OriTPointHistory.class);
    Expression exp =
        ExpressionFactory.matchExp(OriTPointHistory.USER_ID_PROPERTY, user_id);
    query.setQualifier(exp);
    Expression exp2 =
        ExpressionFactory.matchExp(OriTPointHistory.APPLY_ID_PROPERTY, Integer.valueOf(apply.getApplyId()));
    query.andQualifier(exp2);
    Expression exp3 =
        ExpressionFactory.matchExp(OriTPointHistory.POINT_ID_PROPERTY, ImproveopeUtils.getPointId(ImproveopeUtils.POINT_TYPE_P));
    query.andQualifier(exp3);
    List<OriTPointHistory> pointList = query.fetchList();
    if (pointList != null && pointList.size() > 0) {
      return pointList.get(0);
    }
    return null;
  }

  public static int getAdoptPoint(OriTImproveopeApply apply) {
		OriTPointHistory point = ImproveopeUtils.getOriTPointHistoryAdopt(apply);
		if (point != null) {
	      return point.getPoint();
		}

		return 0;
  }


}
