/*
 * Copyright(C) 2012 - 2013 orinos Co.,Ltd. All rights reserved.
 * http://www.orinos.co.jp/
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

package com.aimluck.eip.improveope;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;

import com.aimluck.commons.field.ALDateTimeField;
import com.aimluck.commons.field.ALNumberField;
import com.aimluck.commons.field.ALStringField;
import com.aimluck.eip.common.ALData;
import com.aimluck.eip.fileupload.beans.FileuploadBean;
import com.aimluck.eip.util.ALCommonUtils;
import com.aimluck.eip.util.ALEipUtils;

/**
 * 業務改善案申請のResultData <BR>
 *
 */
public class ImproveopeGrantResultData implements ALData {

 /** ID */
 private ALNumberField id;

 /** ユーザーID */
 private ALNumberField user_id;

 /** ポイントID */
 private ALNumberField point_id;

 /** ポイント */
 private ALStringField point;

 /** ポイント名 */
 private ALStringField point_name;

 /** ポイントタイプ */
 private ALStringField point_type;

 /** 作成者ID */
 private ALNumberField create_user_id;

 /** 更新者ID */
 private ALNumberField update_user_id;

 /** 作成時間 */
 private ALDateTimeField create_date;

 /** 更新時間 */
 private ALDateTimeField update_date;

 /** ユーザー名 */
 private ALStringField user_name;

 /** 作成者名 */
 private ALStringField create_user_name;

 /** 更新者名 */
 private ALStringField update_user_name;

 /** 部署名 */
 private ALStringField post_name;

  /**
   *
   *
   */
  @Override
  public void initField() {

	id = new ALNumberField();
	user_id = new ALNumberField();
	point_id = new ALNumberField();
	point = new ALStringField();
	create_user_id = new ALNumberField();
	create_date = new ALDateTimeField();
	user_name = new ALStringField();
	create_user_name = new ALStringField();
	post_name = new ALStringField();
	point_type = new ALStringField();
	update_date = new ALDateTimeField();
	update_user_id = new ALNumberField();
	update_user_name = new ALStringField();
	point_name = new ALStringField();

  }

/**
 * @return point_name
 */
public ALStringField getPointName() {
	return point_name;
}

/**
 * @param point_name セットする point_name
 */
public void setPointName(String str) {
	this.point_name.setValue(str);
}

/**
 * @return update_user_id
 */
public ALNumberField getUpdateUserId() {
	return update_user_id;
}

/**
 * @return update_user_name
 */
public ALStringField getUpdateUserName() {
	return update_user_name;
}

/**
 * @param update_user_id セットする update_user_id
 */
public void setUpdateUserId(Integer i) {
	this.update_user_id.setValue(i);
}

/**
 * @param update_user_name セットする update_user_name
 */
public void setUpdateUserName(String str) {
	this.update_user_name.setValue(str);
}

/**
 * @return update_date
 */
public ALDateTimeField getUpdateDate() {
	return update_date;
}

/**
 * @param update_date セットする update_date
 */
public void setUpdateDate(Date date) {
	this.update_date.setValue(date);;
}

/**
 * @return point_type
 */
public ALStringField getPointType() {
	return point_type;
}

/**
 * @param point_type セットする point_type
 */
public void setPointType(String str) {
	this.point_type.setValue(str);
}

/**
 * @return post_name
 */
public ALStringField getPostName() {
	return post_name;
}

/**
 * @param post_name セットする post_name
 */
public void setPostName(String str) {
	this.post_name.setValue(str);
}

/**
 * @return id
 */
public ALNumberField getId() {
	return id;
}

/**
 * @return user_id
 */
public ALNumberField getUserId() {
	return user_id;
}

/**
 * @return point_id
 */
public ALNumberField getPointId() {
	return point_id;
}

/**
 * @return point
 */
public ALStringField getPoint() {
	return point;
}

/**
 * @return create_user_id
 */
public ALNumberField getCreateUserId() {
	return create_user_id;
}

/**
 * @return create_date
 */
public ALDateTimeField getCreateDate() {
	return create_date;
}

/**
 * @return user_name
 */
public ALStringField getUserName() {
	return user_name;
}

/**
 * @return create_user_name
 */
public ALStringField getCreateUserName() {
	return create_user_name;
}

/**
 * @param id セットする id
 */
public void setId(int i) {
	this.id.setValue(i);
}

/**
 * @param user_id セットする user_id
 */
public void setUserId(int i) {
	this.user_id.setValue(i);
}

/**
 * @param point_id セットする point_id
 */
public void setPointId(long i) {
	this.point_id.setValue(i);
}

/**
 * @param point セットする point
 */
public void setPoint(String str) {
	this.point.setValue(str);
}

/**
 * @param create_user_id セットする create_user_id
 */
public void setCreateUserId(int i) {
	this.create_user_id.setValue(i);
}

/**
 * @param create_date セットする create_date
 */
public void setCreateDate(Date date) {
	this.create_date.setValue(date);
}

/**
 * @param user_name セットする user_name
 */
public void setUserName(String str) {
	this.user_name.setValue(str);
}

/**
 * @param create_user_name セットする create_user_name
 */
public void setCreateUserName(String str) {
	this.create_user_name.setValue(str);
}



}
