/*
 * Copyright(C) 2010 avanza Co.,Ltd. All rights reserved.
 * http://www.avnz.co.jp/
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 */

package com.aimluck.eip.modules.screens;

import java.util.List;

import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;

import org.apache.jetspeed.services.logging.JetspeedLogFactoryService;
import org.apache.jetspeed.services.logging.JetspeedLogger;
import org.apache.turbine.util.RunData;

import com.aimluck.commons.utils.ALStringUtil;
import com.aimluck.eip.cayenne.om.portlet.ExtTimecardAggregateUser;
import com.aimluck.eip.orm.Database;

/**
 * タイムカード（集計）ファイル出力を取り扱うクラスです
 */
public class ExtTimecardSummaryCsvExportScreen extends ALCSVScreen {
  /**
   * logger
   */
  private static final JetspeedLogger logger = JetspeedLogFactoryService
    .getLogger(ExtTimecardSummaryCsvExportScreen.class.getName());

  /**
   * HTTP コンテンツタイプ
   *
   * @see org.apache.turbine.modules.screens.RawScreen#getContentType(org.apache.turbine.util.RunData)
   */
  @Override
  protected String getContentType(RunData rundata) {
    return "application/octet-stream";
  }

  /**
   * 出力ファイル名（接頭辞）
   */
  public static String FILE_NAME = "";

  /**
   * 拡張子名
   */
  public static final String FILE_EXTENTION = ".csv";

  /**
   * CSVデータ改行値
   */
  public static final String LINE_SEPARATOR = System
    .getProperty("line.separator");

  /**
   * CSVデータ区切り文字
   */
  public static final String COLOMN_SEPARATOR = ",";

  private String view_month;

  @Override
  protected void doOutput(RunData rundata) throws Exception {
    ServletOutputStream out = null;

    try {

      view_month = rundata.getParameters().getString("view_month");
      String result = getCSVString(rundata);
      FILE_NAME = "タイムカード-" + view_month + FILE_EXTENTION;
      String fileName =
        new String(FILE_NAME.getBytes("Shift_JIS"), "ISO-8859-1");

      HttpServletResponse response = rundata.getResponse();
      // ファイル名の送信(attachment部分をinlineに変更すればインライン表示)
      response.setHeader("Content-disposition", "attachment; filename=\""
        + fileName
        + "\"");
      response.setHeader("Cache-Control", "no-cache");
      response.setHeader("Pragma", "No-cache");

      // ファイル内容の出力
      out = response.getOutputStream();
      out.write(result.getBytes("Shift_JIS"));
      out.flush();
      out.close();
    } catch (Exception e) {
      logger.error("[ERROR]", e);
    }

  }

  /**
   * CSV文字列取り出し用メソッド。<br />
   * CSV文字列を返します。
   *
   * @param rundata
   *          RunData
   * @return
   */
  @Override
  protected String getCSVString(RunData rundata) {
    StringBuffer sb = new StringBuffer();
    // ヘッダライン設定
    makeHeaderLine(sb);

    // SQLの作成
    StringBuffer idStatement = new StringBuffer();
    idStatement.append("SELECT * ");
    idStatement.append("FROM ext_timecard_aggregate_user ");
    idStatement.append("WHERE aggregate_years  = #bind($view_month) ");
    idStatement.append("ORDER BY POST_CD, USER_ORDER");

    String idQuery = idStatement.toString();

    List<ExtTimecardAggregateUser> list =
      Database.sql(ExtTimecardAggregateUser.class, idQuery).param(
        "view_month",
        view_month).fetchList();

    if (list != null && list.size() > 0) {
      for (int i = 0; i < list.size(); i++) {

        ExtTimecardAggregateUser ag = list.get(i);
        // 社員番号
        setColumn(sb, ag.getEmployeeNumber());
        // 社員氏名
        setColumn(sb, ag.getUserName());
        // 社員氏名カナ
        setColumn(sb, ALStringUtil.convertZKana2H(ag.getUserNameKn()));
        // 部課
        setColumn(sb, ag.getPostCd() + ':' + ag.getPost());
        // 給与体系
        setColumn(sb, ag.getPayrollSystemCd() + ':' + ag.getPayrollSystem());
        // 所定労働日数
        setColumn(sb, ag.getPrescribedWorkingDays());
        // 所定労働時間
        setColumn(sb, ag.getScheduledWorkingHours());
        // 総就労時間
        setColumn(sb, ag.getTotalWorkingHours());
        // 勤務日数
        setColumn(sb, ag.getAttendanceDays());
        // 出勤時間
        setColumn(sb, ag.getAttendanceTime());
        // 日給
        setColumn(sb, ag.getDailyWage());
        // 法定内残業
        setColumn(sb, ag.getWithinLegalOvertime());
        // 法定外残業
        setColumn(sb, ag.getOutsideLegalOvertime());
        // 深夜加算
        setColumn(sb, ag.getMidnightAddition());
        // 休日加算
        setColumn(sb, ag.getHolidayAddition());
        // 60h越残業
        setColumn(sb, ag.getSixtyHoursOvertime());
        // 車出手当
        setColumn(sb, ag.getOutCarAllowance());
        // 応援手当
        setColumn(sb, ag.getSupportAllowance());
        // 遠隔手当１
        setColumn(sb, ag.getRemoteAllowance1());
        // 遠隔手当２
        setColumn(sb, ag.getRemoteAllowance2());
        // 休消手当
        setColumn(sb, ag.getHolidayConsumptionAllowance());
        // 当直手当
        setColumn(sb, ag.getDutyAllowance(), false);

        sb.append(LINE_SEPARATOR);

      }
    }

    // 生成文字列 デバック用出力
    logger.debug(sb.toString());

    return sb.toString();
  }

  @Override
  protected String getFileName() {

    return null;
  }

  private void setColumn(StringBuffer sb, String value) {
    setColumn(sb, value, true);
  }

  /**
   * カラムをセットする
   */
  private void setColumn(StringBuffer sb, String value, boolean separator) {

    if (value == null || "0".equals(value) || "0.0".equals(value)) {
      value = "";
    }

    sb.append(value);

    if (separator) {
      sb.append(COLOMN_SEPARATOR);
    }
  }

  /**
   * CSVのヘッダ情報を生成します。
   *
   * @param sb
   *          StringBuffer
   */
  private void makeHeaderLine(StringBuffer sb) {
	    sb.append(COLOMN_SEPARATOR);
	    sb.append(COLOMN_SEPARATOR);
	    sb.append(COLOMN_SEPARATOR);
	    sb.append(COLOMN_SEPARATOR);
	    sb.append(COLOMN_SEPARATOR);
	    sb.append("所定労働日数" + COLOMN_SEPARATOR);
	    sb.append("所定労働時間" + COLOMN_SEPARATOR);
	    sb.append("総就労時間" + COLOMN_SEPARATOR);
	    sb.append("勤務日数" + COLOMN_SEPARATOR);
	    sb.append("出勤時間" + COLOMN_SEPARATOR);
	    sb.append("日給" + COLOMN_SEPARATOR);
	    sb.append("法定内残業100％" + COLOMN_SEPARATOR);
	    sb.append("法定外残業125％" + COLOMN_SEPARATOR);
	    sb.append("深夜加算25％" + COLOMN_SEPARATOR);
	    sb.append("休日加算135％" + COLOMN_SEPARATOR);
	    sb.append("60ｈ越残業25％" + COLOMN_SEPARATOR);
	    sb.append("車出手当@200" + COLOMN_SEPARATOR);
	    sb.append("\"応援手当@2,000\"" + COLOMN_SEPARATOR);
	    sb.append("遠隔手当１" + COLOMN_SEPARATOR);
	    sb.append("遠隔手当２" + COLOMN_SEPARATOR);
	    sb.append("\"休消手当@3,000\"" + COLOMN_SEPARATOR);
	    sb.append("当直手当");
	    sb.append(LINE_SEPARATOR);

	    sb.append("社員番号(必須)" + COLOMN_SEPARATOR);
	    sb.append("社員氏名(ﾃﾝﾌﾟﾚｰﾄ項目)" + COLOMN_SEPARATOR);
	    sb.append("氏名フリガナ(ﾃﾝﾌﾟﾚｰﾄ項目)" + COLOMN_SEPARATOR);
	    sb.append("部課(ﾃﾝﾌﾟﾚｰﾄ項目)" + COLOMN_SEPARATOR);
	    sb.append("給与体系(ﾃﾝﾌﾟﾚｰﾄ項目)" + COLOMN_SEPARATOR);
	    sb.append("所定労働日数" + COLOMN_SEPARATOR);
	    sb.append("所定労働時間" + COLOMN_SEPARATOR);
	    sb.append("要出勤時間" + COLOMN_SEPARATOR);
	    sb.append("要出勤日数" + COLOMN_SEPARATOR);
	    sb.append("出勤時間" + COLOMN_SEPARATOR);
	    sb.append("平日出勤" + COLOMN_SEPARATOR);
	    sb.append("時間外手当時間Ａ" + COLOMN_SEPARATOR);
	    sb.append("時間外手当時間Ｂ" + COLOMN_SEPARATOR);
	    sb.append("時間外手当時間Ｃ" + COLOMN_SEPARATOR);
	    sb.append("時間外手当時間Ｄ" + COLOMN_SEPARATOR);
	    sb.append("時間外手当時間Ｈ" + COLOMN_SEPARATOR);
	    sb.append("回数手当回数１" + COLOMN_SEPARATOR);
	    sb.append("回数手当回数２" + COLOMN_SEPARATOR);
	    sb.append("回数手当回数３" + COLOMN_SEPARATOR);
	    sb.append("回数手当回数４" + COLOMN_SEPARATOR);
	    sb.append("回数手当回数５" + COLOMN_SEPARATOR);
	    sb.append("支給項目9");
	    sb.append(LINE_SEPARATOR);
    }
}
