/*
 * Copyright(C) 2012 - 2013 orinos Co.,Ltd. All rights reserved.
 * http://www.orinos.co.jp/
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

package com.aimluck.eip.exttimecard;

import java.util.Calendar;
import java.util.Date;
import java.util.List;

import org.apache.jetspeed.services.logging.JetspeedLogFactoryService;
import org.apache.jetspeed.services.logging.JetspeedLogger;
import org.apache.turbine.util.RunData;
import org.apache.velocity.context.Context;

import com.aimluck.commons.field.ALStringField;
import com.aimluck.eip.cayenne.om.portlet.OriTPayrollSystem;
import com.aimluck.eip.cayenne.om.security.TurbineUser;
import com.aimluck.eip.common.ALAbstractFormData;
import com.aimluck.eip.common.ALDBErrorException;
import com.aimluck.eip.common.ALPageNotFoundException;
import com.aimluck.eip.exttimecard.util.ExtTimecardUtils;
import com.aimluck.eip.modules.actions.common.ALAction;
import com.aimluck.eip.orm.Database;
import com.aimluck.eip.util.ALEipUtils;

/**
 * タイムカード集計のフォームデータを管理するためのクラスです。 <br />
 *
 */

public class ExtTimecardSystemPayrollSystemFormData extends ALAbstractFormData {

  /** logger */
  private static final JetspeedLogger logger = JetspeedLogFactoryService
    .getLogger(ExtTimecardSystemPayrollSystemFormData.class.getName());

  private ALStringField id;

  /** 給与体系コード  */
  private ALStringField payroll_system_cd;

  /** 給与体系名 */
  private ALStringField payroll_system_name;

  /** 給与体系タイプ */
  private ALStringField payroll_system_type;

  @Override
  public void init(ALAction action, RunData rundata, Context context)
      throws ALPageNotFoundException, ALDBErrorException {
    super.init(action, rundata, context);
  }

  /**
   *
   */
  @Override
  public void initField() {

   // id
   id = new ALStringField();

   // 給与体系コード
   payroll_system_cd = new ALStringField();
   payroll_system_cd.setFieldName("給与体系コード");
   payroll_system_cd.setTrim(true);
   payroll_system_cd.setCharacterType(ALStringField.TYPE_ALPHABET_NUMBER);

   // 給与体系名
   payroll_system_name = new ALStringField();
   payroll_system_name.setFieldName("給与体系名");
   payroll_system_name.setTrim(true);

   // 給与体系タイプ
   payroll_system_type = new ALStringField();
   payroll_system_type.setFieldName("給与体系タイプ");
   payroll_system_type.setTrim(true);

  }

  @Override
  protected boolean loadFormData(RunData rundata, Context context,
      List<String> msgList) throws ALPageNotFoundException, ALDBErrorException {
    try {
      OriTPayrollSystem record =
    		  ExtTimecardUtils.getOriTPayrollSystem(rundata, context);
      if (record == null) {
        return false;
      }

      // id
      id.setValue(record.getId().toString());
      // 給与体系コード
      payroll_system_cd.setValue(record.getPayrollSystemCd());
      // 給与体系名
      payroll_system_name.setValue(record.getPayrollSystemName());
      // 給与体系タイプ
      payroll_system_type.setValue(record.getPayrollSystemType());


    } catch (Exception ex) {
      logger.error("Exception", ex);
      return false;
    }
    return true;
  }

  @Override
  protected boolean updateFormData(RunData rundata, Context context,
      List<String> msgList) throws ALPageNotFoundException, ALDBErrorException {
    try {
    	OriTPayrollSystem record =
    			ExtTimecardUtils.getOriTPayrollSystem(rundata, context);
      if (record == null) {
        return false;
      }

      record.setPayrollSystemCd(payroll_system_cd.getValue());
      record.setPayrollSystemName(payroll_system_name.getValue());
      record.setPayrollSystemType(payroll_system_type.getValue());

      // 時間
      Date now = Calendar.getInstance().getTime();

      record.setUpdateDate(now);
      record.setUpdateUserId(ALEipUtils.getUserId(rundata));


      Database.commit();
    } catch (Exception ex) {
      Database.rollback();
      logger.error("Exception", ex);
      return false;
    }
    return true;
  }

  @Override
  protected boolean deleteFormData(RunData rundata, Context context,
      List<String> msgList) throws ALPageNotFoundException, ALDBErrorException {
    try {
      // オブジェクトモデルを取得
    	OriTPayrollSystem record =
    			ExtTimecardUtils.getOriTPayrollSystem(rundata, context);
      if (record == null) {
        return false;
      }


      int PayrollSystemId = record.getId();

      Database.delete(record);
      Database.commit();

      // この給与体系に設定されているユーザーの給与体系IDを0とする
      String sql =
        "UPDATE turbine_user set PAYROLL_SYSTEM_ID = 0 where PAYROLL_SYSTEM_ID = "
          + PayrollSystemId;
      Database.sql(TurbineUser.class, sql).execute();


    } catch (Exception ex) {
      logger.error("Exception", ex);
      return false;
    }
    return true;
  }

  @Override
  protected boolean insertFormData(RunData rundata, Context context,
      List<String> msgList) throws ALPageNotFoundException, ALDBErrorException {
    try {
    	OriTPayrollSystem record =
    			Database.create(OriTPayrollSystem.class);

    	record.setPayrollSystemCd(payroll_system_cd.getValue());
    	record.setPayrollSystemName(payroll_system_name.getValue());
    	record.setPayrollSystemType(payroll_system_type.getValue());

    	// 時間
    	Date now = Calendar.getInstance().getTime();
    	record.setCreateDate(now);
    	record.setCreateUserId(ALEipUtils.getUserId(rundata));

    	record.setUpdateDate(now);
    	record.setUpdateUserId(ALEipUtils.getUserId(rundata));

     Database.commit();

    } catch (Exception ex) {
      logger.error("Exception", ex);
      return false;
    }
    return true;
  }

  @Override
  protected boolean setFormData(RunData rundata, Context context,
      List<String> msgList) throws ALPageNotFoundException, ALDBErrorException {
    boolean res = super.setFormData(rundata, context, msgList);

    return res;
  }

  @Override
  protected void setValidator() throws ALPageNotFoundException,
      ALDBErrorException {

	  payroll_system_cd.setNotNull(true);
	  payroll_system_name.setNotNull(true);
	  payroll_system_type.setNotNull(true);

  }

  @Override
  protected boolean validate(List<String> msgList)
      throws ALPageNotFoundException, ALDBErrorException {

	payroll_system_cd.validate(msgList);
	payroll_system_name.validate(msgList);
	payroll_system_type.validate(msgList);

    return (msgList.size() == 0);
  }


  /**
   * 詳細データを取得する抽象メソッドです。
   *
   * @param rundata
   * @param context
   * @return
   */
  protected Object selectDetail(RunData rundata, Context context)
      throws ALPageNotFoundException, ALDBErrorException {
    return null;
  }

/**
 * @return id
 */
public ALStringField getId() {
	return id;
}

/**
 * @return payroll_system_cd
 */
public ALStringField getPayrollSystemCd() {
	return payroll_system_cd;
}

/**
 * @return payroll_system_name
 */
public ALStringField getPayrollSystemName() {
	return payroll_system_name;
}

/**
 * @return payroll_system_type
 */
public ALStringField getPayrollSystemType() {
	return payroll_system_type;
}


}
