/*
 * Aipo is a groupware program developed by Aimluck,Inc.
 * Copyright (C) 2004-2011 Aimluck,Inc.
 * http://www.aipo.com
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

package com.aimluck.eip.exttimecard;

import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

import com.aimluck.commons.field.ALDateField;
import com.aimluck.commons.field.ALDateTimeField;
import com.aimluck.commons.field.ALNumberField;
import com.aimluck.eip.account.util.AccountUtils;
import com.aimluck.eip.cayenne.om.portlet.EipTTimecardSettings;
import com.aimluck.eip.common.ALData;
import com.aimluck.eip.exttimecard.util.ExtTimecardUtils;
import com.aimluck.eip.orm.Database;
import com.aimluck.eip.orm.query.SelectQuery;

/**
 * 一日分のタイムカード(出勤・退勤の履歴)を保持する。<br>
 * 一日ごとの勤務時間・残業時間などを計算し、その結果を保持する。
 *
 *
 */
public class ExtTimecardSummaryResultData implements ALData {

  private ALDateField date = null;

  private List<ExtTimecardResultData> list = null;

  /** 就業日数 */
  private ALNumberField work_day = null;

  /** 就業時間 */
  private ALNumberField work_hour = null;

  /** 残業日数 */
  private ALNumberField overtime_day = null;

  /** 残業時間 */
  private ALNumberField overtime_hour = null;

  /** 休出日数 */
  private ALNumberField off_day = null;

  /** 休出時間 */
  private ALNumberField off_hour = null;

  /** 遅刻日数 */
  private ALNumberField late_coming_day = null;

  /** 早退日数 */
  private ALNumberField early_leaving_day = null;

  /** 欠勤日数 */
  private ALNumberField absent_day = null;

  /** 有休日数 */
  private ALNumberField paid_holiday = null;

  /** 慶弔休 */
  private ALNumberField keicho = null;

  /** 代休日数 */
  private ALNumberField compensatory_holiday = null;

  /** その他 */
  private ALNumberField other_day = null;

  /** 未入力 */
  private ALNumberField no_input = null;

  /** 待機時間 */
  private ALNumberField waiting_time = null;

  /** 有休利用時間 */
  private ALNumberField used_time = null;

  /** 当直回数 */
  private ALNumberField watch_number = null;

  /** 一人応援回数 */
  private ALNumberField support_number = null;

  /** 移動手当て回数 */
  private ALNumberField move_number = null;

  /** 車出手当て回数 */
  private ALNumberField car_number = null;

  /** 遠隔手当１ */
  private ALNumberField help1_number = null;

  /** 遠隔手当２ */
  private ALNumberField help2_number = null;

  /** 休日加算 */
  private ALNumberField addholiday_hour = null;

  /** 休消手当 */
  private ALNumberField subholiday_number = null;

  private ALNumberField user_id = null;

  private String user_name = null;

  private String user_name_kana = null;

  private String user_order = null;

  private String systemName = null;

  private String employee_number = null;

  /** ステータス morimoto-junichi add 2012/10/09 */
  private String status = "";

  /** 部署 */
  private String post_name = "";

  /** 部署コード */
  private String post_code = "";

  /** 役職 */
  private String position_name = "";

  /** 日給 */
  private ALNumberField nikyu_day = null;

  /** 申請中 */
  private ALNumberField entry_number = null;

  /** 却下 */
  private ALNumberField rejection_number = null;

  /** 所定労働日数 */
  private ALNumberField prescribed_working_day = null;

  /** 所定労働時間 */
  private ALNumberField scheduled_working_hour = null;

  /** 法定内残業 */
  private ALNumberField within_legal_overtime = null;

  /** 法定外残業 */
  private ALNumberField outside_legal_overtime = null;

  /** 60h越残業 */
  private ALNumberField overtime_60 = null;

  /** 深夜時間 */
  private ALNumberField midnight_hour = null;

  /** 給与体系タイプ */
  private String payroll_type = null;

  /** 給与体系 */
  private String payroll_name = null;

  /** 給与体系コード */
  private String payroll_code = null;

  /** 対象年月 */
  private ALDateTimeField view_month = null;

  /**
   *
   *
   */
  @Override
  public void initField() {
    work_day = new ALNumberField(0);
    work_hour = new ALNumberField(0);

    overtime_day = new ALNumberField(0);
    overtime_hour = new ALNumberField(0);

    off_day = new ALNumberField(0);
    off_hour = new ALNumberField(0);

    late_coming_day = new ALNumberField(0);
    early_leaving_day = new ALNumberField(0);
    absent_day = new ALNumberField(0);
    paid_holiday = new ALNumberField(0);
    keicho = new ALNumberField(0);
    compensatory_holiday = new ALNumberField(0);
    other_day = new ALNumberField(0);
    no_input = new ALNumberField(0);

    waiting_time = new ALNumberField(0);
    used_time = new ALNumberField(0);
    watch_number = new ALNumberField(0);
    support_number = new ALNumberField(0);
    move_number = new ALNumberField(0);
    car_number = new ALNumberField(0);
    help1_number = new ALNumberField(0);
    help2_number = new ALNumberField(0);
    addholiday_hour = new ALNumberField(0);
    subholiday_number = new ALNumberField(0);

    nikyu_day = new ALNumberField(0);
    entry_number = new ALNumberField(0);
    rejection_number = new ALNumberField(0);

    prescribed_working_day = new ALNumberField(0);
    scheduled_working_hour = new ALNumberField(0);

    within_legal_overtime = new ALNumberField(0);
    outside_legal_overtime = new ALNumberField(0);
    overtime_60 = new ALNumberField(0);
    midnight_hour = new ALNumberField(0);

    user_id = new ALNumberField(0);
    date = new ALDateField();
    date.setValue(new Date());
    list = new ArrayList<ExtTimecardResultData>();

    view_month = new ALDateTimeField("yyyy-MM");
  }

  /**
   * 出勤日数、および時間を設定します。
   *
   * @param days
   * @param hour
   */
  public void setWorkDayHour(int days, float hour) {
    work_day.setValue(days);
    work_hour.setValue(String.valueOf(hour));
  }

  /**
   * 残業日数、および時間を設定します。
   *
   * @param days
   * @param hour
   */
  public void setOvertimeDayHour(int days, float hour) {
    overtime_day.setValue(days);
    overtime_hour.setValue(String.valueOf(hour));
  }

  /**
   * 休出日数、および時間を設定します。
   *
   * @param days
   * @param hour
   */
  public void setOffDayHour(int days, float hour) {
    off_day.setValue(days);
    off_hour.setValue(String.valueOf(hour));
  }

  /**
   * 遅刻日数を設定します。
   *
   * @param days
   */
  public void setLateComingDay(int days) {
    late_coming_day.setValue(days);
  }

  /**
   * 早退日数を設定します。
   *
   * @param days
   */
  public void setEarlyLeavingDay(int days) {
    early_leaving_day.setValue(days);
  }

  /**
   * 欠勤日数を設定します。
   *
   * @param days
   */
  public void setAbsentDay(int days) {
    absent_day.setValue(days);
  }

  /**
   * 有休日数を設定します。
   *
   * @param days
   */
  public void setPaidHoliday(int days) {
    paid_holiday.setValue(days);
  }

  /**
   * 慶弔休日数を設定します。
   *
   * @param days
   */
  public void setKeicho(int days) {
    keicho.setValue(days);
  }

  /**
   * 代休日数を設定します。
   *
   * @param days
   */
  public void setCompensatoryHoliday(int days) {
    compensatory_holiday.setValue(days);
  }

  /**
   * その他日数を設定します。
   *
   * @param days
   */
  public void setOtherDay(int days) {
    other_day.setValue(days);
  }

  /**
   * 未入力日数を設定します。
   *
   * @param days
   */
  public void setNoInput(int days) {
    no_input.setValue(days);
  }

  /**
   * 待機時間を設定します。
   *
   * @param time
   */
  public void setWaitingTime(int time) {
    waiting_time.setValue(time);
  }

  /**
   * 有休利用時間を設定します。
   *
   * @param time
   */
  public void setUsedTime(int time) {
    used_time.setValue(time);
  }

  /**
   * 当直回数を設定します。
   *
   * @param number
   */
  public void setWatchNumber(int number) {
    watch_number.setValue(number);
  }

  /**
   * 一人応援回数を設定します。
   *
   * @param number
   */
  public void setSupportNumber(int number) {
    support_number.setValue(number);
  }

  /**
   * 移動手当て回数を設定します。
   *
   * @param number
   */
  public void setMoveNumber(int number) {
    move_number.setValue(number);
  }

  /**
   * 車出回数を設定します。
   *
   * @param number
   */
  public void setCarNumber(int number) {
    car_number.setValue(number);
  }

  /**
   * 遠隔手当１を設定します。
   *
   * @param number
   */
  public void setHelp1Number(int number) {
    help1_number.setValue(number);
  }

  /**
   * 遠隔手当２を設定します。
   *
   * @param number
   */
  public void setHelp2Number(int number) {
    help2_number.setValue(number);
  }

  /**
   * 休日加算を設定します。
   *
   * @param number
   */
  public void setAddholidayHour(float hour) {
    addholiday_hour.setValue(String.valueOf(hour));
  }

  /**
   * 休消手当を設定します。
   *
   * @param number
   */
  public void setSubholidayNumber(int number) {
    subholiday_number.setValue(number);
  }

  /**
   * 日給回数を設定します。
   *
   * @param number
   */
  public void setNikyuDay(int day) {
    nikyu_day.setValue(day);
  }

  /**
   * 申請中を設定します。
   *
   * @param number
   */
  public void setEntryNumber(int number) {
    entry_number.setValue(number);
  }

  /**
   * 却下数を設定します。
   *
   * @param number
   */
  public void setRejectionNumber(int number) {
    rejection_number.setValue(number);
  }

  /**
   * 所定労働日数を設定します。
   *
   * @param day
   */
  public void setPrescribedWorkingDay(int day) {
    prescribed_working_day.setValue(day);
  }

  /**
   * 所定労働時間を設定します。
   *
   * @param hour
   */
  public void setScheduledWorkingHour(float hour) {
    scheduled_working_hour.setValue(String.valueOf(hour));
  }

  /**
   * 法定内残業時間を設定します。
   *
   * @param hour
   */
  public void setWithinLegalOvertime(float hour) {
    within_legal_overtime.setValue(String.valueOf(hour));
  }

  /**
   * 法定外残業時間を設定します。
   *
   * @param hour
   */
  public void setOutsideLegalOvertime(float hour) {
	outside_legal_overtime.setValue(String.valueOf(hour));
  }

  /**
   * 60h越残業時間を設定します。
   *
   * @param hour
   */
  public void setOvertime60(float hour) {
	overtime_60.setValue(String.valueOf(hour));
  }

  /**
   * 深夜時間を設定します。
   *
   * @param hour
   */
  public void setMidnightHour(float hour) {
	midnight_hour.setValue(String.valueOf(hour));
  }

  /**
   * 就業日数を取得します。
   *
   * @return
   */
  public ALNumberField getWorkDay() {
    return work_day;
  }

  /**
   * 就業日数が所定就業日数に達しているか
   */
  public boolean getFillWorkDay() {
	  if (Integer.valueOf(this.work_day.toString()) >= Integer.valueOf(this.prescribed_working_day.toString())) {
		  return true;
	  }
	  return false;
  }

  /**
   * 就業時間を取得します。
   *
   * @return
   */
  public ALNumberField getWorkHour() {
    return work_hour;
  }

  /**
   * 就労時間が所定就労時間に達しているか
   */
  public boolean getFillWorkHour() {
	  if (Float.valueOf(this.work_hour.toString()) >= Float.valueOf(this.scheduled_working_hour.toString())) {
		  return true;
	  }
	  return false;
  }

  /**
   * 残業日数を取得します。
   *
   * @return
   */
  public ALNumberField getOvertimeDay() {
    return overtime_day;
  }

  /**
   * 残業時間を取得します。
   *
   * @return
   */
  public ALNumberField getOvertimeHour() {
    return overtime_hour;
  }

  /**
   * 休出日数を取得します。
   *
   * @return
   */
  public ALNumberField getOffDay() {
    return off_day;
  }

  /**
   * 休出時間を取得します。
   *
   * @return
   */
  public ALNumberField getOffHour() {
    return off_hour;
  }

  /**
   * 遅刻日数を取得します。
   *
   * @return
   */
  public ALNumberField getLateComingDay() {
    return late_coming_day;
  }

  /**
   * 早退日数を取得します。
   *
   * @return
   */
  public ALNumberField getEarlyLeavingDay() {
    return early_leaving_day;
  }

  /**
   * 欠勤日数を取得します。
   *
   * @return
   */
  public ALNumberField getAbsentDay() {
    return absent_day;
  }

  /**
   * 有休日数を取得します。
   *
   * @return
   */
  public ALNumberField getPaidHoliday() {
    return paid_holiday;
  }

  /**
   * 慶弔休日数を取得します。
   *
   * @return
   */
  public ALNumberField getKeicho() {
    return keicho;
  }

  /**
   * 代休日数を取得します。
   *
   * @return
   */
  public ALNumberField getCompensatoryHoliday() {
    return compensatory_holiday;
  }

  /**
   * その他日数を取得します。
   *
   * @return
   */
  public ALNumberField getOtherDay() {
    return other_day;
  }

  /**
   * 未入力数を取得します。
   *
   * @return
   */
  public ALNumberField getNoInput() {
    return no_input;
  }

  /**
   * 待機時間を取得します。
   *
   * @return
   */
  public ALNumberField getWaitingTime() {
    return waiting_time;
  }

  /**
   * 有休利用時間を取得します。
   *
   * @return
   */
  public ALNumberField getUsedTime() {
    return used_time;
  }
  public String getUsedTimeFormat() {
	return AccountUtils.getPaidFormat(Integer.valueOf(used_time.toString()));
  }


  /**
   * 当直回数を取得します。
   *
   * @return
   */
  public ALNumberField getWatchNumber() {
    return watch_number;
  }

  /**
   * 一人応援回数を取得します。
   *
   * @return
   */
  public ALNumberField getSupportNumber() {
    return support_number;
  }

  /**
   * 移動手当て回数を取得します。
   *
   * @return
   */
  public ALNumberField getMoveNumber() {
    return move_number;
  }

  /**
   * 車出手当て回数を取得します。
   *
   * @return
   */
  public ALNumberField getCarNumber() {
    return car_number;
  }

  /**
   * 遠隔手当１回数を取得します。
   *
   * @return
   */
  public ALNumberField getHelp1Number() {
    return help1_number;
  }

  /**
   * 遠隔手当２回数を取得します。
   *
   * @return
   */
  public ALNumberField getHelp2Number() {
    return help2_number;
  }

  /**
   * 休日加算時間を取得します。
   *
   * @return
   */
  public ALNumberField getAddholidayHour() {
    return addholiday_hour;
  }

  /**
   * 休消手当回数を取得します。
   *
   * @return
   */
  public ALNumberField getSubholidayNumber() {
    return subholiday_number;
  }

  /**
   * 日給回数を取得します。
   *
   * @return
   */
  public ALNumberField getNikyuDay() {
    return nikyu_day;
  }

  /**
   * 申請中を取得します。
   *
   * @return
   */
  public ALNumberField getEntryNumber() {
    return entry_number;
  }

  /**
   * 却下を取得します。
   *
   * @return
   */
  public ALNumberField getRejectionNumber() {
    return rejection_number;
  }

  /**
   * 所定労働日数を取得します。
   *
   * @return
   */
  public ALNumberField getPrescribedWorkingDay() {
    return prescribed_working_day;
  }

  /**
   * 所定労働時間を取得します。
   *
   * @return
   */
  public ALNumberField getScheduledWorkingHour() {
    return scheduled_working_hour;
  }

  /**
   * 法定内残業時間を取得します。
   *
   * @return
   */
  public ALNumberField getWithinLegalOvertime() {
    return within_legal_overtime;
  }

  /**
   * 法定外残業時間を取得します。
   *
   * @return
   */
  public ALNumberField getOutsideLegalOvertime() {
    return outside_legal_overtime;
  }

  /**
   * 60h越残業時間を取得します。
   *
   * @return
   */
  public ALNumberField getOvertime60() {
    return overtime_60;
  }

  /**
   * 深夜時間を取得します。
   *
   * @return
   */
  public ALNumberField getMidnightHour() {
    return midnight_hour;
  }
  // --------------------------------------------------------------------------------------
  /**
   *
   * @param date
   */
  public void setDate(Date date) {
    this.date.setValue(date);
  }

  /**
   * @return date
   */
  public ALDateField getDate() {
    return date;
  }

  /**
   *
   * @param minute
   * @return
   */
  @SuppressWarnings("unused")
  private String minuteToHour(long minute) {
    BigDecimal decimal = new BigDecimal(minute / 60.0);
    DecimalFormat dformat = new DecimalFormat("##.#");
    String str =
      dformat.format(decimal.setScale(1, BigDecimal.ROUND_FLOOR).doubleValue());
    return str;
  }

  /**
   *
   * @return
   */
  public String getDateStr() {
    try {
      SimpleDateFormat sdf = new SimpleDateFormat("yyyy年MM月dd日（EE）");
      return sdf.format(date.getValue().getDate());
    } catch (Exception e) {
      return "";
    }
  }

  /**
   *
   * @return
   */
  public List<ExtTimecardResultData> getList() {
    return list;
  }

  public void setUserName(String user_name) {
    this.user_name = user_name;
  }

  public String getUserName() {
    return user_name;
  }

  public void setUserNameKana(String user_name_kana) {
    this.user_name_kana = user_name_kana;
  }

  public String getUserNameKana() {
    return user_name_kana;
  }

  public void setUserOrder(String user_order) {
    this.user_order = user_order;
  }

  public String getUserOrder() {
    return user_order;
  }

  public void setSystemName(String systemName) {
    this.systemName = systemName;
  }

  public String getSystemName() {
    return systemName;
  }

  public void setUserId(int id) {
	  user_id.setValue(id);
  }

  public ALNumberField getUserId() {
	  return user_id;
  }

  public void setEmployeeNumber(String number) {
    this.employee_number = number;
  }

  public String getEmployeeNumber() {
    return employee_number;
  }

  /**
   *
   * @return
   */
  public List<ExtTimecardResultData> getViewList() {
    ArrayList<ExtTimecardResultData> viewlist =
      new ArrayList<ExtTimecardResultData>();

    ExtTimecardResultData rd = null;

    int size = list.size();
    for (int i = 0; i < size; i++) {
      rd = list.get(i);
      if (!ExtTimecardUtils.WORK_FLG_DUMMY.equals(rd.getWorkFlag().getValue())) {
        viewlist.add(rd);
      }
    }
    return viewlist;
  }

  /**
   *
   * @param rd
   */
  public void addExtTimecardResultData(ExtTimecardResultData rd) {
    list.add(rd);
  }

  /**
   * ExtTimecardResultDataオブジェクトのインスタンスを作る
   *
   * @param date
   * @param workflag
   * @return
   */
  @SuppressWarnings("unused")
  private ExtTimecardResultData createExtTimecardResultData(Date date,
      String workflag) {
    ExtTimecardResultData rd = new ExtTimecardResultData();
    rd.initField();
    rd.setWorkDate(date);
    rd.setWorkFlag(workflag);
    return rd;
  }

  /**
   * 勤務時間設定をDBから取得する
   *
   * @return
   */
  @SuppressWarnings("unused")
  private EipTTimecardSettings loadEipTTimecardSettings() {

    SelectQuery<EipTTimecardSettings> query =
      Database.query(EipTTimecardSettings.class);
    List<EipTTimecardSettings> aList = query.fetchList();
    if (aList != null && aList.size() > 0) {
      EipTTimecardSettings record = aList.get(0);
      return record;
    } else {
      return null;
    }
  }

  /**
   * 締め処理が行われているか
   */
  public boolean isTimecardAggregateUser() {

	  String yyyymm = view_month.toString("yyyy-MM");
	  int userid = Integer.valueOf(getUserId().toString());
	  return ExtTimecardUtils.getExtTimecardAggregateUser(userid, yyyymm);
  }

  /**
   * @return status
   */
  public String getStatus() {
    return status;
  }

  /**
   * @param status
   *          セットする status
   */
  public void setStatus(String str) {
    this.status = str;
  }

  public String getPostName() {
	return post_name;
  }

  public void setPostName(String post_name) {
	this.post_name = post_name;
  }

  public String getPostCode() {
	return post_code;
  }

  public void setPostCode(String post_code) {
	this.post_code = post_code;
  }

  public String getPositionName() {
	return position_name;
  }

  public void setPositionName(String position_name) {
	this.position_name = position_name;
  }

  public String getPayrollType() {
	  return payroll_type;
  }
  public void setPayrollType(String type) {
	  this.payroll_type = type;
  }

  public String getPayrollName() {
	  return payroll_name;
  }
  public void setPayrollName(String name) {
	  this.payroll_name = name;
  }

  public String getPayrollCode() {
	  return payroll_code;
  }
  public void setPayrollCode(String code) {
	  this.payroll_code = code;
  }

  public ALDateTimeField getviewMonth() {
	  return view_month;
  }
  public void setviewMonth(ALDateTimeField view_month) {
	  this.view_month = view_month;
  }
}
