/*
 * Copyright(C) 2012 - 2013 orinos Co.,Ltd. All rights reserved.
 * http://www.orinos.co.jp/
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

package com.aimluck.eip.modules.actions.event;

import org.apache.jetspeed.portal.portlets.VelocityPortlet;
import org.apache.jetspeed.services.logging.JetspeedLogFactoryService;
import org.apache.jetspeed.services.logging.JetspeedLogger;
import org.apache.jetspeed.services.rundata.JetspeedRunData;
import org.apache.turbine.util.RunData;
import org.apache.velocity.context.Context;

import com.aimluck.eip.common.ALEipConstants;
import com.aimluck.eip.event.EventSelectData;
//import com.aimluck.eip.event.util.MeyasuUtils;
import com.aimluck.eip.modules.actions.common.ALBaseAction;
import com.aimluck.eip.util.ALEipUtils;

/**
 * イベントのアクションクラスです。 <BR>
 *
 */
public class EventAction extends ALBaseAction {

  /** logger */
  private static final JetspeedLogger logger = JetspeedLogFactoryService
    .getLogger(EventAction.class.getName());

  /**
   * 通常表示の際の処理を記述します。 <BR>
   *
   * @param portlet
   * @param context
   * @param rundata
   * @throws Exception
   */
  @Override
  protected void buildNormalContext(VelocityPortlet portlet, Context context,
      RunData rundata) throws Exception {

    // セッション情報のクリア
	  clearEventSession(rundata, context);

    ALEipUtils.setTemp(rundata, context, ALEipConstants.ENTITY_ID, ALEipUtils
      .getPortlet(rundata, context)
      .getPortletConfig()
      .getInitParameter("p1b-rows")
      .trim());
    EventSelectData listData = new EventSelectData();
    listData.initField();
    listData.setRowsNum(Integer.parseInt(ALEipUtils
    	      .getPortlet(rundata, context)
    	      .getPortletConfig()
    	      .getInitParameter("p1b-rows")));

    //listData.loadEventIdList(rundata, context);
    //listData.doViewDetail(this, rundata, context);
    listData.doViewList(this, rundata, context);
    setTemplate(rundata, "event");
  }

  /**
   * 最大化表示の際の処理を記述します。 <BR>
   *
   * @param portlet
   * @param context
   * @param rundata
   */
  @Override
  protected void buildMaximizedContext(VelocityPortlet portlet,
      Context context, RunData rundata) {
    try {
      doEvent_list(rundata, context);
    } catch (Exception ex) {
      logger.error("Exception", ex);
    }

  }

  /**
   * Eventを一覧表示します。 <BR>
   *
   * @param rundata
   * @param context
   * @throws Exception
   */
  public void doEvent_list(RunData rundata, Context context) throws Exception {
    EventSelectData listData = new EventSelectData();
    listData.initField();
    // PSMLからパラメータをロードする
    // 最大表示件数（最大化時）
    listData.setRowsNum(Integer.parseInt(ALEipUtils
      .getPortlet(rundata, context)
      .getPortletConfig()
      .getInitParameter("p1b-rows")));
    listData.doViewList(this, rundata, context);
    setTemplate(rundata, "event-list");
  }

  private void clearEventSession(RunData rundata, Context context) {

    JetspeedRunData jdata = (JetspeedRunData) rundata;
    VelocityPortlet portlet = ((VelocityPortlet) context.get("portlet"));
    String peid = portlet.getID();

    // jdata.getUser().removeTemp(peid + "entityid");
    jdata.getUser().removeTemp(
      new StringBuffer(peid)
        .append("com.aimluck.eip.event.EventSelectDatasort")
        .toString());
    ALEipUtils.setTemp(rundata, context, "","");
    //EventUtils.resetFilter(rundata, context, this.getClass().getName());
  }
}
