/*
 * Copyright(C) 2012 - 2013 orinos Co.,Ltd. All rights reserved.
 * http://www.orinos.co.jp/
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

package com.aimluck.eip.event;

import java.util.Date;
import java.util.ArrayList;
import java.util.List;

import com.aimluck.commons.field.ALDateTimeField;
import com.aimluck.commons.field.ALNumberField;
import com.aimluck.commons.field.ALStringField;
import com.aimluck.eip.util.ALEipUtils;
import com.aimluck.eip.common.ALData;

/**
 * イベントのResultDataです。 <BR>
 *
 */
public class EventResultData implements ALData {


  /** イベントID */
  private ALNumberField event_id;
  /** イベント名 */
  private ALStringField event_name;
  /** 作成者ID */
  private ALNumberField create_id;
  /** 作成者名 */
  private String create_user_name;
  /** コメント  */
  private ALStringField comment;
  /** 締切日 */
  private ALDateTimeField closing_date;

  /** 締切フラグ */
  private String closing_flg;

  /** 登録日 */
  private Date create_date;

  /** 更新日 */
  private Date update_date;

  /** イベント参加者 */
  private List<EventMapResultData> event_map_result_data;

  /** 回答状況 **/
  private String user_status;

  /**
   *
   *
   */
  @Override
  public void initField() {
    event_id = new ALNumberField();
    event_name = new ALStringField();
    event_name.setNotNull(true);
    create_id = new ALNumberField();
    create_user_name = new String();
    comment = new ALStringField();
    closing_date = new ALDateTimeField("yyyy年MM月dd日");
    closing_flg = new String();

    create_date = new Date();
    update_date = new Date();

    event_map_result_data = new ArrayList<EventMapResultData>();

    user_status = new String();
  }




  /**
 * @return event_id
 */
public ALNumberField getEventId() {
	return this.event_id;
}

/**
 * @param event_id セットする event_id
 */
public void setEventId(String event_id) {
	this.event_id.setValue(event_id);
}




/**
 * @return event_name
 */
public ALStringField getEventName() {
	return this.event_name;
}


/**
 * @param event_name セットする event_name
 */
public void setEventName(String event_name) {
	this.event_name.setValue(event_name);
}




/**
 * @return create_id
 */
public ALNumberField getCreateId() {
	return this.create_id;
}


/**
 * @param create_id セットする create_id
 */
public void setCreateId(long create_id) {
	this.create_id.setValue(create_id);
}



/**
 * @return create_user_name
 */
public String getCreateUserName() {
	return this.create_user_name;
}


/**
 * @param create_user_name セットする create_user_name
 */
public void setCreateUserName(String create_user_name) {
	this.create_user_name = create_user_name;
}



/**
 * @return comment
 */
public String getComment() {
	return ALEipUtils.getMessageList(this.comment.toString());
}


/**
 * @param comment セットする comment
 */
public void setComment(String comment) {
	this.comment.setValue(comment);
}


/**
 * @return closing_date
 */
public ALDateTimeField getClosingDate() {
	return this.closing_date;
}


/**
 * @param closing_date セットする closing_date
 */
public void setClosingDate(Date closing_date) {
	this.closing_date.setValue(closing_date);
}




/**
   * @return
   */
  public ALDateTimeField getCreateDate() {
    ALDateTimeField date = new ALDateTimeField("yyyy年M月d日");
    date.setValue(create_date);
    return date;
  }

  /**
   * @return
   */
  public ALDateTimeField getUpdateDate() {
    return ALEipUtils.getFormattedTime(update_date);
  }

  /**
   * @param string
   */
  public void setCreateDate(Date date) {
    if (date == null) {
      return;
    }
    create_date = date;
  }

  /**
   * @param string
   */
  public void setUpdateDate(Date date) {
    if (date == null) {
      return;
    }
    update_date = date;
  }


/**
 * @return event_map_result_data
 */
public List<EventMapResultData> getEventMapResultData() {
	return event_map_result_data;
}

/**
 * @param event_map_result_data セットする event_map_result_data
 */
public void setEventMapResultData(
		List<EventMapResultData> event_map_result_data) {
	this.event_map_result_data = event_map_result_data;
}


/**
 * @return closing_flg
 */
public String getClosingFlg() {
	return closing_flg;
}


/**
 * @param closing_flg セットする closing_flg
 */
public void setClosingFlg(String closing_flg) {
	this.closing_flg = closing_flg;
}




/**
 * @return user_status
 */
public String getUserStatus() {
	return user_status;
}




/**
 * @param user_status セットする user_status
 */
public void setUserStatus(String user_status) {
	this.user_status = user_status;
}


}
