/*
 * Copyright(C) 2010 avanza Co.,Ltd. All rights reserved.
 * http://www.avnz.co.jp/
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 */

package com.aimluck.eip.enquete;

import com.aimluck.commons.field.ALNumberField;
import com.aimluck.commons.field.ALStringField;
import com.aimluck.eip.common.ALData;
import com.aimluck.eip.util.ALCommonUtils;
import com.aimluck.eip.util.ALEipUtils;

/**
 * EnqueteのResultDataです。 <BR>
 * 
 */
public class EnqueteSummaryListResultData implements ALData {

  
  /** アンケートID */
  private ALNumberField enquete_id;
  /** アンケート名 */
  private ALStringField name;
  /** コメント */
  private ALStringField comment;
  /** アンケート作成者 */
  private ALStringField creater_name;
  /** 公開方法（記名・無記名） */
  private String method;
  
  
  /**
   * 
   * @see com.aimluck.eip.common.ALData#initField()
   */
  public void initField() {
    enquete_id = new ALNumberField();
    name = new ALStringField();
    comment = new ALStringField();
    creater_name = new ALStringField();
    method = new String();
  }

  /**
   * @return
   */
  
  public ALNumberField getEnqueteId() {
    return enquete_id;
  }
  
  /**
   * @param i
   */
  public void setEnqueteId(long i) {
    enquete_id.setValue(i);
  }

  /**
   * @return
   */
  public String getName() {
    return ALCommonUtils.replaceToAutoCR(name.toString());
  }

  /**
   * @param string
   */
  public void setName(String string) {
    name.setValue(string);
  }

  /**
   * @return
   */
  public String getComment() {
    return ALEipUtils.getMessageList(comment.getValue());
  }

  /**
   * @param string
   */
  public void setComment(String string) {
    comment.setValue(string);
  }

  public ALStringField getCreaterName() {
    return creater_name;
  }

  public void setCreaterName(ALStringField creater_name) {
    this.creater_name = creater_name;
  }
  

  public String getMethod() {
    return method;
  }

  public void setMethod(String method) {
    this.method = method;
  }
}
