/*
 * Aipo is a groupware program developed by Aimluck,Inc.
 * Copyright (C) 2004-2011 Aimluck,Inc.
 * http://www.aipo.com
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

package com.aimluck.eip.account;

import com.aimluck.commons.field.ALNumberField;
import com.aimluck.commons.field.ALStringField;
import com.aimluck.eip.common.ALData;

/**
 * 有給のResultDataです。 <br />
 */
public class AccountUserPaidResultData implements ALData {

  /** ユーザーID */
  private ALNumberField user_id;

  /** 有給付与月 */
  private ALStringField grant_ym;

  /** 有給時間 */
  private ALNumberField paid_time;

  /** 有給時間  時間フォーマット*/
  private ALStringField str_fm_paid_time;

  /** 年月 */
  private ALStringField ym;

  /** 使用日数 */
  private ALStringField use_days;

  /** 残有給日 */
  private ALStringField remnant_days;


  /**
   *
   *
   */
  public void initField() {
	user_id = new ALNumberField();
	grant_ym = new ALStringField();
	paid_time = new ALNumberField();
	str_fm_paid_time = new ALStringField();
	ym = new ALStringField();
	use_days = new ALStringField();
	remnant_days = new ALStringField();

  }


/**
 * @return user_id
 */
public ALNumberField getUserId() {
	return user_id;
}


/**
 * @return grant_ym
 */
public ALStringField getGrantYm() {
	return grant_ym;
}


/**
 * @return paid_time
 */
public ALNumberField getPaidTime() {
	return paid_time;
}


/**
 * @return str_fm_paid_time
 */
public ALStringField getStrFmPaidTime() {
	return str_fm_paid_time;
}


/**
 * @return ym
 */
public ALStringField getYm() {
	return ym;
}


/**
 * @return use_days
 */
public ALStringField getUseDays() {
	return use_days;
}


/**
 * @return remnant_days
 */
public ALStringField getRemnantDays() {
	return remnant_days;
}


/**
 * @param user_id セットする user_id
 */
public void setUserId(int user_id) {
	this.user_id.setValue(user_id);
}


/**
 * @param grant_ym セットする grant_ym
 */
public void setGrantYm(String grant_ym) {
	this.grant_ym.setValue(grant_ym);
}


/**
 * @param paid_time セットする paid_time
 */
public void setPaidTime(int paid_time) {
	this.paid_time.setValue(paid_time);
}


/**
 * @param str_fm_paid_time セットする str_fm_paid_time
 */
public void setStrFmPaidTime(String str_fm_paid_time) {
	this.str_fm_paid_time.setValue(str_fm_paid_time);
}


/**
 * @param ym セットする ym
 */
public void setYm(String ym) {
	this.ym.setValue(ym);
}


/**
 * @param use_days セットする use_days
 */
public void setUseDays(String use_days) {
	this.use_days.setValue(use_days);
}


/**
 * @param remnant_days セットする remnant_days
 */
public void setRemnantDays(String remnant_days) {
	this.remnant_days.setValue(remnant_days);
}


}
