/*
 * Aipo is a groupware program developed by Aimluck,Inc.
 * Copyright (C) 2004-2011 Aimluck,Inc.
 * http://www.aipo.com
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

package com.aimluck.eip.account;

import com.aimluck.commons.field.ALNumberField;
import com.aimluck.commons.field.ALStringField;
import com.aimluck.eip.common.ALData;

/**
 * 『役職』のResultDataです。 <br />
 */
public class AccountPositionResultData implements ALData {

  /** 役職ID */
  private ALNumberField position_id;

  /** 役職名 */
  private ALStringField position_name;

  /** 登録日 */
  private ALStringField create_date;

  /** 更新日 */
  private ALStringField update_date;

  /** 目安箱通知先フラグ **/
  private ALStringField superior_flg;

  /** みなし残業時間 */
  private ALNumberField deemed_overtime_hours;

  /**
   *
   *
   */
  public void initField() {
    position_id = new ALNumberField();
    position_name = new ALStringField();
    create_date = new ALStringField();
    update_date = new ALStringField();

    superior_flg = new ALStringField();
    deemed_overtime_hours = new ALNumberField();

  }

  /**
   * @return
   */
  public ALStringField getCreateDate() {
    return create_date;
  }

  /**
   * @return
   */
  public ALNumberField getPositionId() {
    return position_id;
  }

  /**
   * @return
   */
  public ALStringField getPositionName() {
    return position_name;
  }

  /**
   * @return
   */
  public ALStringField getUpdateDate() {
    return update_date;
  }

  /**
   * @param string
   */
  public void setCreateDate(String string) {
    create_date.setValue(string);
  }

  /**
   * @param id
   */
  public void setPositionId(int id) {
    position_id.setValue(id);
  }

  /**
   * @param string
   */
  public void setPositionName(String string) {
    position_name.setValue(string);
  }

  /**
   * @param string
   */
  public void setUpdate_date(String string) {
    update_date.setValue(string);
  }

  /**
   * @return superior_flg
   */
  public ALStringField getSuperiorFlg() {
    return superior_flg;
  }

  /**
   * @param superior_flg セットする superior_flg
   */
  public void setSuperiorFlg(String str) {
    superior_flg.setValue(str);
  }

  /**
   * @return deemed_overtime_hours
   */
  public ALNumberField getDeemedOvertimeHours() {
    return deemed_overtime_hours;
  }

  /**
   * @param deemed_overtime_hours セットする deemed_overtime_hours
   */
  public void setDeemedOvertimeHours(int val) {
    deemed_overtime_hours.setValue(val);
  }


}
