package com.aimluck.eip.cayenne.om.portlet;

import org.apache.cayenne.ObjectId;

import com.aimluck.eip.cayenne.om.portlet.auto._AvzTLunchUserOrder;

public class AvzTLunchUserOrder extends _AvzTLunchUserOrder {
  public static final String USER_ID_COLUMN = "USER_ID";
  public static final String ITEM_ID_COLUMN = "ITEM_ID";
  public static final String ORDER_AMOUNT_COLUMN = "ORDER_AMOUNT";
  
  public Integer getId() {
    if (getObjectId() != null && !getObjectId().isTemporary()) {
      Object obj = getObjectId().getIdSnapshot().get(ID_PK_COLUMN);
      if (obj instanceof Long) {
        Long value = (Long) obj;
        return Integer.valueOf(value.intValue());
      } else {
        return (Integer) obj;
      }
    } else {
      return null;
    }
  }

  public void setId(String id) {
    setObjectId(new ObjectId("AvzTLunchOrderItem", ID_PK_COLUMN, Integer
        .valueOf(id)));
  }
}



