/*
 * Decompiled with CFR 0.152.
 */
package org.snmp4j.smi;

import java.io.IOException;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedList;
import java.util.StringTokenizer;
import org.snmp4j.asn1.BER;
import org.snmp4j.asn1.BERInputStream;
import org.snmp4j.smi.AbstractVariable;
import org.snmp4j.smi.AssignableFromByteArray;
import org.snmp4j.smi.AssignableFromString;
import org.snmp4j.smi.OID;

public class OctetString
extends AbstractVariable
implements AssignableFromByteArray,
AssignableFromString {
    private static final long serialVersionUID = 4125661211046256289L;
    private static final char DEFAULT_HEX_DELIMITER = ':';
    private byte[] value = new byte[0];

    public OctetString() {
    }

    public OctetString(byte[] rawValue) {
        this(rawValue, 0, rawValue.length);
    }

    public OctetString(byte[] rawValue, int offset, int length) {
        this.value = new byte[length];
        System.arraycopy(rawValue, offset, this.value, 0, length);
    }

    public OctetString(String stringValue) {
        this.value = stringValue.getBytes();
    }

    public OctetString(OctetString other) {
        this.value = new byte[0];
        this.append(other);
    }

    public void append(byte b) {
        byte[] newValue = new byte[this.value.length + 1];
        System.arraycopy(this.value, 0, newValue, 0, this.value.length);
        newValue[this.value.length] = b;
        this.value = newValue;
    }

    public void append(byte[] bytes) {
        byte[] newValue = new byte[this.value.length + bytes.length];
        System.arraycopy(this.value, 0, newValue, 0, this.value.length);
        System.arraycopy(bytes, 0, newValue, this.value.length, bytes.length);
        this.value = newValue;
    }

    public void append(OctetString octetString) {
        this.append(octetString.getValue());
    }

    public void append(String string) {
        this.append(string.getBytes());
    }

    public void clear() {
        this.value = new byte[0];
    }

    public void encodeBER(OutputStream outputStream) throws IOException {
        BER.encodeString(outputStream, (byte)4, this.getValue());
    }

    public void decodeBER(BERInputStream inputStream) throws IOException {
        BER.MutableByte type = new BER.MutableByte();
        byte[] v = BER.decodeString(inputStream, type);
        if (type.getValue() != 4) {
            throw new IOException("Wrong type encountered when decoding OctetString: " + type.getValue());
        }
        this.setValue(v);
    }

    public int getBERLength() {
        return this.value.length + BER.getBERLengthOfLength(this.value.length) + 1;
    }

    public int getSyntax() {
        return 4;
    }

    public final byte get(int index) {
        return this.value[index];
    }

    public final void set(int index, byte b) {
        this.value[index] = b;
    }

    public int hashCode() {
        int hash = 0;
        for (int i = 0; i < this.value.length; ++i) {
            hash += this.value[i] * 31 ^ this.value.length - 1 - i;
        }
        return hash;
    }

    public boolean equals(Object o) {
        if (o instanceof OctetString) {
            OctetString other = (OctetString)o;
            return Arrays.equals(this.value, other.value);
        }
        if (o instanceof byte[]) {
            return Arrays.equals(this.value, (byte[])o);
        }
        return false;
    }

    public int compareTo(Object o) {
        if (o instanceof OctetString) {
            OctetString other = (OctetString)o;
            int maxlen = Math.min(this.value.length, other.value.length);
            for (int i = 0; i < maxlen; ++i) {
                if (this.value[i] == other.value[i]) continue;
                if ((this.value[i] & 0xFF) < (other.value[i] & 0xFF)) {
                    return -1;
                }
                return 1;
            }
            return this.value.length - other.value.length;
        }
        throw new ClassCastException(o.getClass().getName());
    }

    public OctetString substring(int beginIndex, int endIndex) {
        if (beginIndex < 0 || endIndex > this.length()) {
            throw new IndexOutOfBoundsException();
        }
        byte[] substring = new byte[endIndex - beginIndex];
        System.arraycopy(this.value, beginIndex, substring, 0, substring.length);
        return new OctetString(substring);
    }

    public boolean startsWith(OctetString prefix) {
        if (prefix == null || prefix.length() > this.length()) {
            return false;
        }
        for (int i = 0; i < prefix.length(); ++i) {
            if (prefix.get(i) == this.value[i]) continue;
            return false;
        }
        return true;
    }

    public boolean isPrintable() {
        for (int i = 0; i < this.value.length; ++i) {
            char c = (char)this.value[i];
            if (!Character.isISOControl(c) && (c & 0xFF) < 128 || Character.isWhitespace(c) && ((c & 0xFF) < 28 || (c & 0xFF) > 31)) continue;
            return false;
        }
        return true;
    }

    public String toString() {
        if (this.isPrintable()) {
            return new String(this.value);
        }
        return this.toHexString();
    }

    public String toHexString() {
        return this.toHexString(':');
    }

    public String toHexString(char separator) {
        return this.toString(separator, 16);
    }

    public static OctetString fromHexString(String hexString) {
        return OctetString.fromHexString(hexString, ':');
    }

    public static OctetString fromHexString(String hexString, char delimiter) {
        return OctetString.fromString(hexString, delimiter, 16);
    }

    public static OctetString fromString(String string, char delimiter, int radix) {
        String delim = "";
        delim = delim + delimiter;
        StringTokenizer st = new StringTokenizer(string, delim);
        byte[] value = new byte[st.countTokens()];
        int n = 0;
        while (st.hasMoreTokens()) {
            String s = st.nextToken();
            value[n] = (byte)Integer.parseInt(s, radix);
            ++n;
        }
        return new OctetString(value);
    }

    public static OctetString fromString(String string, int radix) {
        int digits = (int)Math.round((double)((float)Math.log(256.0)) / Math.log(radix));
        byte[] value = new byte[string.length() / digits];
        for (int n = 0; n < string.length(); n += digits) {
            String s = string.substring(n, n + digits);
            value[n / digits] = (byte)Integer.parseInt(s, radix);
        }
        return new OctetString(value);
    }

    public String toString(char separator, int radix) {
        int digits = (int)Math.round((double)((float)Math.log(256.0)) / Math.log(radix));
        StringBuffer buf = new StringBuffer(this.value.length * (digits + 1));
        for (int i = 0; i < this.value.length; ++i) {
            if (i > 0) {
                buf.append(separator);
            }
            int v = this.value[i] & 0xFF;
            String val = Integer.toString(v, radix);
            for (int j = 0; j < digits - val.length(); ++j) {
                buf.append('0');
            }
            buf.append(val);
        }
        return buf.toString();
    }

    public String toString(int radix) {
        int digits = (int)Math.round((double)((float)Math.log(256.0)) / Math.log(radix));
        StringBuffer buf = new StringBuffer(this.value.length * (digits + 1));
        for (int i = 0; i < this.value.length; ++i) {
            int v = this.value[i] & 0xFF;
            String val = Integer.toString(v, radix);
            for (int j = 0; j < digits - val.length(); ++j) {
                buf.append('0');
            }
            buf.append(val);
        }
        return buf.toString();
    }

    public String toASCII(char placeholder) {
        StringBuffer buf = new StringBuffer(this.value.length);
        for (int i = 0; i < this.value.length; ++i) {
            if (Character.isISOControl((char)this.value[i]) || (this.value[i] & 0xFF) >= 128) {
                buf.append(placeholder);
                continue;
            }
            buf.append((char)this.value[i]);
        }
        return buf.toString();
    }

    public void setValue(String value) {
        this.setValue(value.getBytes());
    }

    public void setValue(byte[] value) {
        if (value == null) {
            throw new IllegalArgumentException("OctetString must not be assigned a null value");
        }
        this.value = value;
    }

    public byte[] getValue() {
        return this.value;
    }

    public final int length() {
        return this.value.length;
    }

    public Object clone() {
        return new OctetString(this.value);
    }

    public int getBERPayloadLength() {
        return this.value.length;
    }

    public int toInt() {
        throw new UnsupportedOperationException();
    }

    public long toLong() {
        throw new UnsupportedOperationException();
    }

    public OctetString mask(OctetString mask) {
        byte[] masked = new byte[this.value.length];
        System.arraycopy(this.value, 0, masked, 0, this.value.length);
        for (int i = 0; i < mask.length() && i < masked.length; ++i) {
            masked[i] = (byte)(masked[i] & mask.get(i));
        }
        return new OctetString(masked);
    }

    public OID toSubIndex(boolean impliedLength) {
        int[] subIndex;
        int offset = 0;
        if (!impliedLength) {
            subIndex = new int[this.length() + 1];
            subIndex[offset++] = this.length();
        } else {
            subIndex = new int[this.length()];
        }
        for (int i = 0; i < this.length(); ++i) {
            subIndex[offset + i] = this.get(i) & 0xFF;
        }
        return new OID(subIndex);
    }

    public void fromSubIndex(OID subIndex, boolean impliedLength) {
        if (impliedLength) {
            this.setValue(subIndex.toByteArray());
        } else {
            OID suffix = new OID(subIndex.getValue(), 1, subIndex.size() - 1);
            this.setValue(suffix.toByteArray());
        }
    }

    public static final Collection split(OctetString octetString, OctetString delimOctets) {
        LinkedList<OctetString> parts = new LinkedList<OctetString>();
        int maxDelim = -1;
        for (int i = 0; i < delimOctets.length(); ++i) {
            int delim = delimOctets.get(i) & 0xFF;
            if (delim <= maxDelim) continue;
            maxDelim = delim;
        }
        int startPos = 0;
        for (int i = 0; i < octetString.length(); ++i) {
            int c = octetString.value[i] & 0xFF;
            boolean isDelim = false;
            if (c <= maxDelim) {
                for (int j = 0; j < delimOctets.length(); ++j) {
                    if (c != (delimOctets.get(j) & 0xFF)) continue;
                    if (startPos >= 0 && i > startPos) {
                        parts.add(new OctetString(octetString.value, startPos, i - startPos));
                    }
                    startPos = -1;
                    isDelim = true;
                }
            }
            if (isDelim || startPos >= 0) continue;
            startPos = i;
        }
        if (startPos >= 0) {
            parts.add(new OctetString(octetString.value, startPos, octetString.length() - startPos));
        }
        return parts;
    }

    public static OctetString fromByteArray(byte[] value) {
        if (value == null) {
            return null;
        }
        return new OctetString(value);
    }

    public byte[] toByteArray() {
        return this.getValue();
    }
}

