/*
 * Decompiled with CFR 0.152.
 */
package jp.co.dolinc.snmp;

import org.snmp4j.CommandResponderEvent;
import org.snmp4j.MessageException;
import org.snmp4j.PDU;
import org.snmp4j.mp.StateReference;
import org.snmp4j.mp.StatusInformation;
import org.snmp4j.smi.AbstractVariable;
import org.snmp4j.smi.Integer32;
import org.snmp4j.smi.IpAddress;
import org.snmp4j.smi.Null;
import org.snmp4j.smi.OID;
import org.snmp4j.smi.OctetString;
import org.snmp4j.smi.TimeTicks;
import org.snmp4j.smi.UnsignedInteger32;
import org.snmp4j.smi.Variable;

public class BaseCommandResponder {
    protected void sendResonse(CommandResponderEvent snmpEvent, PDU responsePDU) throws MessageException {
        StatusInformation statusInfo = new StatusInformation();
        StateReference stateRef = snmpEvent.getStateReference();
        snmpEvent.getMessageDispatcher().returnResponsePdu(snmpEvent.getMessageProcessingModel(), snmpEvent.getSecurityModel(), snmpEvent.getSecurityName(), snmpEvent.getSecurityLevel(), responsePDU, snmpEvent.getMaxSizeResponsePDU(), stateRef, statusInfo);
    }

    protected Variable getVariableFromString(String valueStr) {
        char type = ' ';
        String value = null;
        if (valueStr != null && valueStr.length() >= 3) {
            type = valueStr.charAt(1);
            int pos = valueStr.indexOf(125);
            value = valueStr.substring(pos + 1);
        }
        return this.createVariableFromString(type, value);
    }

    protected Variable createVariableFromString(char type, String value) {
        AbstractVariable variable;
        switch (type) {
            case 'i': {
                variable = new Integer32(Integer.parseInt(value));
                break;
            }
            case 'u': {
                variable = new UnsignedInteger32(Long.parseLong(value));
                break;
            }
            case 's': {
                variable = new OctetString(value);
                break;
            }
            case 'x': {
                variable = OctetString.fromString(value, ':', 16);
                break;
            }
            case 'd': {
                variable = OctetString.fromString(value, '.', 10);
                break;
            }
            case 'b': {
                variable = OctetString.fromString(value, ' ', 2);
                break;
            }
            case 'n': {
                variable = new Null();
                break;
            }
            case 'o': {
                variable = new OID(value);
                break;
            }
            case 't': {
                variable = new TimeTicks(Long.parseLong(value));
                break;
            }
            case 'a': {
                variable = new IpAddress(value);
                break;
            }
            default: {
                variable = new Null();
            }
        }
        return variable;
    }

    protected String getVariableFromError(String valueStr) {
        int type = 32;
        String value = null;
        if (valueStr != null && valueStr.length() >= 3) {
            type = valueStr.charAt(1);
            int pos = valueStr.indexOf(125);
            value = valueStr.substring(pos + 1);
        }
        if (type == 101) {
            return value;
        }
        return null;
    }

    protected String getVariableFromTimeout(String valueStr) {
        int type = 32;
        String value = null;
        if (valueStr != null && valueStr.length() >= 3) {
            type = valueStr.charAt(1);
            int pos = valueStr.indexOf(125);
            value = valueStr.substring(pos + 1);
        }
        if (type == 48) {
            return value;
        }
        return null;
    }
}

