/*
 * Decompiled with CFR 0.152.
 */
package jp.co.dolinc.file;

import java.text.SimpleDateFormat;
import java.util.Date;
import jp.co.dolinc.aglib.FileAccess;
import jp.co.dolinc.aglib.StdLib;
import org.snmp4j.smi.VariableBinding;

public class LogRecRes {
    private String fileName = null;
    private FileAccess fileAccess = null;

    public LogRecRes(String fileName) {
        Date date1 = new Date();
        SimpleDateFormat sdf1 = new SimpleDateFormat("yyyyMMddHHmmssZ");
        this.fileName = String.valueOf(StdLib.removeFileExtension(fileName)) + sdf1.format(date1) + "." + StdLib.getFileExtension(fileName);
        this.fileAccess = new FileAccess(this.fileName);
    }

    public void open() {
        this.fileAccess.writeOpen();
    }

    public void close() {
        this.fileAccess.writeClose();
    }

    public void outLog(VariableBinding recive, VariableBinding response) {
        StringBuffer outStr = new StringBuffer();
        try {
            Object os = null;
            outStr.append(recive.getOid().toString());
            if (!recive.isException()) {
                outStr.append(",");
                outStr.append(recive.getVariable().toString());
            } else {
                outStr.append("Error:exception");
            }
            outStr.append("->");
            outStr.append(response.getOid().toString());
            outStr.append(",");
            if (!response.isException()) {
                outStr.append(response.getVariable().toString());
            } else {
                outStr.append("Error:exception");
            }
            this.fileAccess.writePrintln(outStr.toString());
        }
        catch (Exception ex) {
            this.fileAccess.writePrintln(ex.toString());
        }
    }

    public void outLog(VariableBinding recive, String error) {
        StringBuffer outStr = new StringBuffer();
        try {
            Object os = null;
            outStr.append(recive.getOid().toString());
            if (!recive.isException()) {
                outStr.append(",");
                outStr.append(recive.getVariable().toString());
            } else {
                outStr.append("Error:exception");
            }
            outStr.append("->");
            outStr.append(recive.getOid().toString());
            outStr.append(",");
            outStr.append(error);
            this.fileAccess.writePrintln(outStr.toString());
        }
        catch (Exception ex) {
            this.fileAccess.writePrintln(ex.toString());
        }
    }
}

