package org.routine_work.android_r.layout.list_item;

import android.app.ListActivity;
import android.content.Intent;
import android.os.Bundle;
import android.view.Menu;
import android.view.MenuInflater;
import android.view.MenuItem;
import android.view.View;
import android.widget.ListView;
import android.widget.SimpleAdapter;
import android.widget.TextView;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.routine_work.android_r.AppConstants;
import org.routine_work.android_r.PreferencesActivity;
import org.routine_work.android_r.R;

public class ListItemExampleActivity extends ListActivity
	implements SimpleAdapter.ViewBinder, ListItemExampleConstants
{

	private static final int DEFAULT_LIST_ITEM_LAYOUT_ID = android.R.layout.simple_list_item_2;
	private static final String DEFAULT_LIST_ITEM_LAYOUT_NAME = "simple_list_item_2";
	private List<Map<String, String>> userList;

	/** Called when the activity is first created. */
	@Override
	public void onCreate(Bundle savedInstanceState)
	{
		super.onCreate(savedInstanceState);
		setContentView(R.layout.simple_list_activity);

		// get name and id from Intent
		int listItemLayoutID = getIntent().getExtras().getInt(EXTRA_LIST_ITEM_LAYOUT_ID, DEFAULT_LIST_ITEM_LAYOUT_ID);
		String listItemLayoutName = getIntent().getExtras().getString(EXTRA_LIST_ITEM_LAYOUT_NAME);
		if (listItemLayoutName == null || listItemLayoutName.length() == 0)
		{
			listItemLayoutName = DEFAULT_LIST_ITEM_LAYOUT_NAME;
		}

		setTitle(listItemLayoutName);

		// initialize list adapter
		SimpleAdapter simpleListAdapter = new SimpleAdapter(this, getUserList(),
			listItemLayoutID, USER_MAPPING_FROM, USER_MAPPING_TO);
		simpleListAdapter.setViewBinder(this);
		setListAdapter(simpleListAdapter);

		// initialize ListView
		ListView listView = (ListView) findViewById(android.R.id.list);
		if (listItemLayoutID == android.R.layout.simple_list_item_single_choice)
		{
			listView.setChoiceMode(ListView.CHOICE_MODE_SINGLE);
		}
		else
		{
			listView.setChoiceMode(ListView.CHOICE_MODE_MULTIPLE);
		}
	}

	@Override
	public boolean onCreateOptionsMenu(Menu menu)
	{
		MenuInflater menuInflater = getMenuInflater();

		menuInflater.inflate(R.menu.preference_menu, menu);
		menuInflater.inflate(R.menu.quit_menu, menu);

		return true;
	}

	@Override
	public boolean onOptionsItemSelected(MenuItem item)
	{
		boolean result = false;

		switch (item.getItemId())
		{
			case R.id.preference_menuitem:
				Intent preferencesIntent = new Intent(this, PreferencesActivity.class);
				startActivityForResult(preferencesIntent, AppConstants.REQUEST_CHILD_ACTIVITY);
				result = true;
				break;
			case R.id.quit_menuitem:
				setResult(AppConstants.RESULT_QUIT);
				finish();
				result = true;
				break;
			default:
				result = super.onOptionsItemSelected(item);
		}

		return result;
	}

	@Override
	protected void onActivityResult(int requestCode, int resultCode, Intent data)
	{
		switch (requestCode)
		{
			case AppConstants.REQUEST_CHILD_ACTIVITY:
				if (resultCode == AppConstants.RESULT_QUIT)
				{
					setResult(resultCode);
					finish();
				}
				break;
		}
	}

	/**
	 * SimpleAdapter.ViewBinder
	 * @param view
	 * @param object
	 * @param text
	 * @return 
	 */
	@Override
	public boolean setViewValue(View view, Object object, String text)
	{
		boolean result = false;
		if (view instanceof TextView)
		{
			TextView textView = (TextView) view;
			textView.setText(text);
			result = true;
		}
		return result;
	}

	private List<Map<String, String>> getUserList()
	{
		if (userList == null)
		{
			// initialize userList
			userList = new ArrayList<Map<String, String>>();
			String[] userNames = getResources().getStringArray(R.array.names);
			for (String name : userNames)
			{
				Map<String, String> user = new HashMap<String, String>();
				user.put(KEY_NAME, name);
				user.put(KEY_EMAIL, name.toLowerCase() + "@example.com");
				user.put(KEY_ICON, String.valueOf(android.R.drawable.sym_def_app_icon));
				userList.add(user);
			}
		}
		return userList;
	}
}
