#!/bin/sh
#
# wizard̐` http://wiki.tcl.tk/8053 B 
#
# the next line restarts using wish \
exec wish "$0" "$@"

package require -exact snack 2.2
package require Tktable

# version 1.1
# - (ǉ) wb_ꗗǉ(wavwb_ꗗ\{^ŕ\)B
# - (C) wb_̈قȂwavt@CQłȂG[CB(Uraw`ŏôǂݍŌ悤ɂ)
# - (ǉ) EɃvOXo[\悤ɂB
# - (ύX) tH_̏lύXitclt@CŎsꍇlBexeł͕ύXȂj

#
# wizardp̃y[W
#
proc wizard {toplevel pages} {
  toplevel $toplevel
  set page_list {}

  for {set i 1} {$i <= $pages} {incr i} {
    ;# set finish {}
    set page $toplevel.p$i
    frame $page
    frame $page.page
    lappend page_list $page.page
    button $page.p -text "O <<" -command [list move $page.page -1]
    button $page.n -text ">> " -command [list move $page.page 1]
    button $page.e -text "I"    -command finish
    if {$i == 1 || $i == 4 || $i == 7} {
      $page.p configure -state disabled
      $page.n configure -state disabled
    } elseif {$i == 3 || $i == 6} {
      $page.n configure -state disabled
    } elseif {$i == 5} {
      $page.p configure -command [list move $page.page -4]
    }
    grid $page.page -columnspan 4  -sticky nsew
    ;# grid $page.p $page.n {*}$finish
    grid $page.p $page.n $page.e
    grid columnconfigure $page 3 -weight 1
    grid rowconfigure $page 0 -weight 1
  }
  return $page_list
}

#---------------------------------------------------
#
# y[Wړ
#
proc move {page {offset 0}} {
  global pageTitle

  set page [winfo parent $page]
  regexp {^(.*\.p)([0-9]+)$} $page -> root number
  if [moveConfirm $number $offset] return
  pack forget $page
  set newnumber [expr {$number + $offset}]
  set newpage "$root$newnumber"
  pack $newpage -fill both -expand 1
  set title [lindex $pageTitle [expr $newnumber - 1]]
  wm title [winfo toplevel $newpage] $title
}

#---------------------------------------------------
#
# I
#
proc finish {} {
  destroy .
  exit
}

#---------------------------------------------------
# Ώۂ̃fBNgw肷
#
proc chooseDir {initDir} {
  set d [tk_chooseDirectory -initialdir $initDir -title "tH_̑I"]
  if {$d != ""} {
    return $d
  } else {
    return $initDir
  }
}

#---------------------------------------------------
# ۑwavt@Cw肷
#
proc chooseSaveWav {initDir initFile mode} {
  set openTypes [ list {{MS Wav Files} {.wav}} {{All Files} {*}} ]
  if {$mode == "w"} {
    set d [tk_getSaveFile \
      -initialdir $initDir -initialfile $initFile -filetypes $openTypes \
      -defaultextension "wav"]
  } else {
    set d [tk_getOpenFile \
      -initialdir $initDir -initialfile $initFile -filetypes $openTypes \
      -defaultextension "wav"]
  }

  if {$d != ""} {
    return $d
  } else {
    return $initFile
  }
}

#---------------------------------------------------
# ۑlabt@Cw肷
#
proc chooseSaveLab {initDir initFile mode} {
  set openTypes [ list \
    {{pxt@C} {.txt}} \
    {{xt@C(ԂłΗp)} {.lab}} \
    {{All Files} {*}} ]
  if {$mode == "w"} {
    set d [tk_getSaveFile \
      -initialdir $initDir -initialfile $initFile -filetypes $openTypes \
      -defaultextension "lab"]
  } else {
    set d [tk_getOpenFile \
      -initialdir $initDir -initialfile $initFile -filetypes $openTypes \
      -defaultextension "lab"]
  }

  if {$d != ""} {
    return $d
  } else {
    return $initFile
  }
}

#---------------------------------------------------
# y[Wړł邩̃`FbNȂǁBړs\Ȃ1Ԃ
#
proc moveConfirm {page offset} {
  global procDir

  if {$page == 2 && $offset == 1} {
    set filenames [glob -nocomplain [format "%s/*.wav" $procDir]]
    if {$filenames == ""} {
      tk_messageBox -title "G[" \
        -message "w肵tH_ɂwavt@C܂B"
      return 1
    }
  }
  return 0
}

#---------------------------------------------------
# procDir/*.waṽwb_e{
#
proc viewHeaders {} {
  global procDir headerList

  if {[file exists $procDir] == 0} {
    tk_messageBox -title "G[" -message "$procDir ܂B"
    return
  }

  set filenames [glob -nocomplain [format "%s/*.wav" $procDir]]
  if {[llength $filenames] < 1} {
    tk_messageBox -title "G[" \
      -message "w肵tH_ɂwavt@C܂B"
    return
  }

  array unset headerList
  set headerList(0,0) "t@C"
  set headerList(0,1) "TvOg"
  set headerList(0,2) "GR[fBO"
  set headerList(0,3) "`l"
  set headerList(0,4) "Tv"
  set headerList(0,5) "ől"
  set headerList(0,6) "ŏl"
  set headerList(0,7) "wb_TCY"
  array unset kindNum
  set kindNum($headerList(0,1)) 0
  set kindNum($headerList(0,2)) 0
  set kindNum($headerList(0,3)) 0
  set r 1
  foreach fn $filenames {
    snack::sound sndTmp0 -load $fn
    set tmpHeader [sndTmp0 info]

    set headerList($r,0) [file tail $fn]          ;# t@C
    set headerList($r,1) [lindex $tmpHeader 1]    ;# TvOg
    set headerList($r,2) [lindex $tmpHeader 4]    ;# GR[fBO
    set headerList($r,3) [lindex $tmpHeader 5]    ;# `l
    set headerList($r,4) [lindex $tmpHeader 0]    ;# Tv
    set headerList($r,5) [lindex $tmpHeader 2]    ;# ől
    set headerList($r,6) [lindex $tmpHeader 3]    ;# ŏl
    set headerList($r,7) [lindex $tmpHeader 7]    ;# wb_TCY

    if {$headerList(1,1) != $headerList($r,1)} {
      incr kindNum($headerList(0,1))
    }
    if {$headerList(1,2) != $headerList($r,2)} {
      incr kindNum($headerList(0,2))
    }
    if {$headerList(1,3) != $headerList($r,3)} {
      incr kindNum($headerList(0,3))
    }

    incr r
  }
  set rSize $r
  set cSize 8

  # \
  set w .headerWindow
  toplevel $w
  set table [table $w.t -variable headerList -rows $rSize -cols $cSize \
    -colwidth 19 \
    -multiline 0 -selectmode extended \
    -titlerows 1 -titlecols 1 -selecttitle 0 \
    -colstretchmode none -rowstretchmode none \
    -padx 1 -pady 1 \
    -xscrollcommand "$w.x set" -yscrollcommand "$w.y set" ]
  scrollbar $w.x -command "$table xview" -orient horizontal
  scrollbar $w.y -command "$table yview" -orient vertical
  grid $table $w.y -sticky news
  grid $w.x -sticky news
  grid rowconfigure $w 0 -weight 1
  grid columnconfigure $w 0 -weight 1
  $table tag configure active -bg #A0A0A0  ;# ANeBuȃZ̔wiF
  $table tag configure none   -bg #C0C050  ;# pxÕZ̔wiF

  bind Table <MouseWheel> {
    if {%D > 0} {
      ::tk::table::MoveCell $table  -1 0  ;# 
    } else {
      ::tk::table::MoveCell $table   1 0  ;# 
    }
    $table selection anchor active
  }

  $table tag delete diff   ;# diff^O
  for {set r 2} {$r < $rSize} {incr r} {
    for {set c 1} {$c <= 3} {incr c} {
      if {$headerList(1,$c) != $headerList($r,$c)} {
        $table tag celltag diff $r,$c   ;# diff^Ot
      }
    }
  }
  $table tag configure diff -bg #C0C050  ;# wb_̈ႤZ̐Fς

  ;# wb_ꂳĂȂΒʒm
  set msg ""
  if {$kindNum($headerList(0,1)) > 0} {
    set msg "$headerList(0,1)A"
  }
  if {$kindNum($headerList(0,2)) > 0} {
    set msg "$msg $headerList(0,2)A"
  }
  if {$kindNum($headerList(0,3)) > 0} {
    set msg "$msg $headerList(0,3)A"
  }
  if {$msg != ""} {
    set msg "$msg ꂳĂ܂B"
    tk_messageBox -title "" -message "$msg"
  }
}


#---------------------------------------------------
# procDir/*.wav$saveWavFilename ɕۑ
#
proc wavJoin {} {
  global procDir saveWavFilename saveLabFilename

  if {[file extension $saveLabFilename] == ".lab"} {
    set labType waves
  } else {
    set labType wavTar
  }

  if {[file exists $procDir] == 0} {
    tk_messageBox -title "G[" -message "$procDir ܂B"
    return
  }

  set filenames [glob -nocomplain [format "%s/*.wav" $procDir]]
  if {[llength $filenames] < 1} {
    tk_messageBox -title "G[" \
      -message "w肵tH_ɂwavt@C܂B"
    return
  }
  set fp [open $saveLabFilename w]

  if {$labType == "waves"} {
    puts $fp "#"
  }

  initProgressWindow

  # P߂wavt@C荞Ńwb_𓾂
  set fn [lindex $filenames 0]
  set filenames [lreplace $filenames 0 0]
  snack::sound sndTmp0 -load $fn
  set outHeader [sndTmp0 info]

  # rawt@CŏočĂѓǂݍ
  set workfile $saveWavFilename.raw
  sndTmp0 write $workfile -fileformat RAW -byteorder littleEndian
  snack::sound snd -load $workfile \
    -rate     [lindex $outHeader 1] \
    -encoding [lindex $outHeader 4] \
    -channels [lindex $outHeader 5] \
    -fileformat RAW \
    -byteorder littleEndian

  set ln [file rootname [file tail $fn]]
  if {$labType == "waves"} {
    set p [snd length -unit SECONDS]
    puts $fp "    $p 121 E_$ln"
  } else {
    set p [snd length]
    puts $fp "$p $ln"
  }
  set cnt 1
  updateProgressWindow [expr 100 * $cnt / [llength $filenames]]

  foreach fn $filenames {
    # wavt@Crawt@CɏočĂѓǂݍ
    snack::sound sndTmp2 -load $fn
    sndTmp2 write $workfile -fileformat RAW -byteorder littleEndian
    snack::sound sndTmp3 -load $workfile \
      -rate     [lindex $outHeader 1] \
      -encoding [lindex $outHeader 4] \
      -channels [lindex $outHeader 5] \
      -fileformat RAW \
      -byteorder littleEndian
    # 
    snd concatenate sndTmp3
    set ln [file rootname [file tail $fn]]
    if {$labType == "waves"} {
      set p [snd length -unit SECONDS]
      puts $fp "    $p 121 E_$ln"
    } else {
      set p [snd length]
      puts $fp "$p $ln"
    }
    incr cnt
    updateProgressWindow [expr 100 * $cnt / [llength $filenames]]
  }

  # wavt@Cۑ
  snd write $saveWavFilename -fileformat WAV
  file delete $workfile

  close $fp
  deleteProgressWindow

  tk_messageBox -title "I" \
    -message "$cnt wavt@C܂B"

  # ̉ʂֈړ
  move .wzrd.p3.page 1
}

#---------------------------------------------------
# $saveWavFilename 𕪉 saveDir ɕۑ
#
proc wavSplit {} {
  global saveDir saveWavFilename saveLabFilename

  if {[file exists $saveWavFilename] == 0} {
    tk_messageBox -title "G[" -message "$saveWavFilename ܂B"
    return
  }

  if {[file exists $saveLabFilename] == 0} {
    tk_messageBox -title "G[" -message "$saveLabFilename ܂B"
    return
  }

  if {[file exists $saveDir] == 0} {
      file mkdir $saveDir
  }

  snack::sound snd -load $saveWavFilename
  set sampleRate [snd cget -rate]

  if {[file extension $saveLabFilename] == ".lab"} {
    set labType waves
  } else {
    set labType wavTar
  }

  # num𓾂
  set fp [open $saveLabFilename r]
  if {$labType == "waves"} {
    while {! [eof $fp]} {
      if {[gets $fp] == "#"} break
    }
  }
  set num 0
  while {! [eof $fp]} {
    gets $fp
    incr num
  }
  close $fp

  # ߂ăt@CJČĂ
  set fp [open $saveLabFilename r]

  if {$labType == "waves"} {
    while {! [eof $fp]} {
      if {[gets $fp] == "#"} break
    }
  }

  initProgressWindow

  set cnt 0
  set start 0
  while {! [eof $fp]} {
    ;# sǂňʒuƃx擾
    set line [gets $fp]
    set end ""
    set ln ""
    if {$labType == "waves"} {
      regsub {^[[:space:]]+} $line "" line        ;# ŏ̋󔒂؂l
      regsub {[[:space:]]+$} $line "" line        ;# Ō̋󔒂؂l
      regsub -all {[[:space:]]+} $line " " line   ;# A̋󔒂؂l
      regsub {E_} $line "" line                   ;# x` E_ 폜
      set tmpList [split $line " "]
      set end [lindex $tmpList 0]
      set ln  [lindex $tmpList 2]
    } else {
      regsub {^[[:space:]]+} $line "" line        ;# ŏ̋󔒂؂l
      regsub {[[:space:]]+$} $line "" line        ;# Ō̋󔒂؂l
      regsub -all {[[:space:]]+} $line " " line   ;# A̋󔒂؂l
      set tmpList [split $line " "]
      set end [lindex $tmpList 0]
      set ln  [lindex $tmpList 1]
    }

    if {$end == "" || $ln == ""} continue

    if {$labType == "waves"} {
      set end [expr int($end * $sampleRate)]      ;# Pʕϊ:bTv
    }

    snd write "$saveDir/$ln.wav" -start $start -end $end

    set start $end
    incr cnt
    updateProgressWindow [expr 100 * $cnt / $num]
  }

  close $fp
  deleteProgressWindow

  tk_messageBox -title "I" \
    -message "$cnt wavt@Cɕ܂B"

  # ̉ʂֈړ
  move .wzrd.p6.page 1
}

#---------------------------------------------------
#   w肵Nς݂`FbNBNς݂ȂtH[JXB
#
proc isExist {w} {
  if [winfo exists $w] {
    raise $w
    focus $w
    return 1
  } else {
    return 0
  }
}

#---------------------------------------------------
# vOXo[ĕ\
#
proc initProgressWindow {{title "now processing..."}} {
  global prgWindow v
  if [isExist $prgWindow] return

  toplevel $prgWindow
  wm title $prgWindow $title
  wm attributes $prgWindow -toolwindow 1
  wm attributes $prgWindow -topmost 1
  bind $prgWindow <Escape> "destroy $prgWindow"
  set topg [split [wm geometry .] "x+"]
  set x [expr [lindex $topg 2] + [lindex $topg 0] / 2 - 100]
  set y [expr [lindex $topg 3] + [lindex $topg 1] / 2 - 5]
  wm geometry $prgWindow "+$x+$y"

  set v(progress) 0

  ttk::progressbar $prgWindow.p -length 200 -variable v(progress) -mode determinate
  pack $prgWindow.p

  raise $prgWindow
  focus $prgWindow
}

#---------------------------------------------------
# vOXo[XVBi󋵂$progress(0`100)Ŏw肷)
#
proc updateProgressWindow {progress} {
  global v prgWindow

  set v(progress) $progress
  raise $prgWindow
  focus $prgWindow
  update
}

#---------------------------------------------------
# vOXo[
#
proc deleteProgressWindow {} {
  global prgWindow
  destroy $prgWindow
}


#---------------------------
# ϐ
set pages [wizard .wzrd 7]               ;# y[WwA
set FONT {{lr oSVbN} 12 normal}
set v(appname) wavTar
set v(version) 1.1
set v(progress) 0
set prgWindow .prgWindow

# v(exe)=1..exêsĂB 0..activeTcltclt@CsĂ
if [regexp $v(appname) [info nameofexecutable]] {
  set v(exe) 1
} else {
  set v(exe) 0
}

# DLt@CۑfBNgȂ
if $v(exe) {
  set v(progDir) "[file dirname [info nameofexecutable]]"
} else {
  set v(progDir) "[pwd]"
}

# set procDir [file dirname [info script]]    ;# tH_
set procDir $v(progDir)    ;# tH_
set saveWavFilename "$v(progDir)/result.wav"
set saveLabFilename "$v(progDir)/result.txt"
set saveDir "$v(progDir)/result"  ;# ʂo͂tH_
set pageTitle {
  "wavTar - Jn" 
  "wavTar - Ff[^"
  "wavTar - FmF"
  "wavTar - F"
  "wavTar - Ff[^"
  "wavTar - FmF"
  "wavTar - F"
}

array unset headerList

#---------------------------
# Jn
set p 1
set frm($p) [frame .wzrd.p$p.page.f]
label $frm($p).l -text "$v(appname) - wav t@C/c[ ver. $v(version)" -font $FONT
text $frm($p).t -font $FONT -width 40 -height 5
$frm($p).t insert end {
eIŉB
}
pack $frm($p) -fill both -expand 1 -padx 10 -pady 10 -side top
frame $frm($p).f
pack [button $frm($p).f.join -text "wavt@CQ1wavt@CɌ" \
  -command { \
    set mode "join" ; \
    move .wzrd.p1.page 1 \
  } ] -expand 1 -pady 5
pack [button $frm($p).f.split -text "wavt@Cwavt@CQɕ" \
  -command { \
    set mode "split" ; \
    move .wzrd.p1.page 4 \
  } ] -expand 1 -pady 5
pack $frm($p).f -fill both -expand 1 -side bottom
pack $frm($p).l $frm($p).t


#---------------------------
# ʂQ - wavɕKvȃf[^̓
incr p
set frm($p) [frame .wzrd.p$p.page.f]
label $frm($p).l -text "wavt@CF ݒ" -font $FONT
text $frm($p).t -font $FONT -width 40 -height 5
$frm($p).t insert end {
wavt@CQ̂tH_Awavt@CApxt@Cw肵ĉB}
pack $frm($p) -fill both -expand 1 -padx 10 -pady 10 -side top
frame $frm($p).f

grid [label $frm($p).f.l00 -text "Ώۂ̃tH_F"] \
  -row 0 -column 0 -sticky e -ipady 2 -ipadx 2
grid [entry $frm($p).f.l01 -textvar procDir -relief solid -width 80] \
  -row 0 -column 1 -sticky w -ipady 2 -ipadx 2
grid [button $frm($p).f.b -text I -command \
  {set procDir [chooseDir $procDir]} ] \
  -row 0 -column 2 -sticky w -pady 2 -padx 2
grid [button $frm($p).f.b2 -text wavwb_ꗗ\ -command \
  {viewHeaders} ] \
  -row 0 -column 3 -sticky w -pady 2 -padx 2

grid [label $frm($p).f.l10 -text "wavt@CF"] \
  -row 1 -column 0 -sticky e -ipady 2 -ipadx 2
grid [entry $frm($p).f.l11 -textvar saveWavFilename -relief solid -width 80] \
  -row 1 -column 1 -sticky w -ipady 2 -ipadx 2
grid [button $frm($p).f.b12 -text I -command {\
  set saveWavFilename [chooseSaveWav $procDir $saveWavFilename w]}] \
  -row 1 -column 2 -sticky w -pady 2 -padx 2

grid [label $frm($p).f.l20 -text "pxt@CF"] \
  -row 2 -column 0 -sticky e -ipady 2 -ipadx 2
grid [entry $frm($p).f.l21 -textvar saveLabFilename -relief solid -width 80] \
  -row 2 -column 1 -sticky w -ipady 2 -ipadx 2
grid [button $frm($p).f.b22 -text I -command {\
  set saveLabFilename [chooseSaveLab $procDir $saveLabFilename w]}] \
  -row 2 -column 2 -sticky w -pady 2 -padx 2

#pack [entry $frm($p).f.l  -textvar procDir -relief solid] -side left -fill both -expand 1
#pack [button $frm($p).f.b -text I -command {set procDir [chooseDir $procDir]}] -side left
pack $frm($p).l -fill both -expand 1
pack $frm($p).f -fill both -expand 1 -side bottom
pack $frm($p).t -fill both -expand 1 -padx 2 -pady 2


#---------------------------
# ʂR - O̊mF
incr p
set frm($p) [frame .wzrd.p$p.page.f]
label $frm($p).l -text "wavt@CF mF" -font $FONT
text $frm($p).t -font $FONT -width 40 -height 5
$frm($p).t insert end {
ȉeŊԈႢȂ΁uwavvĉB}
pack $frm($p) -fill both -expand 1 -padx 10 -pady 10 -side top

pack [frame $frm($p).f -relief solid] -fill both -expand 1 -side bottom
pack [button $frm($p).f.b -text "wav" -command wavJoin] -side left -fill both -expand 1
pack $frm($p).l $frm($p).t -fill both -expand 1 -side top

pack [frame $frm($p).c] -fill both -expand 1 -side bottom -anchor w
grid [label $frm($p).c.l00 -text "Ώۂ̃tH_F"] \
  -row 0 -column 0 -sticky e -ipadx 2 -ipady 2
grid [label $frm($p).c.l01 -textvar procDir -fg red] \
  -row 0 -column 1 -sticky w -ipadx 2 -ipady 2
grid [label $frm($p).c.l10 -text "wavt@CF"] \
  -row 1 -column 0 -sticky e -ipadx 2 -ipady 2
grid [label $frm($p).c.l11 -textvar saveWavFilename -fg red] \
  -row 1 -column 1 -sticky w -ipadx 2 -ipady 2
grid [label $frm($p).c.l20 -text "pxt@CF"] \
  -row 2 -column 0 -sticky e -ipadx 2 -ipady 2
grid [label $frm($p).c.l21 -textvar saveLabFilename -fg red] \
  -row 2 -column 1 -sticky w -ipadx 2 -ipady 2


#---------------------------
# ʂS - I
incr p
set frm($p) [frame .wzrd.p$p.page.f]
label $frm($p).l -text "wavt@CF I" -font $FONT
text $frm($p).t -font $FONT -width 40 -height 5
$frm($p).t insert end {
I܂B}
pack $frm($p) -fill both -expand 1 -padx 10 -pady 10 -side top
frame $frm($p).f
pack [label $frm($p).f.l  -relief solid] -side left -fill both -expand 1
pack $frm($p).f -fill both -expand 1 -side bottom
pack $frm($p).l $frm($p).t

#---------------------------
# ʂT - wavɕKvȃf[^̓
incr p
set frm($p) [frame .wzrd.p$p.page.f]
label $frm($p).l -text "wavt@CF ݒ" -font $FONT
text $frm($p).t -font $FONT -width 40 -height 5
$frm($p).t insert end {
wavt@CApxt@CAo̓tH_w肵ĉB}
pack $frm($p) -fill both -expand 1 -padx 10 -pady 10 -side top
frame $frm($p).f

grid [label $frm($p).f.l10 -text "wavt@CF"] \
  -row 0 -column 0 -sticky e -ipady 2 -ipadx 2
grid [entry $frm($p).f.l11 -textvar saveWavFilename -relief solid -width 80] \
  -row 0 -column 1 -sticky w -ipady 2 -ipadx 2
grid [button $frm($p).f.b12 -text I -command {\
  set saveWavFilename [chooseSaveWav $saveDir $saveWavFilename r]}] \
  -row 0 -column 2 -sticky w -pady 2 -padx 2

grid [label $frm($p).f.l20 -text "pxt@CF"] \
  -row 1 -column 0 -sticky e -ipady 2 -ipadx 2
grid [entry $frm($p).f.l21 -textvar saveLabFilename -relief solid -width 80] \
  -row 1 -column 1 -sticky w -ipady 2 -ipadx 2
grid [button $frm($p).f.b22 -text I -command {\
  set saveLabFilename [chooseSaveLab $saveDir $saveLabFilename r]}] \
  -row 1 -column 2 -sticky w -pady 2 -padx 2

grid [label $frm($p).f.l00 -text "o̓tH_F"] \
  -row 2 -column 0 -sticky e -ipady 2 -ipadx 2
grid [entry $frm($p).f.l01 -textvar saveDir -relief solid -width 80] \
  -row 2 -column 1 -sticky w -ipady 2 -ipadx 2
grid [button $frm($p).f.b -text I -command \
  {set saveDir [chooseDir $saveDir]} ] \
  -row 2 -column 2 -sticky w -pady 2 -padx 2

pack $frm($p).l -fill both -expand 1
pack $frm($p).f -fill both -expand 1 -side bottom
pack $frm($p).t -fill both -expand 1 -padx 2 -pady 2


#---------------------------
# ʂU - O̊mF
incr p
set frm($p) [frame .wzrd.p$p.page.f]
label $frm($p).l -text "wavt@CF mF" -font $FONT
text $frm($p).t -font $FONT -width 40 -height 5
$frm($p).t insert end {
ȉeŊԈႢȂ΁uwavvĉB}
pack $frm($p) -fill both -expand 1 -padx 10 -pady 10 -side top

pack [frame $frm($p).f -relief solid] -fill both -expand 1 -side bottom
pack [button $frm($p).f.b -text "wav" -command wavSplit] -side left -fill both -expand 1
pack $frm($p).l $frm($p).t -fill both -expand 1 -side top

pack [frame $frm($p).c] -fill both -expand 1 -side bottom -anchor w
grid [label $frm($p).c.l10 -text "wavt@CF"] \
  -row 0 -column 0 -sticky e -ipadx 2 -ipady 2
grid [label $frm($p).c.l11 -textvar saveWavFilename -fg red] \
  -row 0 -column 1 -sticky w -ipadx 2 -ipady 2
grid [label $frm($p).c.l20 -text "pxt@CF"] \
  -row 1 -column 0 -sticky e -ipadx 2 -ipady 2
grid [label $frm($p).c.l21 -textvar saveLabFilename -fg red] \
  -row 1 -column 1 -sticky w -ipadx 2 -ipady 2
grid [label $frm($p).c.l00 -text "o̓tH_F"] \
  -row 2 -column 0 -sticky e -ipadx 2 -ipady 2
grid [label $frm($p).c.l01 -textvar saveDir -fg red] \
  -row 2 -column 1 -sticky w -ipadx 2 -ipady 2


#---------------------------
# ʂV - I
incr p
set frm($p) [frame .wzrd.p$p.page.f]
label $frm($p).l -text "wavt@CF I" -font $FONT
text $frm($p).t -font $FONT -width 40 -height 5
$frm($p).t insert end {
I܂B}
pack $frm($p) -fill both -expand 1 -padx 10 -pady 10 -side top
frame $frm($p).f
pack [label $frm($p).f.l  -relief solid] -side left -fill both -expand 1
pack $frm($p).f -fill both -expand 1 -side bottom
pack $frm($p).l $frm($p).t


# show the first page
move [lindex $pages 0]
wm title . wavTar
wm geometry . 300x200
wm withdraw .
wm protocol .wzrd WM_DELETE_WINDOW finish
wm protocol . WM_DELETE_WINDOW finish

bind .wzrd <F1> {console show}

